/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Category;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.secure.SecureXmlRpcClient;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.xmlrpcd.XmlrpcServer;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xmlrpcd.ExternalEventRecipient;

public final class XmlRpcNotifier {
    private static final String XMLRPC_SERVER_SUCCESS_COMMAND = "notifySuccess";
    private static final String XMLRPC_SERVER_FAILURE_COMMAND = "notifyFailure";
    private static final String XMLRPC_SERVER_RECEIVE_EVENT_COMMAND = "notifyReceivedEvent";
    private static final String XMLRPC_SERVICE_UP_COMMAND = "sendServiceUpEvent";
    private static final String XMLRPC_SERVICE_DOWN_COMMAND = "sendServiceDownEvent";
    private static final String XMLRPC_NODE_UP_COMMAND = "sendNodeUpEvent";
    private static final String XMLRPC_NODE_DOWN_COMMAND = "sendNodeDownEvent";
    private static final String XMLRPC_INTERFACE_UP_COMMAND = "sendInterfaceUpEvent";
    private static final String XMLRPC_INTERFACE_DOWN_COMMAND = "sendInterfaceDownEvent";
    private XmlrpcServer[] m_rpcServers;
    private int m_retries;
    private int m_elapseTime;
    private XmlRpcClient m_xmlrpcClient;
    private boolean m_verifyServer;
    private String m_localServer;
    private ExternalEventRecipient m_recipient;

    public XmlRpcNotifier(XmlrpcServer[] rpcServers, int retries, int elapseTime, boolean verifyServer, String localServer) {
        this.m_rpcServers = rpcServers;
        this.m_retries = retries;
        this.m_elapseTime = elapseTime;
        this.createConnection();
        this.m_verifyServer = verifyServer;
        if (this.m_verifyServer) {
            this.m_localServer = localServer;
        }
        InvocationHandler handler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return Boolean.TRUE;
            }
        };
        this.m_recipient = (ExternalEventRecipient)Proxy.newProxyInstance(ExternalEventRecipient.class.getClassLoader(), new Class[]{ExternalEventRecipient.class}, handler);
    }

    public boolean notifySuccess(long txNo, String uei, String message) {
        Object o = this.m_recipient.notifySuccess(txNo, uei, message);
        Vector<String> params = new Vector<String>();
        params.addElement(new String(new Long(txNo).toString()));
        params.addElement(new String(uei));
        params.addElement(new String(message));
        return this.sendXmlrpcRequest(XMLRPC_SERVER_SUCCESS_COMMAND, params);
    }

    public boolean notifyFailure(long txNo, String uei, String reason) {
        Object o = this.m_recipient.notifyFailure(txNo, uei, reason);
        Vector<String> params = new Vector<String>();
        params.addElement(new String(new Long(txNo).toString()));
        params.addElement(new String(uei));
        params.addElement(new String(reason));
        return this.sendXmlrpcRequest(XMLRPC_SERVER_FAILURE_COMMAND, params);
    }

    public boolean notifyReceivedEvent(long txNo, String uei, String message) {
        Object o = this.m_recipient.notifyReceivedEvent(txNo, uei, message);
        Vector<String> params = new Vector<String>();
        params.addElement(new String(new Long(txNo).toString()));
        params.addElement(new String(uei));
        params.addElement(new String(message));
        return this.sendXmlrpcRequest(XMLRPC_SERVER_RECEIVE_EVENT_COMMAND, params);
    }

    public boolean sendServiceDownEvent(Event event) {
        Object o = this.m_recipient.sendServiceDownEvent(this.getLabelForEventNode(event), event.getInterface(), event.getService(), "Not Available", this.getEventHost(event), event.getTime());
        Vector<String> params = new Vector<String>();
        params.addElement(new String(this.getLabelForEventNode(event)));
        params.addElement(new String(event.getInterface()));
        params.addElement(new String(event.getService()));
        params.addElement(new String("Not Available"));
        params.addElement(this.getEventHost(event));
        params.addElement(new String(event.getTime()));
        return this.sendXmlrpcRequest(XMLRPC_SERVICE_DOWN_COMMAND, params);
    }

    private String getEventHost(Event event) {
        return this.m_verifyServer ? this.m_localServer : event.getHost();
    }

    public boolean sendServiceUpEvent(Event event) {
        String host = this.getEventHost(event);
        String msg = "Not Available";
        Object o = this.m_recipient.sendServiceUpEvent(this.getLabelForEventNode(event), event.getInterface(), event.getService(), msg, this.getEventHost(event), event.getTime());
        Vector<String> params = new Vector<String>();
        params.addElement(new String(this.getLabelForEventNode(event)));
        params.addElement(new String(event.getInterface()));
        params.addElement(new String(event.getService()));
        params.addElement(new String(msg));
        params.addElement(this.getEventHost(event));
        params.addElement(new String(event.getTime()));
        return this.sendXmlrpcRequest(XMLRPC_SERVICE_UP_COMMAND, params);
    }

    public boolean sendInterfaceDownEvent(Event event) {
        Object o = this.m_recipient.sendInterfaceDownEvent(this.getLabelForEventNode(event), event.getInterface(), this.getEventHost(event), event.getTime());
        Vector<String> params = new Vector<String>();
        params.addElement(new String(this.getLabelForEventNode(event)));
        params.addElement(new String(event.getInterface()));
        params.addElement(this.getEventHost(event));
        params.addElement(new String(event.getTime()));
        return this.sendXmlrpcRequest(XMLRPC_INTERFACE_DOWN_COMMAND, params);
    }

    public boolean sendInterfaceUpEvent(Event event) {
        Object o = this.m_recipient.sendInterfaceUpEvent(this.getLabelForEventNode(event), event.getInterface(), this.getEventHost(event), event.getTime());
        Vector<String> params = new Vector<String>();
        params.addElement(new String(this.getLabelForEventNode(event)));
        params.addElement(new String(event.getInterface()));
        params.addElement(new String(event.getHost()));
        params.addElement(this.getEventHost(event));
        params.addElement(new String(event.getTime()));
        return this.sendXmlrpcRequest(XMLRPC_INTERFACE_UP_COMMAND, params);
    }

    public boolean sendNodeDownEvent(Event event) {
        Object o = this.m_recipient.sendNodeDownEvent(this.getLabelForEventNode(event), this.getEventHost(event), event.getTime());
        Vector<String> params = new Vector<String>();
        params.addElement(new String(this.getLabelForEventNode(event)));
        params.addElement(this.getEventHost(event));
        params.addElement(new String(event.getTime()));
        return this.sendXmlrpcRequest(XMLRPC_NODE_DOWN_COMMAND, params);
    }

    public boolean sendNodeUpEvent(Event event) {
        Object o = this.m_recipient.sendNodeUpEvent(this.getLabelForEventNode(event), this.getEventHost(event), event.getTime());
        Vector<String> params = new Vector<String>();
        params.addElement(new String(this.getLabelForEventNode(event)));
        params.addElement(this.getEventHost(event));
        params.addElement(new String(event.getTime()));
        return this.sendXmlrpcRequest(XMLRPC_NODE_UP_COMMAND, params);
    }

    private String getLabelForEventNode(Event event) {
        return this.getNodeLabel(event.getNodeid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNodeLabel(long nodeId) {
        Category log = ThreadCategory.getInstance(XmlRpcNotifier.class);
        Connection dbConn = null;
        String nodeLabel = null;
        try {
            dbConn = DataSourceFactory.getInstance().getConnection();
            if (log.isDebugEnabled()) {
                log.debug((Object)("getNodeLabel: retrieve node label for: " + nodeId));
            }
            PreparedStatement stmt = dbConn.prepareStatement("SELECT nodelabel FROM NODE WHERE nodeid = ?");
            stmt.setLong(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                nodeLabel = rs.getString(1);
            }
            stmt.close();
        }
        catch (SQLException sqle) {
            log.warn((Object)("SQL exception while retrieving nodeLabel for: " + nodeId), (Throwable)sqle);
        }
        finally {
            try {
                if (dbConn != null) {
                    dbConn.close();
                }
            }
            catch (SQLException e) {
                log.warn((Object)"Exception closing JDBC connection", (Throwable)e);
            }
        }
        return nodeLabel;
    }

    private boolean sendXmlrpcRequest(String command, Vector params) {
        Category log = ThreadCategory.getInstance(this.getClass());
        if (this.m_xmlrpcClient == null) {
            return false;
        }
        boolean success = false;
        for (int i = 0; i < this.m_retries; ++i) {
            try {
                Object reply = this.m_xmlrpcClient.execute(command, params);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Response from XMLRPC server: " + this.m_xmlrpcClient.getURL().toString() + "\n\t" + reply.toString()));
                }
                success = true;
            }
            catch (XmlRpcException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            if (success) break;
        }
        if (!success) {
            log.error((Object)("Can not communicate with XMLRPC server: " + this.m_xmlrpcClient.getURL().toString()));
        }
        return success;
    }

    public void createConnection() {
        Category log = ThreadCategory.getInstance(this.getClass());
        Vector<String> params = new Vector<String>();
        params.addElement(new String(new Long(0L).toString()));
        params.addElement(new String("uei.opennms.org/internal/capsd/xmlrpcNotification"));
        params.addElement(new String("test connection"));
        boolean success = false;
        for (int i = 0; i < this.m_rpcServers.length; ++i) {
            XmlrpcServer xServer = this.m_rpcServers[i];
            String url = xServer.getUrl();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Start to set up communication to XMLRPC server: " + url));
            }
            try {
                this.m_xmlrpcClient = new SecureXmlRpcClient(url);
            }
            catch (MalformedURLException e) {
                log.error((Object)("Failed to send message to XMLRPC server: " + url), (Throwable)e);
                continue;
            }
            for (int k = 0; k < this.m_retries; ++k) {
                try {
                    Object reply = this.m_xmlrpcClient.execute(XMLRPC_SERVER_RECEIVE_EVENT_COMMAND, params);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Response from XMLRPC server: " + url + "\n\t" + reply.toString()));
                    }
                    success = true;
                }
                catch (XmlRpcException e) {
                    log.error((Object)("Failed to send message to XMLRPC server: " + url), (Throwable)e);
                }
                catch (IOException e) {
                    log.error((Object)("Failed to send message to XMLRPC server: " + url), (Throwable)e);
                }
                if (success) break;
                try {
                    Thread.sleep(this.m_elapseTime);
                    continue;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            if (success) break;
        }
        if (!success) {
            log.error((Object)"Can not set up communication with any XMLRPC server");
            this.m_xmlrpcClient = null;
        }
    }
}

