/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.util.Enumeration;
import org.apache.log4j.Category;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.xmlrpcd.XmlrpcServer;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.netmgt.xmlrpcd.XmlRpcNotifier;

class EventQueueProcessor
implements Runnable,
PausableFiber {
    private FifoQueue m_eventQ;
    private int m_maxQSize;
    private XmlRpcNotifier m_notifier;
    private int m_status;
    private Thread m_worker;

    EventQueueProcessor(FifoQueue eventQ, XmlrpcServer[] rpcServers, int retries, int elapseTime, boolean verifyServer, String localServer, int maxQSize) {
        this.m_eventQ = eventQ;
        this.m_maxQSize = maxQSize;
        this.m_notifier = new XmlRpcNotifier(rpcServers, retries, elapseTime, verifyServer, localServer);
    }

    private void processEvent(Event event) {
        Category log = ThreadCategory.getInstance(this.getClass());
        String uei = event.getUei();
        if (uei == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Event received with null UEI, ignoring event");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("About to process event: " + event.getUei()));
        }
        long eventId = -1L;
        if (event.hasDbid()) {
            eventId = event.getDbid();
        }
        long nodeId = -1L;
        if (event.hasNodeid()) {
            nodeId = event.getNodeid();
        }
        String ipAddr = event.getInterface();
        String service = event.getService();
        String eventTime = event.getTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Event\nuei\t\t" + uei + "\neventid\t\t" + eventId + "\nnodeid\t\t" + nodeId + "\nipaddr\t\t" + ipAddr + "\nservice\t\t" + service + "\neventtime\t" + (eventTime != null ? eventTime : "<null>")));
        }
        if (uei.equals("uei.opennms.org/nodes/nodeLostService")) {
            if (!this.m_notifier.sendServiceDownEvent(event)) {
                this.pushBackEvent(event);
            }
        } else if (uei.equals("uei.opennms.org/nodes/interfaceDown")) {
            if (!this.m_notifier.sendInterfaceDownEvent(event)) {
                this.pushBackEvent(event);
            }
        } else if (uei.equals("uei.opennms.org/nodes/nodeDown")) {
            if (!this.m_notifier.sendNodeDownEvent(event)) {
                this.pushBackEvent(event);
            }
        } else if (uei.equals("uei.opennms.org/nodes/nodeUp")) {
            if (!this.m_notifier.sendNodeUpEvent(event)) {
                this.pushBackEvent(event);
            }
        } else if (uei.equals("uei.opennms.org/nodes/interfaceUp")) {
            if (!this.m_notifier.sendInterfaceUpEvent(event)) {
                this.pushBackEvent(event);
            }
        } else if (uei.equals("uei.opennms.org/nodes/nodeRegainedService")) {
            if (!this.m_notifier.sendServiceUpEvent(event)) {
                this.pushBackEvent(event);
            }
        } else if (uei.equals("uei.opennms.org/internal/capsd/xmlrpcNotification")) {
            this.xmlrpcNotificationEventHandler(event);
        }
    }

    private void xmlrpcNotificationEventHandler(Event event) {
        boolean validParameters;
        Category log = ThreadCategory.getInstance(this.getClass());
        long txNo = -1L;
        String sourceUei = null;
        String notification = null;
        int status = -1;
        Parms parms = event.getParms();
        if (parms != null) {
            String parmName = null;
            Value parmValue = null;
            String parmContent = null;
            Enumeration parmEnum = parms.enumerateParm();
            while (parmEnum.hasMoreElements()) {
                String temp;
                Parm parm = (Parm)parmEnum.nextElement();
                parmName = parm.getParmName();
                parmValue = parm.getValue();
                if (parmValue == null) continue;
                parmContent = parmValue.getContent();
                if (parmName.equals("txno")) {
                    temp = parmContent;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("ParmName: " + parmName + " /parmContent: " + parmContent));
                    }
                    try {
                        txNo = Long.valueOf(temp);
                    }
                    catch (NumberFormatException nfe) {
                        log.warn((Object)"Parameter txno cannot be non-numberic", (Throwable)nfe);
                        txNo = -1L;
                    }
                    continue;
                }
                if (parmName.equals("sourceUei")) {
                    sourceUei = parmContent;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("ParmName: " + parmName + " /parmContent: " + parmContent));
                    continue;
                }
                if (parmName.equals("eventMessage")) {
                    notification = parmContent;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("ParmName: " + parmName + " /parmContent: " + parmContent));
                    continue;
                }
                if (!parmName.equals("eventStatus")) continue;
                temp = parmContent;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ParmName: " + parmName + " /parmContent: " + parmContent));
                }
                try {
                    status = Integer.valueOf(temp);
                }
                catch (NumberFormatException nfe) {
                    log.warn((Object)"Parameter eventStatus cannot be non-numberic", (Throwable)nfe);
                    status = -1;
                }
            }
        }
        boolean bl = validParameters = txNo != -1L && sourceUei != null && notification != null && status != -1;
        if (!validParameters) {
            log.error((Object)"Invalid parameters.");
            return;
        }
        switch (status) {
            case 0: {
                if (this.m_notifier.notifyReceivedEvent(txNo, sourceUei, notification)) break;
                this.pushBackEvent(event);
                break;
            }
            case 1: {
                if (this.m_notifier.notifySuccess(txNo, sourceUei, notification)) break;
                this.pushBackEvent(event);
                break;
            }
            case 2: {
                if (this.m_notifier.notifyFailure(txNo, sourceUei, notification)) break;
                this.pushBackEvent(event);
            }
        }
    }

    private void pushBackEvent(Event event) {
        Category log = ThreadCategory.getInstance(this.getClass());
        try {
            if (this.m_eventQ.size() < this.m_maxQSize) {
                this.m_eventQ.add((Object)event);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Push the event back to queue.");
                }
            }
            this.m_notifier.createConnection();
        }
        catch (FifoQueueException e) {
            log.error((Object)"Failed to push the event back to queue", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error((Object)"Failed to push the event back to queue", (Throwable)e);
        }
    }

    private synchronized boolean statusOK() {
        Category log = ThreadCategory.getInstance(this.getClass());
        boolean exitThread = false;
        boolean exitCheck = false;
        while (!exitCheck) {
            if (!this.m_worker.isAlive() && this.m_status != 3) {
                log.warn((Object)(this.getName() + " terminated abnormally"));
                this.m_status = 3;
            }
            if (this.m_status == 3) {
                exitCheck = true;
                exitThread = true;
                this.m_status = 4;
                continue;
            }
            if (this.m_status == 5) {
                this.pause();
                continue;
            }
            if (this.m_status == 7) {
                this.resume();
                continue;
            }
            if (this.m_status == 6) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    this.m_status = 3;
                }
                continue;
            }
            if (this.m_status != 2) continue;
            exitCheck = true;
        }
        return !exitThread;
    }

    public synchronized void start() {
        Category log = ThreadCategory.getInstance(this.getClass());
        if (this.m_worker != null) {
            throw new IllegalStateException("The fiber is running or has already run");
        }
        this.m_status = 1;
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.getName() + " started"));
        }
    }

    public synchronized void pause() {
        if (this.m_worker == null || !this.m_worker.isAlive()) {
            throw new IllegalStateException("The fiber is not running");
        }
        this.m_status = 6;
        this.notifyAll();
    }

    public synchronized void resume() {
        if (this.m_worker == null || !this.m_worker.isAlive()) {
            throw new IllegalStateException("The fiber is not running");
        }
        this.m_status = 2;
        this.notifyAll();
    }

    public synchronized void stop() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never run");
        }
        this.m_status = 3;
        this.m_worker.interrupt();
        this.notifyAll();
    }

    public String getName() {
        return "EventQueueProcessor";
    }

    public synchronized int getStatus() {
        if (this.m_worker != null && !this.m_worker.isAlive()) {
            this.m_status = 4;
        }
        return this.m_status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Category log = ThreadCategory.getInstance(this.getClass());
        EventQueueProcessor eventQueueProcessor = this;
        synchronized (eventQueueProcessor) {
            this.m_status = 2;
        }
        while (this.statusOK()) {
            Object obj = null;
            try {
                obj = this.m_eventQ.remove(1000L);
            }
            catch (InterruptedException iE) {
                log.debug((Object)"Caught interrupted exception");
                log.debug((Object)iE.getLocalizedMessage(), (Throwable)iE);
                obj = null;
                this.m_status = 3;
            }
            catch (FifoQueueException qE) {
                log.debug((Object)"Caught fifo queue exception");
                log.debug((Object)qE.getLocalizedMessage(), (Throwable)qE);
                obj = null;
                this.m_status = 3;
            }
            if (obj == null || !this.statusOK()) continue;
            try {
                this.processEvent((Event)obj);
            }
            catch (Throwable t) {
                log.error((Object)"Unexpected error processing event", t);
            }
        }
    }
}

