/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import org.apache.log4j.Category;
import org.apache.log4j.PropertyConfigurator;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.ServiceConfigFactory;
import org.opennms.netmgt.config.service.Argument;
import org.opennms.netmgt.config.service.Attribute;
import org.opennms.netmgt.config.service.Invoke;
import org.opennms.netmgt.config.service.Service;
import org.opennms.netmgt.vmmgr.DatabaseChecker;
import org.opennms.netmgt.vmmgr.Starter;
import org.opennms.netmgt.vmmgr.StatusGetter;

public class Controller {
    private static final String JMX_HTTP_ADAPTER_NAME = ":Name=HttpAdaptorMgmt";
    public static final String DEFAULT_INVOKER_URL = "http://127.0.0.1:8181/invoke?objectname=OpenNMS%3AName=Manager";
    private static final String LOG4J_CATEGORY = "OpenNMS.Manager";
    private boolean m_verbose = false;
    private String m_invokeUrl = "http://127.0.0.1:8181/invoke?objectname=OpenNMS%3AName=Manager";

    public static void main(String[] argv) {
        String command;
        Controller.configureLog4j();
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        Controller c = new Controller();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-h")) {
                System.out.println("Usage: java org.opennms.netmgt.vmmgr.Controller [<options>] <command>");
                System.out.println("Accepted options:");
                System.out.println("        -v              Verbose mode.");
                System.out.println("        -u <URL>        Alternate invoker URL.");
                System.out.println("");
                System.out.println("Accepted commands: start, stop, status");
                System.out.println("");
                System.out.println("The default invoker URL is: http://127.0.0.1:8181/invoke?objectname=OpenNMS%3AName=Manager");
                System.exit(0);
                continue;
            }
            if (argv[i].equals("-v")) {
                c.setVerbose(true);
                continue;
            }
            if (argv[i].equals("-u")) {
                c.setInvokeUrl(argv[i + 1]);
                ++i;
                continue;
            }
            if (i == argv.length - 1) break;
            System.err.println("Invalid command-line option: \"" + argv[i] + "\".  Use \"-h\" option for help.");
            System.exit(1);
        }
        if (argv.length == 0) {
            System.err.println("You must specify a command.  Use \"-h\" option for help");
            System.exit(1);
        }
        if ("start".equals(command = argv[argv.length - 1])) {
            c.start();
        } else if ("stop".equals(command)) {
            c.stop();
        } else if ("status".equals(command)) {
            c.status();
        } else if ("check".equals(command)) {
            c.check();
        } else if ("exit".equals(command)) {
            c.exit();
        } else {
            System.err.println("Invalid command \"" + command + "\".");
            System.err.println("Use \"-h\" option for help.");
            System.exit(1);
        }
    }

    private static void configureLog4j() {
        File homeDir = new File(System.getProperty("opennms.home"));
        File etcDir = new File(homeDir, "etc");
        File controllerProperties = new File(etcDir, "log4j-controller.properties");
        PropertyConfigurator.configure((String)controllerProperties.getAbsolutePath());
    }

    public void start() {
        Starter starter = new Starter();
        starter.startDaemon();
    }

    public void stop() {
        this.invokeOperation("stop");
    }

    public void status() {
        int exitValue;
        String message;
        Authenticator.setDefault(this.getAuthenticator());
        StatusGetter statusGetter = new StatusGetter();
        statusGetter.setVerbose(this.isVerbose());
        String url = this.getInvokeUrl() + "&operation=status";
        try {
            statusGetter.setInvokeURL(new URL(url));
        }
        catch (MalformedURLException e) {
            message = "Error creating URL object for invoke URL: '" + url + "': " + e;
            System.err.println(message);
            Controller.log().error((Object)message, (Throwable)e);
        }
        try {
            statusGetter.queryStatus();
        }
        catch (Throwable t) {
            message = "Error invoking status command: " + t;
            System.err.println(message);
            Controller.log().error((Object)message, t);
            System.exit(1);
        }
        switch (statusGetter.getStatus()) {
            case NOT_RUNNING: 
            case CONNECTION_REFUSED: {
                exitValue = 3;
                break;
            }
            case PARTIALLY_RUNNING: {
                exitValue = 160;
                break;
            }
            case RUNNING: {
                exitValue = 0;
                break;
            }
            default: {
                message = "Unknown status returned from statusGetter.getStatus(): " + (Object)((Object)statusGetter.getStatus());
                System.err.println(message);
                Controller.log().error((Object)message);
                exitValue = 1;
            }
        }
        System.exit(exitValue);
    }

    public void check() {
        try {
            DatabaseChecker checker = new DatabaseChecker();
            checker.check();
        }
        catch (Throwable t) {
            Controller.log().error((Object)"error invoking check command", t);
            System.err.println(t);
            System.exit(1);
        }
        System.exit(0);
    }

    public void exit() {
        this.invokeOperation("doSystemExit");
    }

    private void invokeOperation(String operation) {
        Authenticator.setDefault(this.getAuthenticator());
        String urlString = this.getInvokeUrl() + "&operation=" + operation;
        try {
            int ch;
            URL invoke = new URL(urlString);
            InputStream in = invoke.openStream();
            while ((ch = in.read()) != -1) {
                System.out.write((char)ch);
            }
            in.close();
            System.out.println("");
            System.out.flush();
            System.exit(0);
        }
        catch (ConnectException e) {
            Controller.log().error((Object)(e.getMessage() + " when attempting to fetch URL \"" + urlString + "\""));
            if (this.isVerbose()) {
                System.out.println(e.getMessage() + " when attempting to fetch URL \"" + urlString + "\"");
            }
            System.exit(1);
        }
        catch (Throwable t) {
            Controller.log().error((Object)("error invoking " + operation + " operation"), t);
            System.out.println("error invoking " + operation + " operation");
            t.printStackTrace();
            System.exit(1);
        }
    }

    private Authenticator getAuthenticator() {
        Service service = this.getConfiguredService(JMX_HTTP_ADAPTER_NAME);
        if (service == null) {
            Controller.log().warn((Object)"Could not find configured service for ':Name=HttpAdaptorMgmt'");
            return null;
        }
        Attribute[] attribs = service.getAttribute();
        if (attribs == null) {
            return null;
        }
        boolean usingBasic = false;
        for (Attribute attrib : attribs) {
            if (!attrib.getName().equals("AuthenticationMethod")) continue;
            if (!attrib.getValue().getContent().equals("basic")) {
                Controller.log().error((Object)("AuthenticationMethod is \"" + attrib.getValue() + "\", but only \"basic\" is supported"));
                return null;
            }
            usingBasic = true;
            break;
        }
        if (!usingBasic) {
            return null;
        }
        Invoke[] invokes = service.getInvoke();
        if (invokes == null) {
            return null;
        }
        String username = null;
        String password = null;
        for (Invoke invoke : invokes) {
            Argument[] args;
            if (!invoke.getMethod().equals("addAuthorization") || (args = invoke.getArgument()) == null || args.length != 2 || !args[0].getContent().equals("manager")) continue;
            username = args[0].getContent();
            password = args[1].getContent();
            break;
        }
        if (username == null || password == null) {
            return null;
        }
        final String username_f = username;
        final String password_f = password;
        return new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username_f, password_f.toCharArray());
            }
        };
    }

    private ServiceConfigFactory getServiceConfigFactory() {
        try {
            ServiceConfigFactory.init();
            return ServiceConfigFactory.getInstance();
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    private Service getConfiguredService(String serviceName) {
        Service[] services;
        ServiceConfigFactory sfact = this.getServiceConfigFactory();
        for (Service service : services = sfact.getServices()) {
            if (!service.getName().equals(serviceName)) continue;
            return service;
        }
        return null;
    }

    private static Category log() {
        return ThreadCategory.getInstance(Category.class);
    }

    public boolean isVerbose() {
        return this.m_verbose;
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public String getInvokeUrl() {
        return this.m_invokeUrl;
    }

    public void setInvokeUrl(String invokerUrl) {
        this.m_invokeUrl = invokerUrl;
    }
}

