/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.exolab.castor.xml.Marshaller;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.utils.EventProxy;
import org.opennms.netmgt.utils.EventProxyException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;

public final class TcpEventProxy
implements EventProxy {
    private static final int s_default_port = 5817;
    private static final InetAddress s_default_host;
    private InetAddress m_target;
    private int m_port;

    public TcpEventProxy() {
        this(s_default_host, 5817);
    }

    public TcpEventProxy(int port) {
        this(s_default_host, port);
    }

    public TcpEventProxy(InetAddress target) {
        this(target, 5817);
    }

    public TcpEventProxy(String address, int port) throws UnknownHostException {
        this.m_port = port;
        this.m_target = InetAddress.getByName(address);
    }

    public TcpEventProxy(InetAddress target, int port) {
        this.m_port = port;
        this.m_target = target;
    }

    public void send(Event event) throws EventProxyException {
        Log elog = new Log();
        Events events = new Events();
        events.addEvent(event);
        elog.setEvents(events);
        this.send(elog);
    }

    public void send(Log eventLog) throws EventProxyException {
        Connection connection = null;
        try {
            connection = new Connection(this.m_target, this.m_port);
            Writer writer = connection.getWriter();
            Marshaller.marshal((Object)eventLog, (Writer)writer);
            writer.flush();
        }
        catch (Exception e) {
            throw new EventProxyException("Exception while sending event: " + e.getMessage(), e);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    static {
        try {
            s_default_host = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public class Connection {
        private Socket m_sock;
        private Writer m_writer;
        private Reader m_reader;
        private Thread m_rdrThread;

        public Connection(InetAddress target, int port) throws IOException {
            try {
                this.m_sock = new Socket(target, port);
            }
            catch (ConnectException e) {
                ConnectException n = new ConnectException("Could not connect to event daemon at " + target + " on port " + Integer.toString(port) + ": " + e.getMessage());
                n.initCause(e);
                throw n;
            }
            this.m_sock.setSoTimeout(500);
            this.m_writer = new OutputStreamWriter(new BufferedOutputStream(this.m_sock.getOutputStream()));
            this.m_reader = new InputStreamReader(this.m_sock.getInputStream());
            this.m_rdrThread = new Thread("TcpEventProxy Input Discarder"){

                public void run() {
                    int ch = 0;
                    while (ch != -1) {
                        try {
                            ch = Connection.this.m_reader.read();
                        }
                        catch (InterruptedIOException e) {
                            ch = 0;
                        }
                        catch (IOException e) {
                            ch = -1;
                        }
                    }
                }
            };
            this.m_rdrThread.setDaemon(true);
            this.m_rdrThread.start();
        }

        public Writer getWriter() {
            return this.m_writer;
        }

        public void close() {
            if (this.m_sock != null) {
                try {
                    this.m_sock.close();
                }
                catch (IOException e) {
                    ThreadCategory.getInstance(this.getClass()).warn((Object)"Error closing socket", (Throwable)e);
                }
            }
            this.m_sock = null;
            if (this.m_rdrThread.isAlive()) {
                this.m_rdrThread.interrupt();
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

