/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.util.Date;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Logmsg;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.event.Value;
import org.springframework.beans.BeanWrapperImpl;

public class EventBuilder {
    private Event m_event;

    public EventBuilder(String uei, String source) {
        this.m_event = new Event();
        this.m_event.setUei(uei);
        Date date = new Date();
        this.setTime(date);
        this.setCreationTime(date);
        this.setSource(source);
    }

    public EventBuilder(Event event) {
        this.m_event = event;
        Date date = new Date();
        this.setTime(date);
        this.setCreationTime(date);
    }

    public Event getEvent() {
        return this.m_event;
    }

    public EventBuilder setTime(Date date) {
        this.m_event.setTime(EventConstants.formatToString(date));
        return this;
    }

    public EventBuilder setCreationTime(Date date) {
        this.m_event.setCreationTime(EventConstants.formatToString(date));
        return this;
    }

    public EventBuilder setSource(String source) {
        this.m_event.setSource(source);
        return this;
    }

    public EventBuilder setNodeid(int nodeid) {
        this.m_event.setNodeid((long)nodeid);
        return this;
    }

    public EventBuilder setInterface(String ipAddress) {
        this.m_event.setInterface(ipAddress);
        return this;
    }

    public EventBuilder setService(String serviceName) {
        this.m_event.setService(serviceName);
        return this;
    }

    public EventBuilder addParam(String parmName, String val) {
        Value value = new Value();
        value.setContent(val);
        Parm parm = new Parm();
        parm.setParmName(parmName);
        parm.setValue(value);
        if (this.m_event.getParms() == null) {
            Parms parms = new Parms();
            this.m_event.setParms(parms);
        }
        this.m_event.getParms().addParm(parm);
        return this;
    }

    public EventBuilder addParam(String parmName, int val) {
        return this.addParam(parmName, Integer.toString(val));
    }

    public EventBuilder setNode(OnmsNode node) {
        this.m_event.setNodeid(node.getId().longValue());
        return this;
    }

    public EventBuilder setIpInterface(OnmsIpInterface iface) {
        this.m_event.setNodeid(iface.getNode().getId().longValue());
        this.m_event.setInterface(iface.getIpAddress());
        return this;
    }

    public EventBuilder setMonitoredService(OnmsMonitoredService monitoredService) {
        this.m_event.setNodeid(monitoredService.getNodeId().longValue());
        this.m_event.setInterface(monitoredService.getIpAddress());
        this.m_event.setService(monitoredService.getServiceName());
        return this;
    }

    public EventBuilder setSnmpVersion(String version) {
        this.ensureSnmp();
        this.m_event.getSnmp().setVersion(version);
        return this;
    }

    private void ensureSnmp() {
        if (this.m_event.getSnmp() == null) {
            this.m_event.setSnmp(new Snmp());
        }
    }

    public EventBuilder setEnterpriseId(String enterprise) {
        this.ensureSnmp();
        this.m_event.getSnmp().setId(enterprise);
        return this;
    }

    public EventBuilder setGeneric(int generic) {
        this.ensureSnmp();
        this.m_event.getSnmp().setGeneric(generic);
        return this;
    }

    public EventBuilder setSpecific(int specific) {
        this.ensureSnmp();
        this.m_event.getSnmp().setSpecific(specific);
        return this;
    }

    public EventBuilder setSnmpHost(String snmpHost) {
        this.m_event.setSnmphost(snmpHost);
        return this;
    }

    public void setField(String name, String val) {
        BeanWrapperImpl w = new BeanWrapperImpl((Object)this.m_event);
        w.setPropertyValue(name, (Object)val);
    }

    private void ensureLogmsg() {
        if (this.m_event.getLogmsg() == null) {
            this.m_event.setLogmsg(new Logmsg());
        }
    }

    public void setLogDest(String dest) {
        this.ensureLogmsg();
        this.m_event.getLogmsg().setDest(dest);
    }

    public void setLogMessage(String content) {
        this.ensureLogmsg();
        this.m_event.getLogmsg().setContent(content);
    }

    public void setDescription(String descr) {
        this.m_event.setDescr(descr);
    }
}

