/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.config.DataSourceFactory;

final class TrapdIPMgr {
    private static final String IP_LOAD_SQL = "SELECT ipAddr, nodeid FROM ipInterface";
    private static Map m_knownips = new HashMap();

    private TrapdIPMgr() {
        throw new UnsupportedOperationException("Construction is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void dataSourceSync() throws SQLException {
        Connection c = null;
        try {
            c = DataSourceFactory.getInstance().getConnection();
            Statement s = c.createStatement();
            ResultSet rs = s.executeQuery(IP_LOAD_SQL);
            if (rs != null) {
                m_knownips.clear();
                while (rs.next()) {
                    String ipstr = rs.getString(1);
                    long ipnodeid = rs.getLong(2);
                    m_knownips.put(ipstr, new Long(ipnodeid));
                }
                rs.close();
            }
            s.close();
        }
        finally {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    protected static synchronized long getNodeId(String addr) {
        if (addr == null) {
            return -1L;
        }
        return TrapdIPMgr.longValue((Long)m_knownips.get(addr));
    }

    protected static synchronized long setNodeId(String addr, long nodeid) {
        if (addr == null || nodeid == -1L) {
            return -1L;
        }
        return TrapdIPMgr.longValue(m_knownips.put(addr, new Long(nodeid)));
    }

    protected static synchronized long removeNodeId(String addr) {
        if (addr == null) {
            return -1L;
        }
        return TrapdIPMgr.longValue((Long)m_knownips.remove(addr));
    }

    protected static synchronized void clearKnownIpsMap() {
        m_knownips = new HashMap();
    }

    private static long longValue(Long result) {
        return result == null ? -1L : result;
    }
}

