/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.util.ArrayList;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventListener;
import org.opennms.netmgt.trapd.TrapdIPMgr;
import org.opennms.netmgt.xml.event.Event;

public final class BroadcastEventProcessor
implements EventListener {
    private EventIpcManager m_eventMgr;

    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    public void setEventManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    public void open() {
        this.verifyState();
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/nodeGainedInterface");
        ueiList.add("uei.opennms.org/nodes/interfaceDeleted");
        ueiList.add("uei.opennms.org/nodes/interfaceReparented");
        this.m_eventMgr.addEventListener((EventListener)this, ueiList);
    }

    public void close() {
        this.verifyState();
        this.m_eventMgr.removeEventListener(this);
    }

    private void verifyState() {
        if (this.m_eventMgr == null) {
            throw new IllegalStateException("event manager not set");
        }
    }

    public void onEvent(Event event) {
        Category log = ThreadCategory.getInstance(this.getClass());
        String eventUei = event.getUei();
        if (eventUei == null) {
            log.warn((Object)"Received an unexpected event with a null UEI");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received event: " + eventUei));
        }
        if (eventUei.equals("uei.opennms.org/nodes/nodeGainedInterface") || eventUei.equals("uei.opennms.org/nodes/interfaceReparented")) {
            String action;
            String string = action = eventUei.equals("uei.opennms.org/nodes/interfaceReparented") ? "reparent" : "add";
            if (Long.toString(event.getNodeid()) == null) {
                log.warn((Object)("Not " + action + "ing interface to known node list: " + "nodeId is null"));
            } else if (event.getInterface() == null) {
                log.warn((Object)("Not " + action + "ing interface to known node list: " + "interface is null"));
            } else {
                TrapdIPMgr.setNodeId(event.getInterface(), event.getNodeid());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Successfully " + action + "ed " + event.getInterface() + " to known node list"));
                }
            }
        } else if (eventUei.equals("uei.opennms.org/nodes/interfaceDeleted")) {
            if (event.getInterface() != null) {
                TrapdIPMgr.removeNodeId(event.getInterface());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed " + event.getInterface() + " from known node list"));
            }
        } else {
            log.warn((Object)("Received an unexpected event with UEI of \"" + eventUei + "\""));
        }
    }

    public String getName() {
        return "Trapd:BroadcastEventProcessor";
    }
}

