/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketd;

import java.io.Serializable;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.TroubleTicketState;
import org.opennms.netmgt.ticketd.Ticket;
import org.opennms.netmgt.ticketd.TicketerPlugin;
import org.opennms.netmgt.ticketd.TicketerServiceLayer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.Assert;

public class DefaultTicketerServiceLayer
implements TicketerServiceLayer,
InitializingBean {
    private AlarmDao m_alarmDao;
    private TicketerPlugin m_ticketerPlugin;

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public void setTicketerPlugin(TicketerPlugin ticketerPlugin) {
        this.m_ticketerPlugin = ticketerPlugin;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_alarmDao != null ? 1 : 0) != 0, (String)"alarmDao property must be set");
        Assert.state((this.m_ticketerPlugin != null ? 1 : 0) != 0, (String)"ticketPlugin property must be set");
    }

    public void cancelTicketForAlarm(int alarmId, String ticketId) {
        OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)Integer.valueOf(alarmId));
        if (alarm == null) {
            throw new ObjectRetrievalFailureException("Unable to locate Alarm with ID: " + alarmId, null);
        }
        this.setTicketState(ticketId, Ticket.State.CANCELLED);
        alarm.setTTicketState(TroubleTicketState.CANCELLED);
        this.m_alarmDao.saveOrUpdate((Object)alarm);
    }

    private void setTicketState(String ticketId, Ticket.State state) {
        Ticket ticket = this.m_ticketerPlugin.get(ticketId);
        ticket.setState(state);
        this.m_ticketerPlugin.saveOrUpdate(ticket);
    }

    public void closeTicketForAlarm(int alarmId, String ticketId) {
        OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)Integer.valueOf(alarmId));
        this.setTicketState(ticketId, Ticket.State.CLOSED);
        alarm.setTTicketState(TroubleTicketState.CLOSED);
        this.m_alarmDao.saveOrUpdate((Object)alarm);
    }

    public void createTicketForAlarm(int alarmId) {
        OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)Integer.valueOf(alarmId));
        Ticket ticket = this.createTicketFromAlarm(alarm);
        this.m_ticketerPlugin.saveOrUpdate(ticket);
        alarm.setTTicketId(ticket.getId());
        alarm.setTTicketState(TroubleTicketState.OPEN);
        this.m_alarmDao.saveOrUpdate((Object)alarm);
    }

    private Ticket createTicketFromAlarm(OnmsAlarm alarm) {
        Ticket ticket = new Ticket();
        ticket.setSummary(alarm.getLogMsg());
        ticket.setDetails(alarm.getDescription());
        ticket.setId(alarm.getTTicketId());
        return ticket;
    }

    public void updateTicketForAlarm(int alarmId, String ticketId) {
        OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)Integer.valueOf(alarmId));
        Ticket ticket = this.m_ticketerPlugin.get(ticketId);
        ticket.setState(Ticket.State.OPEN);
        ticket.setDetails(alarm.getDescription());
        this.m_ticketerPlugin.saveOrUpdate(ticket);
        alarm.setTTicketState(TroubleTicketState.OPEN);
        this.m_alarmDao.saveOrUpdate((Object)alarm);
    }
}

