/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd.jmx;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.ThreshdConfigFactory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.threshd.jmx.ThreshdMBean;

public class Threshd
implements ThreshdMBean {
    private static final String LOG4J_CATEGORY = "OpenNMS.Threshd";

    public void init() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        try {
            ThreshdConfigFactory.reload();
            ThresholdingConfigFactory.reload();
        }
        catch (MarshalException ex) {
            this.log().fatal((Object)"start: Failed to load threshd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().fatal((Object)"start: Failed to load threshd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().fatal((Object)"start: Failed to load threshd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        try {
            PollOutagesConfigFactory.reload();
        }
        catch (MarshalException ex) {
            this.log().fatal((Object)"start: Failed to load poll-outage configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().fatal((Object)"start: Failed to load poll-outage configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().fatal((Object)"start: Failed to load poll-outage configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        this.getInstance().setThreshdConfig(ThreshdConfigFactory.getInstance());
        this.getInstance().init();
    }

    private Category log() {
        return ThreadCategory.getInstance();
    }

    private org.opennms.netmgt.threshd.Threshd getInstance() {
        return org.opennms.netmgt.threshd.Threshd.getInstance();
    }

    public void start() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.getInstance().start();
    }

    public void stop() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.getInstance().stop();
    }

    public int getStatus() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return this.getInstance().getStatus();
    }

    public String status() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return Fiber.STATUS_NAMES[this.getStatus()];
    }

    public String getStatusText() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return Fiber.STATUS_NAMES[this.getStatus()];
    }
}

