/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.HashMap;
import java.util.Map;

final class ThresholderUpdates {
    private boolean m_hasUpdates;
    private Map m_properties;
    private boolean m_deletionFlag;
    private boolean m_reinitFlag;
    private boolean m_reparentFlag;
    private String m_reparentOldNodeId;
    private String m_reparentNewNodeId;

    ThresholderUpdates() {
        this.reset();
    }

    void reset() {
        this.m_hasUpdates = false;
        this.m_properties = null;
        this.m_deletionFlag = false;
        this.m_reinitFlag = false;
        this.m_reparentFlag = false;
        this.m_reparentOldNodeId = null;
        this.m_reparentNewNodeId = null;
    }

    void setAttribute(String property, Object value) {
        if (this.m_properties == null) {
            this.m_properties = new HashMap();
        }
        this.m_properties.put(property, value);
        this.m_hasUpdates = true;
    }

    Object getAttribute(String property) {
        Object rc = null;
        if (this.m_properties != null) {
            rc = this.m_properties.get(property);
        }
        return rc;
    }

    void markForDeletion() {
        this.m_deletionFlag = true;
        this.m_hasUpdates = true;
    }

    void markForReinitialization() {
        this.m_reinitFlag = true;
        this.m_hasUpdates = true;
    }

    void markForReparenting(String oldNodeId, String newNodeId) {
        this.m_reparentFlag = true;
        this.m_reparentOldNodeId = oldNodeId;
        this.m_reparentNewNodeId = newNodeId;
        this.m_hasUpdates = true;
    }

    String getReparentOldNodeId() {
        return this.m_reparentOldNodeId;
    }

    String getReparentNewNodeId() {
        return this.m_reparentNewNodeId;
    }

    boolean hasUpdates() {
        return this.m_hasUpdates;
    }

    boolean isDeletionFlagSet() {
        return this.m_deletionFlag;
    }

    boolean isReinitializationFlagSet() {
        return this.m_reinitFlag;
    }

    boolean isReparentingFlagSet() {
        return this.m_reparentFlag;
    }
}

