/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.util.Map;
import org.opennms.netmgt.threshd.ThresholdGroup;
import org.opennms.netmgt.threshd.ThresholdResourceType;
import org.opennms.netmgt.threshd.ThresholdsDao;
import org.opennms.netmgt.utils.ParameterMap;

public class SnmpThresholdConfiguration {
    private static final String DEFAULT_GROUP = "default";
    private static final int DEFAULT_INTERVAL = 300000;
    private static final int DEFAULT_RANGE = 0;
    private ThresholdGroup m_thresholdGroup;
    private int m_range;
    private int m_interval;

    public SnmpThresholdConfiguration(ThresholdsDao thresholdsDao, Map parms) {
        this.setRange(ParameterMap.getKeyedInteger(parms, "range", 0));
        this.setInterval(ParameterMap.getKeyedInteger(parms, "interval", 300000));
        this.setThresholdGroup(thresholdsDao.get(ParameterMap.getKeyedString(parms, "thresholding-group", DEFAULT_GROUP)));
    }

    public int getRange() {
        return this.m_range;
    }

    public void setRange(int range) {
        this.m_range = range;
    }

    public int getInterval() {
        return this.m_interval;
    }

    public void setInterval(int interval) {
        this.m_interval = interval;
    }

    public ThresholdGroup getThresholdGroup() {
        return this.m_thresholdGroup;
    }

    public void setThresholdGroup(ThresholdGroup thresholdGroup) {
        this.m_thresholdGroup = thresholdGroup;
    }

    public File getRrdRepository() {
        return this.m_thresholdGroup.getRrdRepository();
    }

    public String getGroupName() {
        return this.m_thresholdGroup.getName();
    }

    public ThresholdResourceType getIfResourceType() {
        return this.m_thresholdGroup.getIfResourceType();
    }

    public void setIfResourceType(ThresholdResourceType ifResourceType) {
        this.m_thresholdGroup.setIfResourceType(ifResourceType);
    }

    public ThresholdResourceType getNodeResourceType() {
        return this.m_thresholdGroup.getNodeResourceType();
    }

    public void setNodeResourceType(ThresholdResourceType nodeResourceType) {
        this.m_thresholdGroup.setNodeResourceType(nodeResourceType);
    }
}

