/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.dao.support.RrdFileConstants;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.ServiceThresholder;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdExpressionException;
import org.opennms.netmgt.threshd.ThresholdNetworkInterface;
import org.opennms.netmgt.utils.EventProxy;
import org.opennms.netmgt.utils.EventProxyException;
import org.opennms.netmgt.utils.IfLabel;
import org.opennms.netmgt.utils.ParameterMap;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JMXThresholder
implements ServiceThresholder {
    private static final String SQL_GET_NODEID = "SELECT nodeid FROM ipinterface WHERE ipAddr=? AND ismanaged!='D'";
    private static final int DEFAULT_INTERVAL = 300000;
    private static final int DEFAULT_RANGE = 0;
    static final String NODE_ID_KEY = "org.opennms.netmgt.collectd.JMXThresholder.NodeId";
    static final String RRD_REPOSITORY_KEY = "org.opennms.netmgt.collectd.JMXThresholder.RrdRepository";
    static final String NODE_THRESHOLD_MAP_KEY = "org.opennms.netmgt.collectd.JMXThresholder.NodeThresholdMap";
    static final String BASE_IF_THRESHOLD_MAP_KEY = "org.opennms.netmgt.collectd.JMXThresholder.IfThresholdMap";
    static final String ALL_IF_THRESHOLD_MAP_KEY = "org.opennms.netmgt.collectd.JMXThresholder.AllIfThresholdMap";
    private String serviceName = null;
    private boolean useFriendlyName = false;

    public void setServiceName(String name) {
        this.serviceName = name;
    }

    public String serviceName() {
        return this.serviceName.toUpperCase();
    }

    @Override
    public void initialize(Map parameters) {
        try {
            RrdUtils.initialize();
        }
        catch (RrdException e) {
            this.log().error((Object)("initialize: Unable to initialize RrdUtils: " + (Object)((Object)e)), (Throwable)e);
            throw new RuntimeException("Unable to initialize RrdUtils: " + (Object)((Object)e), e);
        }
        this.log().debug((Object)"initialize: successfully instantiated RRD strategy");
    }

    @Override
    public void reinitialize() {
    }

    @Override
    public void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(ThresholdNetworkInterface iface, Map parameters) {
        if (iface.getType() != 1) {
            throw new RuntimeException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        InetAddress ipAddr = (InetAddress)iface.getAddress();
        String groupName = ParameterMap.getKeyedString(parameters, "thresholding-group", this.serviceName);
        String repository = null;
        try {
            repository = ThresholdingConfigFactory.getInstance().getRrdRepository(groupName);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Thresholding group '" + groupName + "' does not exist.");
        }
        iface.setAttribute(RRD_REPOSITORY_KEY, repository);
        HashMap<String, ThresholdEntity> nodeMap = new HashMap<String, ThresholdEntity>();
        HashMap<String, ThresholdEntity> baseIfMap = new HashMap<String, ThresholdEntity>();
        try {
            for (Basethresholddef thresh : ThresholdingConfigFactory.getInstance().getThresholds(groupName)) {
                boolean newEntity = false;
                ThresholdEntity thresholdEntity = null;
                try {
                    BaseThresholdDefConfigWrapper wrapper = BaseThresholdDefConfigWrapper.getConfigWrapper(thresh);
                    if (wrapper.getDsType().equals("node")) {
                        thresholdEntity = (ThresholdEntity)nodeMap.get(wrapper.getDatasourceExpression());
                    } else if (wrapper.getDsType().equals("if")) {
                        thresholdEntity = (ThresholdEntity)baseIfMap.get(wrapper.getDatasourceExpression());
                    }
                    if (thresholdEntity == null) {
                        newEntity = true;
                        thresholdEntity = new ThresholdEntity();
                    }
                    try {
                        thresholdEntity.addThreshold(wrapper);
                    }
                    catch (IllegalStateException e) {
                        this.log().warn((Object)("Encountered duplicate " + thresh.getType() + " for datasource " + wrapper.getDatasourceExpression()), (Throwable)e);
                    }
                    if (!newEntity) continue;
                    if (thresh.getDsType().equals("node")) {
                        nodeMap.put(wrapper.getDatasourceExpression(), thresholdEntity);
                        continue;
                    }
                    if (!thresh.getDsType().equals("if")) continue;
                    baseIfMap.put(wrapper.getDatasourceExpression(), thresholdEntity);
                }
                catch (ThresholdExpressionException e) {
                    this.log().warn((Object)("Could not parse threshold expression: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Thresholding group '" + groupName + "' does not exist.");
        }
        iface.setAttribute(NODE_THRESHOLD_MAP_KEY, nodeMap);
        iface.setAttribute(BASE_IF_THRESHOLD_MAP_KEY, baseIfMap);
        iface.setAttribute(ALL_IF_THRESHOLD_MAP_KEY, new HashMap());
        Connection dbConn = null;
        try {
            dbConn = DataSourceFactory.getInstance().getConnection();
        }
        catch (SQLException e) {
            this.log().error((Object)("initialize: Failed getting connection to the database: " + e), (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        int nodeId = -1;
        try {
            PreparedStatement stmt = null;
            try {
                stmt = dbConn.prepareStatement(SQL_GET_NODEID);
                stmt.setString(1, ipAddr.getHostAddress());
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    nodeId = rs.getInt(1);
                    if (rs.wasNull()) {
                        nodeId = -1;
                    }
                }
                rs.close();
            }
            catch (SQLException e) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("initialize: SQL exception!!: " + e), (Throwable)e);
                }
                throw new RuntimeException("SQL exception while attempting to retrieve node id for interface " + ipAddr.getHostAddress() + ": " + e, e);
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
            if (nodeId == -1) {
                throw new RuntimeException("Unable to retrieve node id for interface " + ipAddr.getHostAddress());
            }
        }
        finally {
            try {
                dbConn.close();
            }
            catch (SQLException e) {
                this.log().info((Object)("initialize: SQLException while closing database connection: " + e), (Throwable)e);
            }
        }
        iface.setAttribute(NODE_ID_KEY, new Integer(nodeId));
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: dumping node thresholds defined for " + ipAddr.getHostAddress() + "/" + groupName + ":"));
            Iterator iter = nodeMap.values().iterator();
            while (iter.hasNext()) {
                this.log().debug((Object)((ThresholdEntity)iter.next()));
            }
            this.log().debug((Object)("initialize: dumping interface thresholds defined for " + ipAddr.getHostAddress() + "/" + groupName + ":"));
            iter = baseIfMap.values().iterator();
            while (iter.hasNext()) {
                this.log().debug((Object)((ThresholdEntity)iter.next()));
            }
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: initialization completed for " + ipAddr.getHostAddress()));
        }
    }

    @Override
    public void release(ThresholdNetworkInterface iface) {
    }

    @Override
    public int check(ThresholdNetworkInterface iface, EventProxy eproxy, Map parameters) {
        Category log = this.log();
        String dsDir = this.serviceName;
        String port = ParameterMap.getKeyedString(parameters, "port", null);
        String friendlyName = ParameterMap.getKeyedString(parameters, "friendly-name", port);
        int range = ParameterMap.getKeyedInteger(parameters, "range", 0);
        if (this.useFriendlyName) {
            dsDir = friendlyName;
        }
        InetAddress primary = (InetAddress)iface.getAddress();
        String groupName = ParameterMap.getKeyedString(parameters, "thresholding-group", this.serviceName);
        int interval = ParameterMap.getKeyedInteger(parameters, "interval", 300000);
        if (log.isDebugEnabled()) {
            log.debug((Object)("check: service= " + this.serviceName.toUpperCase() + " address= " + primary.getHostAddress() + " thresholding-group=" + groupName + " interval=" + interval + "mS range =  " + range + " mS"));
        }
        String repository = (String)iface.getAttribute(RRD_REPOSITORY_KEY);
        if (log.isDebugEnabled()) {
            log.debug((Object)("check: rrd repository=" + repository));
        }
        Integer nodeId = (Integer)iface.getAttribute(NODE_ID_KEY);
        Map nodeMap = (Map)iface.getAttribute(NODE_THRESHOLD_MAP_KEY);
        Map baseIfMap = (Map)iface.getAttribute(BASE_IF_THRESHOLD_MAP_KEY);
        Map allIfMap = (Map)iface.getAttribute(ALL_IF_THRESHOLD_MAP_KEY);
        File nodeDirectory = new File(repository + File.separator + nodeId.toString() + "/" + dsDir);
        Events events = new Events();
        Date dateStamp = new Date();
        try {
            this.checkNodeDir(nodeDirectory, nodeId, primary, range, interval, dateStamp, nodeMap, events);
        }
        catch (IllegalArgumentException e) {
            log.info((Object)("check: Threshold checking failed for primary " + this.serviceName + " interface " + primary.getHostAddress() + ": " + e), (Throwable)e);
            return 2;
        }
        File[] files = nodeDirectory.listFiles(RrdFileConstants.INTERFACE_DIRECTORY_FILTER);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    this.checkIfDir(files[i], nodeId, primary, interval, range, dateStamp, baseIfMap, allIfMap, events);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    log.info((Object)("check: Threshold checking failed for primary " + this.serviceName + " interface " + primary.getHostAddress() + ": " + e), (Throwable)e);
                    return 2;
                }
            }
        }
        if (events.getEventCount() > 0) {
            try {
                Log eventLog = new Log();
                eventLog.setEvents(events);
                eproxy.send(eventLog);
            }
            catch (EventProxyException e) {
                log.warn((Object)("check: Failed sending threshold events via event proxy: " + e), (Throwable)e);
                return 2;
            }
        }
        return 1;
    }

    private Map<String, Double> getThresholdValues(File directory, int range, int interval, Collection<String> requiredDatasources) {
        Category log = this.log();
        HashMap<String, Double> values = new HashMap<String, Double>();
        for (String ds : requiredDatasources) {
            File dsFile = new File(directory, ds + RrdUtils.getExtension());
            Double thisValue = null;
            if (dsFile.exists()) {
                try {
                    if (range != 0) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("checking values within " + range + " mS of last possible PDP"));
                        }
                        thisValue = RrdUtils.fetchLastValueInRange((String)dsFile.getAbsolutePath(), (String)ds, (int)interval, (int)range);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"checking value of last possible PDP only");
                        }
                        thisValue = RrdUtils.fetchLastValue((String)dsFile.getAbsolutePath(), (String)ds, (int)interval);
                    }
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Unable to convert retrieved value for datasource '" + ds + "' to a double, skipping evaluation."));
                }
                catch (RrdException e) {
                    log.info((Object)("An error occurred retriving the last value for datasource '" + ds + "': " + (Object)((Object)e)), (Throwable)e);
                }
            }
            if (thisValue == null || thisValue.isNaN()) {
                return null;
            }
            values.put(ds, thisValue);
        }
        return values;
    }

    private void checkNodeDir(File directory, Integer nodeId, InetAddress primary, int interval, int range, Date date, Map thresholdMap, Events events) throws IllegalArgumentException {
        Category log = this.log();
        if (directory == null || nodeId == null || primary == null || date == null || thresholdMap == null || events == null) {
            throw new IllegalArgumentException("Null parameters not permitted.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("checkNodeDir: threshold checking node dir: " + directory.getAbsolutePath()));
        }
        for (Object threshKey : thresholdMap.keySet()) {
            List<Event> eventList;
            ThresholdEntity threshold = (ThresholdEntity)thresholdMap.get(threshKey);
            Collection<String> requiredDatasources = threshold.getRequiredDatasources();
            Map<String, Double> values = this.getThresholdValues(directory, range, interval, requiredDatasources);
            if (values == null || (eventList = threshold.evaluateAndCreateEvents(values, date)).size() == 0) continue;
            this.completeEventListAndAddToEvents(events, eventList, nodeId, primary, null);
        }
    }

    private void checkIfDir(File directory, Integer nodeId, InetAddress primary, int interval, int range, Date date, Map baseIfThresholdMap, Map allIfThresholdMap, Events events) throws IllegalArgumentException {
        HashMap<String, ThresholdEntity> thresholdMap;
        if (directory == null || nodeId == null || primary == null || date == null || baseIfThresholdMap == null || allIfThresholdMap == null || events == null) {
            throw new IllegalArgumentException("Null parameters not permitted.");
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("checkIfDir: threshold checking interface dir: " + directory.getAbsolutePath()));
        }
        String ifLabel = directory.getName();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("checkIfDir: ifLabel=" + ifLabel));
        }
        if ((thresholdMap = (HashMap<String, ThresholdEntity>)allIfThresholdMap.get(ifLabel)) == null) {
            thresholdMap = new HashMap<String, ThresholdEntity>();
            for (ThresholdEntity entity : baseIfThresholdMap.values()) {
                thresholdMap.put(entity.getDataSourceExpression(), entity.clone());
            }
            allIfThresholdMap.put(ifLabel, thresholdMap);
        }
        HashMap<String, String> ifDataMap = new HashMap<String, String>();
        for (Object threshKey : thresholdMap.keySet()) {
            List<Event> eventList;
            ThresholdEntity threshold = (ThresholdEntity)thresholdMap.get(threshKey);
            Collection<String> requiredDatasources = threshold.getRequiredDatasources();
            Map<String, Double> values = this.getThresholdValues(directory, range, interval, requiredDatasources);
            if (values == null || (eventList = threshold.evaluateAndCreateEvents(values, date)).size() == 0) continue;
            if (ifDataMap.size() == 0 && ifLabel != null) {
                this.populateIfDataMap(nodeId, ifLabel, ifDataMap);
            }
            this.completeEventListAndAddToEvents(events, eventList, nodeId, primary, ifDataMap);
        }
    }

    private void completeEventListAndAddToEvents(Events events, List<Event> eventList, Integer nodeId, InetAddress primary, Map<String, String> ifDataMap) {
        for (Event event : eventList) {
            event.setNodeid((long)nodeId.intValue());
            event.setService(this.serviceName());
            if (ifDataMap == null || ifDataMap.get("ipaddr") == null) {
                if (primary != null) {
                    event.setInterface(primary.getHostAddress());
                }
            } else {
                String ifAddr = ifDataMap.get("ipaddr");
                event.setInterface(ifAddr);
            }
            Parms eventParms = event.getParms();
            if (ifDataMap != null && ifDataMap.get("iflabel") != null) {
                Parm eventParm = new Parm();
                eventParm.setParmName("ifLabel");
                Value parmValue = new Value();
                parmValue.setContent(ifDataMap.get("iflabel"));
                eventParm.setValue(parmValue);
                eventParms.addParm(eventParm);
            }
            events.addEvent(event);
        }
    }

    private final Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateIfDataMap(Integer nodeId, String ifLabel, Map<String, String> ifDataMap) {
        Connection dbConn;
        try {
            dbConn = DataSourceFactory.getInstance().getConnection();
        }
        catch (SQLException e) {
            this.log().error((Object)("checkIfDir: Failed getting connection to the database: " + e), (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        try {
            ifDataMap.putAll(IfLabel.getInterfaceInfoFromIfLabel(dbConn, nodeId, ifLabel));
        }
        catch (SQLException e) {
            this.log().warn((Object)("Failed to retrieve interface info from database using ifLabel '" + ifLabel + "': " + e), (Throwable)e);
        }
        finally {
            try {
                if (dbConn != null) {
                    dbConn.close();
                }
            }
            catch (SQLException e) {
                this.log().info((Object)("checkIfDir: SQLException while closing database connection: " + e), (Throwable)e);
            }
        }
        ifDataMap.put("iflabel", ifLabel);
    }

    public void setUseFriendlyName(boolean useFriendlyName) {
        this.useFriendlyName = useFriendlyName;
    }
}

