/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc.datablock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.rtc.datablock.RTCNode;
import org.opennms.netmgt.rtc.datablock.RTCNodeKey;

public class RTCHashMap {
    Map m_map;

    public RTCHashMap() {
        this.m_map = new HashMap();
    }

    public RTCHashMap(int initialCapacity) {
        this.m_map = new HashMap(initialCapacity);
    }

    public RTCHashMap(int initialCapacity, float loadFactor) {
        this.m_map = new HashMap(initialCapacity, loadFactor);
    }

    private void put(Object key, Object value) {
        this.m_map.put(key, value);
    }

    private Object get(Object key) {
        return this.m_map.get(key);
    }

    private Object remove(Object key) {
        return this.m_map.remove(key);
    }

    private List getNodeIDs() {
        LinkedList nodes = new LinkedList();
        for (Object key : this.m_map.keySet()) {
            if (!(key instanceof Long)) continue;
            nodes.add(key);
        }
        return nodes;
    }

    private void add(long nodeid, RTCNode rtcN) {
        Long key = new Long(nodeid);
        ArrayList<RTCNode> nodesList = (ArrayList<RTCNode>)this.get(key);
        if (nodesList != null) {
            nodesList.add(rtcN);
        } else {
            nodesList = new ArrayList<RTCNode>();
            nodesList.add(rtcN);
            this.put(key, nodesList);
        }
    }

    private void add(long nodeid, String ip, RTCNode rtcN) {
        String key = Long.toString(nodeid) + ip;
        ArrayList<RTCNode> nodesList = (ArrayList<RTCNode>)this.get(key);
        if (nodesList != null) {
            nodesList.add(rtcN);
        } else {
            nodesList = new ArrayList<RTCNode>();
            nodesList.add(rtcN);
            this.put(key, nodesList);
        }
    }

    private void add(long nodeid, String ip, String svcName, RTCNode rtcN) {
        this.put(new RTCNodeKey(nodeid, ip, svcName), rtcN);
    }

    public void add(RTCNode rtcN) {
        this.add(rtcN.getNodeID(), rtcN);
        this.add(rtcN.getNodeID(), rtcN.getIP(), rtcN);
        this.add(rtcN.getNodeID(), rtcN.getIP(), rtcN.getSvcName(), rtcN);
    }

    public void delete(RTCNode rtcN) {
        this.delete(rtcN.getNodeID(), rtcN);
        this.delete(rtcN.getNodeID(), rtcN.getIP(), rtcN);
        this.delete(rtcN.getNodeID(), rtcN.getIP(), rtcN.getSvcName(), rtcN);
    }

    private void delete(long nodeid, RTCNode rtcN) {
        Long key = new Long(nodeid);
        List nodesList = (List)this.get(key);
        if (nodesList != null) {
            nodesList.remove(rtcN);
        }
    }

    private void delete(long nodeid, String ip, RTCNode rtcN) {
        String key = Long.toString(nodeid) + ip;
        List nodesList = (List)this.get(key);
        if (nodesList != null) {
            nodesList.remove(rtcN);
        }
    }

    private void delete(long nodeid, String ip, String svcName, RTCNode rtcN) {
        RTCNodeKey key = new RTCNodeKey(nodeid, ip, svcName);
        this.remove(key);
    }

    public boolean isIpValidated(long nodeid, String ip, String catLabel) {
        List nodesList = this.getRTCNodes(nodeid, ip);
        for (RTCNode node : nodesList) {
            if (!node.belongsTo(catLabel)) continue;
            return true;
        }
        return false;
    }

    public double getValue(String catLabel, long curTime, long rollingWindow) {
        double value = 0.0;
        long outageTime = 0L;
        int count = 0;
        long downTime = 0L;
        List nodes = this.getNodeIDs();
        for (Long key : nodes) {
            List valList = this.getRTCNodes(key);
            if (valList == null || valList.size() == 0) continue;
            for (RTCNode node : valList) {
                downTime = node.getDownTime(catLabel, curTime, rollingWindow);
                if (downTime < 0L) continue;
                outageTime += downTime;
                ++count;
            }
        }
        double dOut = (double)outageTime * 1.0;
        double dRoll = (double)rollingWindow * 1.0;
        value = count > 0 ? 100.0 * (1.0 - dOut / (dRoll * (double)count)) : 100.0;
        return value;
    }

    public double getValue(long nodeid, String catLabel, long curTime, long rollingWindow) {
        double value = 0.0;
        long outageTime = 0L;
        int count = 0;
        long downTime = 0L;
        List nodesList = this.getRTCNodes(nodeid);
        for (RTCNode node : nodesList) {
            if (node.getNodeID() != nodeid || (downTime = node.getDownTime(catLabel, curTime, rollingWindow)) < 0L) continue;
            outageTime += downTime;
            ++count;
        }
        double dOut = (double)outageTime * 1.0;
        double dRoll = (double)rollingWindow * 1.0;
        value = count > 0 ? 100.0 * (1.0 - dOut / (dRoll * (double)count)) : 100.0;
        return value;
    }

    public int getServiceCount(long nodeid, String catLabel) {
        int count = 0;
        List nodesList = this.getRTCNodes(nodeid);
        for (RTCNode node : nodesList) {
            if (!node.belongsTo(catLabel)) continue;
            ++count;
        }
        return count;
    }

    public int getServiceDownCount(long nodeid, String catLabel) {
        int count = 0;
        List nodesList = this.getRTCNodes(nodeid);
        for (RTCNode node : nodesList) {
            if (!node.belongsTo(catLabel) || !node.isServiceCurrentlyDown()) continue;
            ++count;
        }
        return count;
    }

    public RTCNode getRTCNode(RTCNodeKey key) {
        return (RTCNode)this.get(key);
    }

    public RTCNode getRTCNode(long nodeid, String ipaddr, String svcname) {
        return this.getRTCNode(new RTCNodeKey(nodeid, ipaddr, svcname));
    }

    public List getRTCNodes(long nodeid) {
        Long key = new Long(nodeid);
        List nodes = (List)this.get(key);
        if (nodes == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(nodes);
    }

    public List getRTCNodes(long nodeid, String ip) {
        String key = Long.toString(nodeid) + ip;
        List nodes = (List)this.get(key);
        if (nodes == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(nodes);
    }

    public void deleteNode(long nodeid) {
        ArrayList nodeList = new ArrayList(this.getRTCNodes(nodeid));
        for (RTCNode rtcN : nodeList) {
            this.delete(rtcN);
        }
    }
}

