/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.concurrent.RunnableConsumerThreadPool;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.HttpUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.RTCConfigFactory;
import org.opennms.netmgt.rtc.datablock.HttpPostInfo;
import org.opennms.netmgt.rtc.datablock.RTCCategory;
import org.opennms.netmgt.rtc.utils.EuiLevelMapper;
import org.opennms.netmgt.rtc.utils.PipedMarshaller;
import org.opennms.netmgt.xml.rtc.EuiLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DataSender
implements Fiber {
    private Map<String, RTCCategory> m_categories;
    private Map<String, List<HttpPostInfo>> m_catUrlMap;
    private RunnableConsumerThreadPool m_dsrPool;
    private FifoQueue m_dataSenderQ;
    private EuiLevelMapper m_euiMapper;
    private final int POST_ERROR_LIMIT;
    private int m_status;

    private int setCurrentThreadPriority(int priority) {
        int oldPriority;
        block2: {
            Thread currentThread = Thread.currentThread();
            oldPriority = currentThread.getPriority();
            try {
                currentThread.setPriority(priority);
            }
            catch (Exception e) {
                Category log = ThreadCategory.getInstance(this.getClass());
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Error setting thread priority: ", (Throwable)e);
            }
        }
        return oldPriority;
    }

    public DataSender(Map<String, RTCCategory> categories, int numSenders) {
        this.m_categories = categories;
        this.m_catUrlMap = new HashMap<String, List<HttpPostInfo>>();
        this.m_dsrPool = new RunnableConsumerThreadPool("DataSenderPool", 0.6f, 1.0f, numSenders);
        this.m_dataSenderQ = this.m_dsrPool.getRunQueue();
        this.m_euiMapper = new EuiLevelMapper();
        this.POST_ERROR_LIMIT = RTCConfigFactory.getInstance().getErrorsBeforeUrlUnsubscribe();
    }

    public synchronized void start() {
        this.m_status = 1;
        Category log = ThreadCategory.getInstance(this.getClass());
        log.info((Object)"Starting the datasender thread pool..");
        try {
            this.m_dsrPool.start();
            log.info((Object)"Datasender thread pool started..");
        }
        catch (Exception e) {
            log.error((Object)"Error starting data sender pool", (Throwable)e);
        }
        this.m_status = 2;
    }

    public synchronized void stop() {
        this.m_status = 3;
        Category log = ThreadCategory.getInstance(this.getClass());
        log.info((Object)"DataSender - shutting down the data sender pool");
        try {
            this.m_dsrPool.stop();
        }
        catch (Exception e) {
            log.error((Object)"Error shutting down data sender pool", (Throwable)e);
        }
        this.m_status = 4;
        log.info((Object)"DataSender shutdown complete");
    }

    public String getName() {
        return "OpenNMS.RTC.DataSender";
    }

    public int getStatus() {
        return this.m_status;
    }

    public synchronized void subscribe(String url, String catlabel, String user, String passwd) {
        Category log = ThreadCategory.getInstance(this.getClass());
        RTCCategory cat = this.m_categories.get(catlabel);
        if (cat == null) {
            log.warn((Object)("RTC: No information available for category: " + catlabel));
            return;
        }
        HttpPostInfo postInfo = null;
        try {
            postInfo = new HttpPostInfo(url, catlabel, user, passwd);
        }
        catch (MalformedURLException mue) {
            log.warn((Object)("ERROR subscribing: Invalid URL '" + url + "' - Data WILL NOT be SENT to the specified url"));
            return;
        }
        List<HttpPostInfo> urlList = this.m_catUrlMap.get(catlabel);
        if (urlList == null) {
            urlList = new ArrayList<HttpPostInfo>();
            urlList.add(postInfo);
            this.m_catUrlMap.put(catlabel, urlList);
        } else if (!urlList.contains(postInfo)) {
            urlList.add(postInfo);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Already subscribed to URL: " + url + "\tcatlabel: " + catlabel + "\tuser:" + user + " - IGNORING LATEST subscribe event"));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Subscribed to URL: " + url + "\tcatlabel: " + catlabel + "\tuser:" + user));
        }
        try {
            int bytesRead;
            int oldPriority = this.setCurrentThreadPriority(10);
            EuiLevel euidata = this.m_euiMapper.convertToEuiLevelXML(cat);
            Reader inr = new PipedMarshaller(euidata).getReader();
            if (log.isDebugEnabled()) {
                log.debug((Object)("DataSender: posting data to: " + url));
            }
            InputStream inp = HttpUtils.post((URL)postInfo.getURL(), (Reader)inr, (String)user, (String)passwd, (int)8192);
            byte[] tmp = new byte[1024];
            while ((bytesRead = inp.read(tmp)) != -1) {
                if (!log.isDebugEnabled() || bytesRead <= 0) continue;
                log.debug((Object)("DataSender: post response: " + new String(tmp, 0, bytesRead)));
            }
            inp.close();
            inr.close();
            oldPriority = this.setCurrentThreadPriority(oldPriority);
            if (log.isDebugEnabled()) {
                log.debug((Object)("DataSender: posted data for category: " + catlabel));
            }
        }
        catch (IOException ioE) {
            log.warn((Object)("DataSender:  Unable to send category '" + catlabel + "' to URL '" + url + "': "), (Throwable)ioE);
            this.setCurrentThreadPriority(5);
        }
        catch (OutOfMemoryError oe) {
            log.warn((Object)("DataSender:  Unable to send category '" + catlabel + "' to URL '" + url + "': "), (Throwable)oe);
            this.setCurrentThreadPriority(5);
        }
        catch (RuntimeException e) {
            log.warn((Object)("DataSender:  Unable to send category '" + catlabel + "' to URL '" + url + "': "), (Throwable)e);
            this.setCurrentThreadPriority(5);
        }
        catch (Throwable t) {
            log.warn((Object)("DataSender:  Unable to send category '" + catlabel + "' to URL '" + url + "': "), t);
            this.setCurrentThreadPriority(5);
        }
    }

    public synchronized void unsubscribe(String urlStr) {
        URL url = null;
        Category log = ThreadCategory.getInstance(this.getClass());
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException mue) {
            log.warn((Object)("ERROR unsubscribing: Invalid URL: " + url));
            return;
        }
        for (String key : this.m_catUrlMap.keySet()) {
            List<HttpPostInfo> value = this.m_catUrlMap.get(key);
            if (value == null) continue;
            ListIterator<HttpPostInfo> listIter = value.listIterator();
            while (listIter.hasNext()) {
                HttpPostInfo postInfo = listIter.next();
                if (!url.equals(postInfo.getURL())) continue;
                listIter.remove();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unsubscribed URL: " + url));
        }
    }

    public synchronized void sendData() {
        Category log = ThreadCategory.getInstance(this.getClass());
        log.debug((Object)"In DataSender sendData()");
        for (RTCCategory cat : this.m_categories.values()) {
            List<HttpPostInfo> urlList;
            String catlabel = cat.getLabel();
            if (log.isDebugEnabled()) {
                log.debug((Object)("DataSender:sendData(): Category '" + catlabel));
            }
            if ((urlList = this.m_catUrlMap.get(catlabel)) == null || urlList.size() <= 0) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("DataSender: category '" + catlabel + "' has no listeners"));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("DataSender: category '" + catlabel + "' has listeners - converting to xml..."));
            }
            int oldPriority = this.setCurrentThreadPriority(10);
            EuiLevel euidata = null;
            try {
                euidata = this.m_euiMapper.convertToEuiLevelXML(cat);
            }
            catch (OutOfMemoryError oe) {
                log.warn((Object)("DataSender: unable to convert data to xml for category: " + catlabel), (Throwable)oe);
                this.setCurrentThreadPriority(5);
                continue;
            }
            catch (Throwable t) {
                log.warn((Object)("DataSender: unable to convert data to xml for category: " + catlabel), t);
                this.setCurrentThreadPriority(5);
            }
            if (urlList != null && urlList.size() > 0) {
                ListIterator<HttpPostInfo> urlIter = urlList.listIterator();
                while (urlIter.hasNext()) {
                    HttpPostInfo postInfo = (HttpPostInfo)urlIter.next();
                    try {
                        int bytesRead;
                        Reader inr = new PipedMarshaller(euidata).getReader();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("DataSender: posting data to: " + postInfo.getURLString()));
                        }
                        InputStream inp = HttpUtils.post((URL)postInfo.getURL(), (Reader)inr, (String)postInfo.getUser(), (String)postInfo.getPassword(), (int)8192);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("DataSender: posted data for category: " + catlabel));
                        }
                        byte[] tmp = new byte[1024];
                        while ((bytesRead = inp.read(tmp)) != -1) {
                            if (!log.isDebugEnabled() || bytesRead <= 0) continue;
                            log.debug((Object)("DataSender: post response: " + new String(tmp, 0, bytesRead)));
                        }
                        inp.close();
                        inr.close();
                        postInfo.clearErrors();
                    }
                    catch (IOException e) {
                        log.warn((Object)("DataSender: unable to send data for category: " + catlabel + " due to " + e.getClass().getName() + ": " + e.getMessage()), (Throwable)e);
                        postInfo.incrementErrors();
                        this.setCurrentThreadPriority(5);
                    }
                    catch (OutOfMemoryError e) {
                        log.warn((Object)("DataSender: unable to send data for category: " + catlabel + " due to " + e.getClass().getName() + ": " + e.getMessage()), (Throwable)e);
                        this.setCurrentThreadPriority(5);
                    }
                    catch (RuntimeException e) {
                        log.warn((Object)("DataSender: unable to send data for category: " + catlabel + " due to " + e.getClass().getName() + ": " + e.getMessage()), (Throwable)e);
                        this.setCurrentThreadPriority(5);
                    }
                    catch (Throwable t) {
                        log.warn((Object)("DataSender: unable to send data for category: " + catlabel + " due to " + t.getClass().getName() + ": " + t.getMessage()), t);
                        this.setCurrentThreadPriority(5);
                    }
                    if (this.POST_ERROR_LIMIT <= 0 || postInfo.getErrors() < this.POST_ERROR_LIMIT) continue;
                    urlIter.remove();
                    log.warn((Object)("URL " + postInfo.getURLString() + " UNSUBSCRIBED due to reaching error limit " + postInfo.getErrors()));
                }
            }
            oldPriority = this.setCurrentThreadPriority(oldPriority);
        }
    }

    public synchronized void notifyToSend() {
        try {
            this.m_dataSenderQ.add((Object)new SendRequest());
        }
        catch (InterruptedException iE) {
            Category log = ThreadCategory.getInstance(this.getClass());
            log.warn((Object)"Unable to queue datasender to the dsConsumer queue", (Throwable)iE);
        }
        catch (FifoQueueException qE) {
            Category log = ThreadCategory.getInstance(this.getClass());
            log.warn((Object)"Unable to queue datasender to the dsConsumer queue", (Throwable)qE);
        }
    }

    private class SendRequest
    implements Runnable {
        private SendRequest() {
        }

        public void run() {
            DataSender.this.sendData();
        }
    }
}

