/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc;

import java.util.ArrayList;
import org.apache.log4j.Category;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.eventd.EventListener;
import org.opennms.netmgt.rtc.DataUpdater;
import org.opennms.netmgt.rtc.RTCManager;
import org.opennms.netmgt.xml.event.Event;

final class BroadcastEventProcessor
implements EventListener {
    private FifoQueue m_updaterQ;

    BroadcastEventProcessor(FifoQueue updaterQ) {
        this.m_updaterQ = updaterQ;
    }

    public void start() {
        ArrayList<String> ueisOfInterest = new ArrayList<String>();
        ueisOfInterest.add("uei.opennms.org/nodes/nodeGainedService");
        ueisOfInterest.add("uei.opennms.org/nodes/nodeLostService");
        ueisOfInterest.add("uei.opennms.org/nodes/interfaceDown");
        ueisOfInterest.add("uei.opennms.org/nodes/nodeDown");
        ueisOfInterest.add("uei.opennms.org/nodes/nodeUp");
        ueisOfInterest.add("uei.opennms.org/nodes/interfaceUp");
        ueisOfInterest.add("uei.opennms.org/nodes/nodeRegainedService");
        ueisOfInterest.add("uei.opennms.org/nodes/serviceDeleted");
        ueisOfInterest.add("uei.opennms.org/nodes/serviceUnmanaged");
        ueisOfInterest.add("uei.opennms.org/nodes/interfaceReparented");
        ueisOfInterest.add("uei.opennms.org/internal/rtc/subscribe");
        ueisOfInterest.add("uei.opennms.org/internal/rtc/unsubscribe");
        ueisOfInterest.add("uei.opennms.org/nodes/assetInfoChanged");
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener((EventListener)this, ueisOfInterest);
    }

    public void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener(this);
    }

    public void onEvent(Event event) {
        if (event == null) {
            return;
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)"About to start processing recd. event");
        }
        try {
            RTCManager.getInstance().checkTimerTasksOnEventReceipt();
            String uei = event.getUei();
            if (uei == null) {
                return;
            }
            this.m_updaterQ.add((Object)new DataUpdater(event));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Event " + uei + " added to updater queue"));
            }
            RTCManager.getInstance().resetUserTimer();
        }
        catch (InterruptedException ex) {
            log.error((Object)"Failed to process event", (Throwable)ex);
            return;
        }
        catch (FifoQueueException ex) {
            log.error((Object)"Failed to process event", (Throwable)ex);
            return;
        }
        catch (Throwable t) {
            log.error((Object)"Failed to process event", t);
            return;
        }
    }

    public String getName() {
        return "RTCManager:BroadcastEventProcessor";
    }
}

