/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.util.Collection;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.poller.remote.PollService;
import org.opennms.netmgt.poller.remote.PolledService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DemoPollService
implements PollService {
    private int m_repetitions;
    private int m_pollCount;
    private PollStatus m_currentStatus;

    public DemoPollService(int repetitions, PollStatus initialStatus) {
        this.m_repetitions = repetitions;
        this.m_currentStatus = initialStatus;
    }

    public DemoPollService(int repetitions) {
        this(repetitions, PollStatus.up());
    }

    public DemoPollService() {
        this(2);
    }

    @Override
    public PollStatus poll(PolledService polledService) {
        PollStatus status = this.m_currentStatus;
        ++this.m_pollCount;
        if (this.m_pollCount % this.m_repetitions == 0) {
            this.m_currentStatus = this.m_currentStatus.isDown() ? PollStatus.up((long)(100 + this.m_pollCount)) : PollStatus.down((String)("pollCount is " + this.m_pollCount));
        }
        return status;
    }

    @Override
    public void initialize(PolledService polledService) {
    }

    @Override
    public void release(PolledService polledService) {
    }

    @Override
    public void setServiceMonitorLocators(Collection<ServiceMonitorLocator> locators) {
    }
}

