/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.net.InetAddress;
import java.util.Date;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollableContainer;
import org.opennms.netmgt.poller.pollables.PollableElement;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.poller.pollables.PollableVisitor;
import org.opennms.netmgt.poller.pollables.PollableVisitorAdaptor;
import org.opennms.netmgt.xml.event.Event;

public class PollableInterface
extends PollableContainer {
    private InetAddress m_addr;

    public PollableInterface(PollableNode node, InetAddress addr) {
        super(node);
        this.m_addr = addr;
    }

    public PollableNode getNode() {
        return (PollableNode)this.getParent();
    }

    private void setNode(PollableNode newNode) {
        this.setParent(newNode);
    }

    public PollableNetwork getNetwork() {
        return this.getNode().getNetwork();
    }

    public PollContext getContext() {
        return this.getNode().getContext();
    }

    public String getIpAddr() {
        return this.m_addr.getHostAddress();
    }

    public InetAddress getAddress() {
        return this.m_addr;
    }

    public int getNodeId() {
        return this.getNode().getNodeId();
    }

    public String getNodeLabel() {
        return this.getNode().getNodeLabel();
    }

    public PollableService createService(final String svcName) {
        final PollableService[] retVal = new PollableService[1];
        Runnable r = new Runnable(){

            public void run() {
                PollableService svc = new PollableService(PollableInterface.this, svcName);
                PollableInterface.this.addMember(svc);
                retVal[0] = svc;
            }
        };
        this.withTreeLock(r);
        return retVal[0];
    }

    public PollableService getService(String svcName) {
        return (PollableService)this.getMember(svcName);
    }

    protected Object createMemberKey(PollableElement member) {
        PollableService svc = (PollableService)member;
        return svc.getSvcName();
    }

    protected void visitThis(PollableVisitor v) {
        super.visitThis(v);
        v.visitInterface(this);
    }

    public void recalculateStatus() {
        PollableService criticalSvc = this.getCriticalService();
        if (criticalSvc != null) {
            criticalSvc.recalculateStatus();
            this.updateStatus(criticalSvc.getStatus().isUp() ? PollStatus.up() : PollStatus.down());
        } else {
            super.recalculateStatus();
        }
    }

    private PollableService getCriticalService() {
        return this.getService(this.getContext().getCriticalServiceName());
    }

    public PollableElement selectPollElement() {
        PollableService critSvc = this.getCriticalService();
        return critSvc != null ? critSvc : super.selectPollElement();
    }

    protected PollStatus poll(PollableElement elem) {
        PollableService critSvc = this.getCriticalService();
        if (this.getStatus().isUp() || critSvc == null || elem == critSvc) {
            return super.poll(elem);
        }
        return PollStatus.down();
    }

    public PollStatus pollRemainingMembers(PollableElement member) {
        PollableService critSvc = this.getCriticalService();
        if (critSvc != null && this.getStatus().isUp()) {
            if (member != critSvc) {
                critSvc.poll();
            }
            return critSvc.getStatus().isUp() ? PollStatus.up() : PollStatus.down();
        }
        if (this.getContext().isPollingAllIfCritServiceUndefined()) {
            return super.pollRemainingMembers(member);
        }
        return this.getMemberStatus();
    }

    public Event createDownEvent(Date date) {
        return this.getContext().createEvent("uei.opennms.org/nodes/interfaceDown", this.getNodeId(), this.getAddress(), null, date, this.getStatus().getReason());
    }

    public Event createUpEvent(Date date) {
        return this.getContext().createEvent("uei.opennms.org/nodes/interfaceUp", this.getNodeId(), this.getAddress(), null, date, this.getStatus().getReason());
    }

    public String toString() {
        return this.getNode() + ":" + this.getIpAddr();
    }

    public void reparentTo(final PollableNode newNode) {
        final PollableNode oldNode = this.getNode();
        if (oldNode.equals(newNode)) {
            return;
        }
        PollableNode firstNode = oldNode.getNodeId() <= newNode.getNodeId() ? oldNode : newNode;
        final PollableNode secondNode = oldNode.getNodeId() <= newNode.getNodeId() ? newNode : oldNode;
        final Runnable reparent = new Runnable(){

            public void run() {
                oldNode.resetStatusChanged();
                newNode.resetStatusChanged();
                int oldNodeId = PollableInterface.this.getNodeId();
                String oldIp = PollableInterface.this.getIpAddr();
                int newNodeId = newNode.getNodeId();
                oldNode.removeMember(PollableInterface.this);
                newNode.addMember(PollableInterface.this);
                PollableInterface.this.setNode(newNode);
                PollableInterface.this.getContext().reparentOutages(oldIp, oldNodeId, newNodeId);
                if ((PollableInterface.this.getCause() == null || PollableInterface.this.getCause().equals(oldNode.getCause())) && newNode.getCause() != null) {
                    PollableVisitorAdaptor visitor = new PollableVisitorAdaptor(){

                        public void visitElement(PollableElement element) {
                            boolean matches;
                            boolean bl = element.getCause() == null ? oldNode.getCause() == null : (matches = element.getCause().equals(oldNode.getCause()));
                            if (matches) {
                                element.setCause(newNode.getCause());
                            }
                        }
                    };
                    PollableInterface.this.visit(visitor);
                }
                Date date = new Date();
                oldNode.recalculateStatus();
                oldNode.processStatusChange(date);
                newNode.recalculateStatus();
                newNode.processStatusChange(date);
            }
        };
        Runnable lockSecondNodeAndRun = new Runnable(){

            public void run() {
                secondNode.withTreeLock(reparent);
            }
        };
        firstNode.withTreeLock(lockSecondNodeAndRun);
    }
}

