/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.io.File;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.utils.ParameterMap;

public class LatencyStoringServiceMonitorAdaptor
implements ServiceMonitor {
    public static final String DEFAULT_DSNAME = "response-time";
    ServiceMonitor m_serviceMonitor;
    PollerConfig m_pollerConfig;
    Package m_pkg;

    public LatencyStoringServiceMonitorAdaptor(ServiceMonitor monitor, PollerConfig config, Package pkg) {
        this.m_serviceMonitor = monitor;
        this.m_pollerConfig = config;
        this.m_pkg = pkg;
    }

    public void initialize(Map parameters) {
        this.m_serviceMonitor.initialize(parameters);
    }

    public void initialize(MonitoredService svc) {
        this.m_serviceMonitor.initialize(svc);
    }

    public PollStatus poll(MonitoredService svc, Map parameters) {
        PollStatus status = this.m_serviceMonitor.poll(svc, parameters);
        if (status.getResponseTime() >= 0L) {
            this.storeResponseTime(svc, status.getResponseTime(), parameters);
        }
        return status;
    }

    private void storeResponseTime(MonitoredService svc, long responseTime, Map parameters) {
        String rrdPath = ParameterMap.getKeyedString(parameters, "rrd-repository", null);
        String dsName = ParameterMap.getKeyedString(parameters, "ds-name", DEFAULT_DSNAME);
        String rrdBaseName = ParameterMap.getKeyedString(parameters, "rrd-base-name", dsName);
        if (rrdPath == null) {
            this.log().info((Object)"poll: RRD repository not specified in parameters, latency data will not be stored.");
        }
        if (responseTime >= 0L && rrdPath != null) {
            try {
                this.updateRRD(rrdPath, svc.getAddress(), rrdBaseName, dsName, responseTime);
            }
            catch (RuntimeException rex) {
                this.log().debug((Object)("There was a problem writing the RRD:" + rex));
            }
        }
    }

    public void updateRRD(String repository, InetAddress addr, String rrdBaseName, String dsName, long value) {
        block2: {
            Category log = ThreadCategory.getInstance(this.getClass());
            try {
                this.createRRD(repository, addr, rrdBaseName, dsName);
                String path = repository + File.separator + addr.getHostAddress();
                RrdUtils.updateRRD((String)addr.getHostAddress(), (String)path, (String)rrdBaseName, (String)Long.toString(value));
            }
            catch (RrdException e) {
                if (!log.isEnabledFor((Priority)Level.ERROR)) break block2;
                String msg = e.getMessage();
                log.error((Object)msg);
                throw new RuntimeException(msg, e);
            }
        }
    }

    public boolean createRRD(String repository, InetAddress addr, String rrdBaseName, String dsName) throws RrdException {
        List rraList = this.m_pollerConfig.getRRAList(this.m_pkg);
        String path = repository + File.separator + addr.getHostAddress();
        List<RrdDataSource> dsList = Collections.singletonList(new RrdDataSource(dsName, "GAUGE", this.m_pollerConfig.getStep(this.m_pkg) * 2, "U", "U"));
        return RrdUtils.createRRD((String)addr.getHostAddress(), (String)path, (String)rrdBaseName, (int)this.m_pollerConfig.getStep(this.m_pkg), dsList, (List)rraList);
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void release() {
        this.m_serviceMonitor.release();
    }

    public void release(MonitoredService svc) {
        this.m_serviceMonitor.release(svc);
    }
}

