/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.springframework.util.ClassUtils;

public abstract class IPv4Monitor
implements ServiceMonitor {
    public void initialize(Map parameters) {
    }

    public void release() {
    }

    public void initialize(MonitoredService svc) {
        NetworkInterface iface = svc.getNetInterface();
        if (!(iface.getAddress() instanceof InetAddress)) {
            throw new NetworkInterfaceNotSupportedException("Address type not supported");
        }
    }

    public void release(MonitoredService svc) {
    }

    public abstract PollStatus poll(MonitoredService var1, Map var2);

    protected Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    protected PollStatus logDown(Level level, String reason) {
        return this.logDown(level, reason, null);
    }

    protected PollStatus logDown(Level level, String reason, Throwable e) {
        String className = ClassUtils.getShortName(this.getClass());
        this.log().debug((Object)(className + ": " + reason), e);
        return PollStatus.unavailable((String)reason);
    }

    protected PollStatus logUp(Level level, long responseTime, String logMsg) {
        String className = ClassUtils.getShortName(this.getClass());
        this.log().debug((Object)(className + ": " + logMsg));
        return PollStatus.available((long)responseTime);
    }
}

