/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.utils.ParameterMap;
import org.opennms.protocols.dns.DNSAddressRequest;

@Distributable
public final class DnsMonitor
extends IPv4Monitor {
    private static final int DEFAULT_PORT = 53;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        int retry = ParameterMap.getKeyedInteger(parameters, "retry", 0);
        int port = ParameterMap.getKeyedInteger(parameters, "port", 53);
        int timeout = ParameterMap.getKeyedInteger(parameters, "timeout", 5000);
        String lookup = ParameterMap.getKeyedString(parameters, "lookup", null);
        if (lookup == null || lookup.length() == 0) {
            try {
                lookup = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ukE) {
                ukE.fillInStackTrace();
                throw new UndeclaredThrowableException(ukE);
            }
        }
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        DNSAddressRequest request = new DNSAddressRequest(lookup);
        PollStatus serviceStatus = PollStatus.unavailable();
        DatagramSocket socket = null;
        long responseTime = -1L;
        try {
            socket = new DatagramSocket();
            socket.setSoTimeout(timeout);
            for (int attempts = 0; attempts <= retry && !serviceStatus.isAvailable(); ++attempts) {
                try {
                    byte[] data = request.buildRequest();
                    DatagramPacket outgoing = new DatagramPacket(data, data.length, ipv4Addr, port);
                    long sentTime = System.currentTimeMillis();
                    socket.send(outgoing);
                    byte[] buffer = new byte[512];
                    DatagramPacket incoming = new DatagramPacket(buffer, buffer.length);
                    socket.receive(incoming);
                    responseTime = System.currentTimeMillis() - sentTime;
                    request.verifyResponse(incoming.getData(), incoming.getLength());
                    serviceStatus = this.logUp(Level.DEBUG, responseTime, "valid DNS request received, responseTime= " + responseTime + "ms");
                    continue;
                }
                catch (InterruptedIOException ex) {
                    // empty catch block
                }
            }
        }
        catch (NoRouteToHostException e) {
            serviceStatus = this.logDown(Level.DEBUG, "No route to host exception for address: " + ipv4Addr, e);
        }
        catch (ConnectException e) {
            serviceStatus = this.logDown(Level.DEBUG, "Connection exception for address: " + ipv4Addr, e);
        }
        catch (IOException ex) {
            serviceStatus = this.logDown(Level.DEBUG, "IOException while polling address: " + ipv4Addr, ex);
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
        return serviceStatus;
    }
}

