/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Level;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable(value={DistributionContext.DAEMON})
public final class DiskUsageMonitor
extends SnmpMonitorStrategy {
    private static final String m_serviceName = "DISK-USAGE";
    static final String SNMP_AGENTCONFIG_KEY = "org.opennms.netmgt.snmp.SnmpAgentConfig";
    private static final String hrStorageDescr = ".1.3.6.1.2.1.25.2.3.1.3";
    private static final String hrStorageSize = ".1.3.6.1.2.1.25.2.3.1.5";
    private static final String hrStorageUsed = ".1.3.6.1.2.1.25.2.3.1.6";

    public String serviceName() {
        return m_serviceName;
    }

    public void initialize(Map parameters) {
        try {
            SnmpPeerFactory.init();
        }
        catch (MarshalException ex) {
            this.log().fatal((Object)"initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().fatal((Object)"initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().fatal((Object)"initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    public void initialize(MonitoredService svc) {
        NetworkInterface iface = svc.getNetInterface();
        super.initialize(svc);
        InetAddress ipAddr = (InetAddress)iface.getAddress();
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipAddr);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: SnmpAgentConfig address: " + agentConfig));
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: setting SNMP peer attribute for interface " + ipAddr.getHostAddress()));
        }
        iface.setAttribute(SNMP_AGENTCONFIG_KEY, agentConfig);
        this.log().debug((Object)("initialize: interface: " + agentConfig.getAddress() + " initialized."));
    }

    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        PollStatus status = PollStatus.available();
        InetAddress ipaddr = (InetAddress)iface.getAddress();
        SnmpAgentConfig agentConfig = (SnmpAgentConfig)iface.getAttribute(SNMP_AGENTCONFIG_KEY);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, "timeout", agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, "retries", agentConfig.getRetries()));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, "port", agentConfig.getPort()));
        String diskName = ParameterMap.getKeyedString(parameters, "disk", null);
        Integer percentFree = ParameterMap.getKeyedInteger(parameters, "free", 15);
        this.log().debug((Object)("diskName=" + diskName));
        this.log().debug((Object)("percentfree=" + percentFree));
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("poll: service= SNMP address= " + agentConfig));
        }
        try {
            SnmpObjId hrStorageDescrSnmpObject;
            Map flagResults;
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("DiskUsageMonitor.poll: SnmpAgentConfig address: " + agentConfig));
            }
            if ((flagResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"DiskUsagePoller", (SnmpObjId)(hrStorageDescrSnmpObject = SnmpObjId.get((String)hrStorageDescr)))).size() == 0) {
                this.log().debug((Object)("SNMP poll failed: no results, addr=" + ipaddr.getHostAddress() + " oid=" + hrStorageDescrSnmpObject));
                return PollStatus.unavailable();
            }
            for (Map.Entry e : flagResults.entrySet()) {
                this.log().debug((Object)("poll: SNMPwalk poll succeeded, addr=" + ipaddr.getHostAddress() + " oid=" + hrStorageDescrSnmpObject + " instance=" + e.getKey() + " value=" + e.getValue()));
                if (!((SnmpValue)e.getValue()).toString().equals(diskName)) continue;
                this.log().debug((Object)("DiskUsageMonitor.poll: found disk=" + diskName));
                SnmpObjId hrStorageSizeSnmpObject = SnmpObjId.get((String)(".1.3.6.1.2.1.25.2.3.1.5." + ((SnmpInstId)e.getKey()).toString()));
                SnmpObjId hrStorageUsedSnmpObject = SnmpObjId.get((String)(".1.3.6.1.2.1.25.2.3.1.6." + ((SnmpInstId)e.getKey()).toString()));
                SnmpValue snmpSize = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)hrStorageSizeSnmpObject);
                SnmpValue snmpUsed = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)hrStorageUsedSnmpObject);
                float calculatedPercentage = ((float)snmpSize.toLong() - (float)snmpUsed.toLong()) / (float)snmpSize.toLong() * 100.0f;
                this.log().debug((Object)("DiskUsageMonitor: calculatedPercentage=" + calculatedPercentage + " percentFree=" + percentFree));
                if (calculatedPercentage < (float)percentFree.intValue()) {
                    return PollStatus.unavailable((String)(diskName + " usage high (" + (100 - (int)calculatedPercentage) + "%)"));
                }
                return status;
            }
            this.log().debug((Object)"DiskUsageMonitor: no disks found");
            return PollStatus.unavailable((String)("could not find " + diskName + "in table"));
        }
        catch (NumberFormatException e) {
            status = this.logDown(Level.ERROR, "Number operator used on a non-number " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            status = this.logDown(Level.ERROR, "Invalid Snmp Criteria: " + e.getMessage());
        }
        catch (Throwable t) {
            status = this.logDown(Level.WARN, "Unexpected exception during SNMP poll of interface " + ipaddr.getHostAddress(), t);
        }
        return status;
    }
}

