/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.capsd.plugins.IcmpPlugin;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.PollOutagesConfig;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.DefaultPollContext;
import org.opennms.netmgt.poller.DefaultQueryManager;
import org.opennms.netmgt.poller.PollerEventProcessor;
import org.opennms.netmgt.poller.QueryManager;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.pollables.DbPollEvent;
import org.opennms.netmgt.poller.pollables.PollEvent;
import org.opennms.netmgt.poller.pollables.PollableElement;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.poller.pollables.PollableServiceConfig;
import org.opennms.netmgt.poller.pollables.PollableVisitorAdaptor;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.utils.Querier;
import org.opennms.netmgt.utils.Updater;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

public class Poller
extends AbstractServiceDaemon {
    private static final Poller m_singleton = new Poller();
    private boolean m_initialized = false;
    private LegacyScheduler m_scheduler = null;
    private PollerEventProcessor m_receiver;
    private PollableNetwork m_network = new PollableNetwork(new DefaultPollContext(this));
    private QueryManager m_queryMgr = new DefaultQueryManager();
    private PollerConfig m_pollerConfig;
    private PollOutagesConfig m_pollOutagesConfig;
    private EventIpcManager m_eventMgr;
    private DataSource m_dbConnectionFactory;

    public Poller() {
        super("OpenNMS.Poller");
    }

    protected void onInit() {
        this.m_queryMgr.setDbConnectionFactory(this.m_dbConnectionFactory);
        this.log().debug((Object)("init: serviceUnresponsive behavior: " + (this.getPollerConfig().serviceUnresponsiveEnabled() ? "enabled" : "disabled")));
        this.createScheduler();
        try {
            this.log().debug((Object)"init: Closing outages for unmanaged services");
            this.closeOutagesForUnmanagedServices();
        }
        catch (Exception e) {
            this.log().error((Object)"init: Failed to close ouates for unmanage services", (Throwable)e);
        }
        try {
            this.log().debug((Object)"start: Scheduling existing interfaces");
            this.scheduleExistingServices();
        }
        catch (Exception sqlE) {
            this.log().error((Object)"start: Failed to schedule existing interfaces", (Throwable)sqlE);
        }
        try {
            this.log().debug((Object)"start: Creating event broadcast event processor");
            this.m_receiver = new PollerEventProcessor(this);
        }
        catch (Throwable t) {
            this.log().fatal((Object)"start: Failed to initialized the broadcast event receiver", t);
            throw new UndeclaredThrowableException(t);
        }
        this.m_initialized = true;
    }

    private void closeOutagesForUnmanagedServices() {
        Timestamp closeTime = new Timestamp(new Date().getTime());
        String DB_CLOSE_OUTAGES_FOR_UNMANAGED_SERVICES = "UPDATE outages set ifregainedservice = ? where outageid in (select outages.outageid from outages, ifservices where ((outages.nodeid = ifservices.nodeid) AND (outages.ipaddr = ifservices.ipaddr) AND (outages.serviceid = ifservices.serviceid) AND ((ifservices.status = 'D') OR (ifservices.status = 'F') OR (ifservices.status = 'U')) AND (outages.ifregainedservice IS NULL)))";
        Updater svcUpdater = new Updater(this.m_dbConnectionFactory, "UPDATE outages set ifregainedservice = ? where outageid in (select outages.outageid from outages, ifservices where ((outages.nodeid = ifservices.nodeid) AND (outages.ipaddr = ifservices.ipaddr) AND (outages.serviceid = ifservices.serviceid) AND ((ifservices.status = 'D') OR (ifservices.status = 'F') OR (ifservices.status = 'U')) AND (outages.ifregainedservice IS NULL)))");
        svcUpdater.execute(closeTime);
        String DB_CLOSE_OUTAGES_FOR_UNMANAGED_INTERFACES = "UPDATE outages set ifregainedservice = ? where outageid in (select outages.outageid from outages, ipinterface where ((outages.nodeid = ipinterface.nodeid) AND (outages.ipaddr = ipinterface.ipaddr) AND ((ipinterface.ismanaged = 'F') OR (ipinterface.ismanaged = 'U')) AND (outages.ifregainedservice IS NULL)))";
        Updater ifUpdater = new Updater(this.m_dbConnectionFactory, "UPDATE outages set ifregainedservice = ? where outageid in (select outages.outageid from outages, ipinterface where ((outages.nodeid = ipinterface.nodeid) AND (outages.ipaddr = ipinterface.ipaddr) AND ((ipinterface.ismanaged = 'F') OR (ipinterface.ismanaged = 'U')) AND (outages.ifregainedservice IS NULL)))");
        ifUpdater.execute(closeTime);
    }

    public void closeOutagesForNode(Date closeDate, int eventId, int nodeId) {
        Timestamp closeTime = new Timestamp(closeDate.getTime());
        String DB_CLOSE_OUTAGES_FOR_NODE = "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outages.nodeId = ? AND (outages.ifregainedservice IS NULL)";
        Updater svcUpdater = new Updater(this.m_dbConnectionFactory, "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outages.nodeId = ? AND (outages.ifregainedservice IS NULL)");
        svcUpdater.execute(closeTime, new Integer(eventId), new Integer(nodeId));
    }

    public void closeOutagesForInterface(Date closeDate, int eventId, int nodeId, String ipAddr) {
        Timestamp closeTime = new Timestamp(closeDate.getTime());
        String DB_CLOSE_OUTAGES_FOR_IFACE = "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outages.nodeId = ? AND outages.ipAddr = ? AND (outages.ifregainedservice IS NULL)";
        Updater svcUpdater = new Updater(this.m_dbConnectionFactory, "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outages.nodeId = ? AND outages.ipAddr = ? AND (outages.ifregainedservice IS NULL)");
        svcUpdater.execute(closeTime, new Integer(eventId), new Integer(nodeId), ipAddr);
    }

    public void closeOutagesForService(Date closeDate, int eventId, int nodeId, String ipAddr, String serviceName) {
        Timestamp closeTime = new Timestamp(closeDate.getTime());
        String DB_CLOSE_OUTAGES_FOR_SERVICE = "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outageid in (select outages.outageid from outages, service where outages.nodeid = ? AND outages.ipaddr = ? AND outages.serviceid = service.serviceId AND service.servicename = ? AND outages.ifregainedservice IS NULL)";
        Updater svcUpdater = new Updater(this.m_dbConnectionFactory, "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outageid in (select outages.outageid from outages, service where outages.nodeid = ? AND outages.ipaddr = ? AND outages.serviceid = service.serviceId AND service.servicename = ? AND outages.ifregainedservice IS NULL)");
        svcUpdater.execute(closeTime, new Integer(eventId), new Integer(nodeId), ipAddr, serviceName);
    }

    private void createScheduler() {
        Category log = ThreadCategory.getInstance(this.getClass());
        try {
            log.debug((Object)"init: Creating poller scheduler");
            this.m_scheduler = new LegacyScheduler("Poller", this.getPollerConfig().getThreads());
        }
        catch (RuntimeException e) {
            log.fatal((Object)"init: Failed to create poller scheduler", (Throwable)e);
            throw e;
        }
    }

    protected void onStart() {
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"start: Starting poller scheduler");
            }
            this.m_scheduler.start();
        }
        catch (RuntimeException e) {
            if (this.log().isEnabledFor((Priority)Level.FATAL)) {
                this.log().fatal((Object)"start: Failed to start scheduler", (Throwable)e);
            }
            throw e;
        }
    }

    protected void onStop() {
        this.m_scheduler.stop();
        this.m_receiver.close();
        this.releaseServiceMonitors();
        this.m_scheduler = null;
    }

    private void releaseServiceMonitors() {
        this.getPollerConfig().releaseAllServiceMonitors();
    }

    protected void onPause() {
        this.m_scheduler.pause();
    }

    protected void onResume() {
        this.m_scheduler.resume();
    }

    public static Poller getInstance() {
        return m_singleton;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public ServiceMonitor getServiceMonitor(String svcName) {
        return this.getPollerConfig().getServiceMonitor(svcName);
    }

    public PollableNetwork getNetwork() {
        return this.m_network;
    }

    private void scheduleExistingServices() throws Exception {
        Category log = ThreadCategory.getInstance(this.getClass());
        this.scheduleMatchingServices(null);
        this.m_network.recalculateStatus();
        this.m_network.resetStatusChanged();
        if (log.isDebugEnabled()) {
            log.debug((Object)"scheduleExistingServices: dumping content of pollable network: ");
            this.m_network.dump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleService(final int nodeId, String nodeLabel, final String ipAddr, final String svcName) {
        final Category log = ThreadCategory.getInstance(this.getClass());
        try {
            PollableNode node;
            PollableNetwork pollableNetwork = this.m_network;
            synchronized (pollableNetwork) {
                node = this.m_network.getNode(nodeId);
                if (node == null) {
                    node = this.m_network.createNode(nodeId, nodeLabel);
                }
            }
            final PollableNode svcNode = node;
            Runnable r = new Runnable(){

                public void run() {
                    int matchCount = Poller.this.scheduleMatchingServices("ifServices.nodeId = " + nodeId + " AND ifServices.ipAddr = '" + ipAddr + "' AND service.serviceName = '" + svcName + "'");
                    if (matchCount > 0) {
                        svcNode.recalculateStatus();
                        svcNode.resetStatusChanged();
                    } else {
                        log.warn((Object)("Attempt to schedule service " + nodeId + "/" + ipAddr + "/" + svcName + " found no active service"));
                    }
                }
            };
            node.withTreeLock(r);
        }
        catch (Exception e) {
            log.error((Object)("Unable to schedule service " + nodeId + "/" + ipAddr + "/" + svcName), (Throwable)e);
        }
    }

    private int scheduleMatchingServices(String criteria) {
        String sql = "SELECT ifServices.nodeId AS nodeId, node.nodeLabel AS nodeLabel, ifServices.ipAddr AS ipAddr, ifServices.serviceId AS serviceId, service.serviceName AS serviceName, outages.svcLostEventId AS svcLostEventId, events.eventUei AS svcLostEventUei, outages.ifLostService AS ifLostService, outages.ifRegainedService AS ifRegainedService FROM ifServices JOIN node ON ifServices.nodeId = node.nodeId JOIN service ON ifServices.serviceId = service.serviceId LEFT OUTER JOIN outages ON ifServices.nodeId = outages.nodeId AND ifServices.ipAddr = outages.ipAddr AND ifServices.serviceId = outages.serviceId AND ifRegainedService IS NULL LEFT OUTER JOIN events ON outages.svcLostEventId = events.eventid WHERE ifServices.status = 'A'" + (criteria == null ? "" : " AND " + criteria);
        Querier querier = new Querier(this.m_dbConnectionFactory, sql){

            public void processRow(ResultSet rs) throws SQLException {
                Poller.this.scheduleService(rs.getInt("nodeId"), rs.getString("nodeLabel"), rs.getString("ipAddr"), rs.getString("serviceName"), (Number)rs.getObject("svcLostEventId"), rs.getTimestamp("ifLostService"), rs.getString("svcLostEventUei"));
            }
        };
        querier.execute();
        return querier.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleService(int nodeId, String nodeLabel, String ipAddr, String serviceName, Number svcLostEventId, Date date, String svcLostUei) {
        InetAddress addr;
        Category log = ThreadCategory.getInstance();
        Package pkg = this.findPackageForService(ipAddr, serviceName);
        if (pkg == null) {
            log.warn((Object)("Active service " + serviceName + " on " + ipAddr + " not configured for any package"));
            return;
        }
        ServiceMonitor monitor = this.m_pollerConfig.getServiceMonitor(serviceName);
        if (monitor == null) {
            log.info((Object)("Could not find service monitor associated with service " + serviceName));
            return;
        }
        try {
            addr = InetAddress.getByName(ipAddr);
        }
        catch (UnknownHostException e) {
            log.error((Object)("Could not convert " + ipAddr + " as an InetAddress " + ipAddr));
            return;
        }
        PollableService svc = this.m_network.createService(nodeId, nodeLabel, addr, serviceName);
        PollableServiceConfig pollConfig = new PollableServiceConfig(svc, this.m_pollerConfig, this.m_pollOutagesConfig, pkg, this.m_scheduler);
        svc.setPollConfig(pollConfig);
        PollableService pollableService = svc;
        synchronized (pollableService) {
            if (svc.getSchedule() == null) {
                Schedule schedule = new Schedule(svc, pollConfig, this.m_scheduler);
                svc.setSchedule(schedule);
            }
        }
        if (svcLostEventId == null) {
            svc.updateStatus(PollStatus.up());
        } else {
            svc.updateStatus(PollStatus.down());
            InitCause causeSetter = new InitCause();
            DbPollEvent cause = new DbPollEvent(svcLostEventId.intValue(), date);
            causeSetter.setCause(cause);
            if ("uei.opennms.org/nodes/nodeLostService".equals(svcLostUei)) {
                svc.visit(causeSetter);
            } else if ("uei.opennms.org/nodes/interfaceDown".equals(svcLostUei)) {
                svc.getInterface().visit(causeSetter);
            } else if ("uei.opennms.org/nodes/nodeDown".equals(svcLostUei)) {
                svc.getNode().visit(causeSetter);
            }
        }
        svc.schedule();
    }

    private Package findPackageForService(String ipAddr, String serviceName) {
        Enumeration en = this.m_pollerConfig.enumeratePackage();
        Package lastPkg = null;
        while (en.hasMoreElements()) {
            Package pkg = (Package)en.nextElement();
            if (!this.pollableServiceInPackage(ipAddr, serviceName, pkg)) continue;
            lastPkg = pkg;
        }
        return lastPkg;
    }

    protected boolean pollableServiceInPackage(String ipAddr, String serviceName, Package pkg) {
        if (pkg.getRemote()) {
            this.log().debug((Object)("pollableServiceInPackage: this package: " + pkg.getName() + ", is a remote monitor package."));
            return false;
        }
        if (!this.m_pollerConfig.serviceInPackageAndEnabled(serviceName, pkg)) {
            return false;
        }
        boolean inPkg = this.m_pollerConfig.interfaceInPackage(ipAddr, pkg);
        if (inPkg) {
            return true;
        }
        if (this.m_initialized) {
            this.m_pollerConfig.rebuildPackageIpListMap();
            return this.m_pollerConfig.interfaceInPackage(ipAddr, pkg);
        }
        return false;
    }

    public boolean packageIncludesIfAndSvc(Package pkg, String ipAddr, String svcName) {
        Category log = ThreadCategory.getInstance();
        if (!this.getPollerConfig().serviceInPackageAndEnabled(svcName, pkg)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("packageIncludesIfAndSvc: address/service: " + ipAddr + "/" + svcName + " not scheduled, service is not enabled or does not exist in package: " + pkg.getName()));
            }
            return false;
        }
        if (!this.getPollerConfig().interfaceInPackage(ipAddr, pkg)) {
            if (this.m_initialized) {
                this.getPollerConfig().rebuildPackageIpListMap();
                if (!this.getPollerConfig().interfaceInPackage(ipAddr, pkg)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("packageIncludesIfAndSvc: interface " + ipAddr + " gained service " + svcName + ", but the interface was not in package: " + pkg.getName()));
                    }
                    return false;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("packageIncludesIfAndSvc: address/service: " + ipAddr + "/" + svcName + " not scheduled, interface does not belong to package: " + pkg.getName()));
                }
                return false;
            }
        }
        return true;
    }

    PollerConfig getPollerConfig() {
        return this.m_pollerConfig;
    }

    public void setPollerConfig(PollerConfig pollerConfig) {
        this.m_pollerConfig = pollerConfig;
    }

    PollOutagesConfig getPollOutagesConfig() {
        return this.m_pollOutagesConfig;
    }

    public void setPollOutagesConfig(PollOutagesConfig pollOutagesConfig) {
        this.m_pollOutagesConfig = pollOutagesConfig;
    }

    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    public void setEventManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    void setQueryMgr(QueryManager queryMgr) {
        this.m_queryMgr = queryMgr;
    }

    QueryManager getQueryMgr() {
        return this.m_queryMgr;
    }

    public void setDbConnectionFactory(DataSource dbConnectionFactory) {
        this.m_dbConnectionFactory = dbConnectionFactory;
    }

    public Event createEvent(String uei, int nodeId, InetAddress address, String svcName, Date date, String reason) {
        Category log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)("createEvent: uei = " + uei + " nodeid = " + nodeId));
        }
        Event newEvent = new Event();
        newEvent.setUei(uei);
        newEvent.setSource(this.getName());
        newEvent.setNodeid((long)nodeId);
        if (address != null) {
            newEvent.setInterface(address.getHostAddress());
        }
        if (svcName != null) {
            newEvent.setService(svcName);
        }
        try {
            newEvent.setHost(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException uhE) {
            newEvent.setHost("unresolved.host");
            log.warn((Object)"Failed to resolve local hostname", (Throwable)uhE);
        }
        newEvent.setTime(EventConstants.formatToString(date));
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        Value parmValue = new Value();
        if (uei.equals("uei.opennms.org/nodes/nodeDown") && this.getPollerConfig().pathOutageEnabled()) {
            String[] criticalPath = this.getCriticalPath(nodeId);
            boolean isPathOk = true;
            isPathOk = this.testCriticalPath(criticalPath);
            if (!isPathOk) {
                log.debug((Object)("Critical path test failed for node " + nodeId));
                eventParm = new Parm();
                eventParm.setParmName("eventReason");
                parmValue = new Value();
                parmValue.setContent("pathOutage");
                eventParm.setValue(parmValue);
                eventParms.addParm(eventParm);
                eventParm = new Parm();
                eventParm.setParmName("criticalPathIp");
                parmValue = new Value();
                parmValue.setContent(criticalPath[0]);
                eventParm.setValue(parmValue);
                eventParms.addParm(eventParm);
                eventParm = new Parm();
                eventParm.setParmName("criticalPathServiceName");
                parmValue = new Value();
                parmValue.setContent(criticalPath[1]);
                eventParm.setValue(parmValue);
                eventParms.addParm(eventParm);
            } else {
                log.debug((Object)("Critical path test passed for node " + nodeId));
            }
        }
        if (uei.equals("uei.opennms.org/nodes/nodeLostService")) {
            eventParm = new Parm();
            eventParm.setParmName("eventReason");
            parmValue = new Value();
            parmValue.setContent(reason == null ? "Unknown" : reason);
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (uei.equals("uei.opennms.org/nodes/nodeUp") || uei.equals("uei.opennms.org/nodes/nodeDown")) {
            String nodeLabel = null;
            try {
                nodeLabel = this.getQueryMgr().getNodeLabel(nodeId);
            }
            catch (SQLException sqlE) {
                log.warn((Object)("Failed to retrieve node label for nodeid " + nodeId), (Throwable)sqlE);
            }
            if (nodeLabel == null) {
                nodeLabel = String.valueOf(nodeId);
            }
            eventParm = new Parm();
            eventParm.setParmName("nodelabel");
            parmValue = new Value();
            parmValue.setContent(nodeLabel);
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (eventParms.getParmCount() > 0) {
            newEvent.setParms(eventParms);
        }
        return newEvent;
    }

    public void refreshServicePackages() {
        PollableVisitorAdaptor visitor = new PollableVisitorAdaptor(){

            public void visitService(PollableService service) {
                service.refreshConfig();
            }
        };
        this.m_network.visit(visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getCriticalPath(int nodeId) {
        Category log = ThreadCategory.getInstance(this.getClass());
        String SQL_DB_RETRIEVE_PATHOUTAGE = "SELECT criticalpathip, criticalpathservicename FROM pathoutage where nodeid=?";
        String[] cpath = new String[2];
        Connection dbc = null;
        try {
            dbc = DataSourceFactory.getInstance().getConnection();
            PreparedStatement stmt = dbc.prepareStatement(SQL_DB_RETRIEVE_PATHOUTAGE);
            stmt.setLong(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                cpath[0] = rs.getString(1);
                cpath[1] = rs.getString(2);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqlE) {
            log.error((Object)("getCriticalPath: SQLException " + sqlE));
        }
        finally {
            try {
                dbc.close();
            }
            catch (Exception e) {
                log.error((Object)("getCriticalPath: Exception on close" + e));
            }
        }
        if (cpath[0] == null || cpath[0].equals("")) {
            cpath[0] = OpennmsServerConfigFactory.getInstance().getDefaultCriticalPathIp();
            cpath[1] = "ICMP";
        }
        if (cpath[1] == null || cpath[1].equals("")) {
            cpath[1] = "ICMP";
        }
        return cpath;
    }

    private boolean testCriticalPath(String[] criticalPath) {
        InetAddress addr = null;
        boolean result = true;
        try {
            addr = InetAddress.getByName(criticalPath[0]);
        }
        catch (UnknownHostException e) {
            this.log().error((Object)("failed to convert string address to InetAddress " + criticalPath[0]));
            return true;
        }
        try {
            IcmpPlugin p = new IcmpPlugin();
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("retry", new Integer(OpennmsServerConfigFactory.getInstance().getDefaultCriticalPathRetries()));
            map.put("timeout", new Integer(OpennmsServerConfigFactory.getInstance().getDefaultCriticalPathTimeout()));
            result = p.isProtocolSupported(addr, map);
        }
        catch (IOException e) {
            this.log().error((Object)("IOException when testing critical path " + e));
        }
        return result;
    }

    private static class InitCause
    extends PollableVisitorAdaptor {
        private PollEvent m_cause;

        private InitCause() {
        }

        public void setCause(PollEvent cause) {
            this.m_cause = cause;
        }

        public void visitElement(PollableElement element) {
            if (!element.hasOpenOutage()) {
                element.setCause(this.m_cause);
            }
        }
    }
}

