/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Category;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;

public class XMPPNotificationManager {
    private Properties props = new Properties();
    private static final String LOG4J_CATEGORY = "OpenNMS.Notifd";
    private static final String XMPP_RESOURCE = "notifd";
    private static final String TRUST_STORE_PASSWORD = "changeit";
    private static final int XMPP_PORT = 5222;
    private static XMPPConnection xmpp = null;
    private static ConnectionConfiguration xmppConfig = null;
    private String xmppServer;
    private String xmppUser;
    private String xmppPassword;
    private int xmppPort;
    private HashMap<String, GroupChat> rooms;
    private static XMPPNotificationManager instance = null;
    private ConnectionListener conlistener = new ConnectionListener(){

        public void connectionClosed() {
            XMPPNotificationManager.this.log().debug((Object)"XMPP Connection Closed");
            instance = null;
        }

        public void connectionClosedOnError(Exception e) {
            XMPPNotificationManager.this.log().debug((Object)("XMPP Connection Closed" + e.toString()));
            instance = null;
        }
    };

    protected XMPPNotificationManager() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        try {
            this.props.load(new FileInputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.XMPP_CONFIG_FILE_NAME)));
            this.xmppServer = this.props.getProperty("xmpp.server");
            this.xmppUser = this.props.getProperty("xmpp.user");
            this.xmppPassword = this.props.getProperty("xmpp.pass");
            this.xmppPort = this.props.containsKey("xmpp.port") ? Integer.valueOf(this.props.getProperty("xmpp.port")) : 5222;
            xmppConfig = new ConnectionConfiguration(this.xmppServer, this.xmppPort);
            if (this.props.containsKey("xmpp.TLSEnabled") && this.props.getProperty("xmpp.TLSEnabled").equals("true")) {
                xmppConfig.setTLSEnabled(true);
                this.log().debug((Object)"XMPPManager Enabling TLS");
            } else {
                xmppConfig.setTLSEnabled(false);
            }
            if (this.props.containsKey("xmpp.selfSignedCertificateEnabled") && this.props.getProperty("xmpp.selfSignedCertificateEnabled").equals("true")) {
                xmppConfig.setSelfSignedCertificateEnabled(true);
                this.log().debug((Object)"XMPPManager Enabling self-signed certificates");
            } else {
                xmppConfig.setSelfSignedCertificateEnabled(false);
            }
            if (this.props.containsKey("xmpp.truststorePassword")) {
                xmppConfig.setTruststorePassword(this.props.getProperty("xmpp.truststorePassword"));
                this.log().debug((Object)"XMPPManager set non-default truststore password");
            } else {
                this.log().debug((Object)"XMPPManager set default truststore password");
                xmppConfig.setTruststorePassword(TRUST_STORE_PASSWORD);
            }
            if (this.props.containsKey("xmpp.debuggerEnabled") && this.props.getProperty("xmpp.debuggerEnabled").equals("true")) {
                xmppConfig.setDebuggerEnabled(true);
                this.log().debug((Object)"XMPPManager set debugger enabled");
            } else {
                xmppConfig.setDebuggerEnabled(false);
                this.log().debug((Object)"XMPPManager set debugger disabled");
            }
            xmppConfig.setSASLAuthenticationEnabled(true);
            this.log().debug((Object)("XMPP Manager connection config: " + xmppConfig.toString()));
            this.log().debug((Object)"never get here");
        }
        catch (Exception e) {
            this.log().error((Object)"XMPP Manager couldn't configure connection : ", (Throwable)e);
        }
        try {
            this.log().debug((Object)("Attempting vanilla XMPP Connection to " + this.xmppServer + ":" + this.xmppPort));
            xmpp = new XMPPConnection(xmppConfig);
            if (xmpp.isConnected()) {
                this.log().debug((Object)"XMPP Manager successfully connected");
                if (xmpp.isSecureConnection()) {
                    this.log().debug((Object)"XMPP Manager successfully nogotiated a secure connection");
                }
                if (xmpp.isUsingTLS()) {
                    this.log().debug((Object)"XMPP Manager successfully nogotiated a TLS connection");
                }
                this.log().debug((Object)"XMPP Manager Connected");
                this.login();
                xmpp.addConnectionListener(this.conlistener);
            } else {
                this.log().debug((Object)"XMPP Manager Not Connected");
            }
        }
        catch (Exception e) {
            this.log().fatal((Object)"XMPP Manager unable to connect : ", (Throwable)e);
        }
    }

    public static synchronized XMPPNotificationManager getInstance() {
        if (instance == null) {
            instance = new XMPPNotificationManager();
        }
        return instance;
    }

    private void login() {
        try {
            if (xmpp.isConnected()) {
                this.log().debug((Object)"XMPP Manager logging in");
                xmpp.login(this.xmppUser, this.xmppPassword, XMPP_RESOURCE);
                this.rooms = new HashMap();
            } else {
                this.log().debug((Object)"XMPP Manager unable to login: Not connected to XMPP server");
            }
        }
        catch (Exception e) {
            this.log().fatal((Object)"XMPP Manager unable to login: ", (Throwable)e);
        }
    }

    public boolean isLoggedIn() {
        return xmpp.isAuthenticated();
    }

    public boolean sendMessage(String xmppTo, String xmppMessage) {
        try {
            xmpp.createChat(xmppTo).sendMessage(xmppMessage);
            this.log().debug((Object)("XMPP Manager sent message to: " + xmppTo));
        }
        catch (XMPPException e) {
            this.log().fatal((Object)"XMPP Exception Sending message ", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean sendGroupChat(String xmppChatRoom, String xmppMessage) {
        GroupChat groupChat;
        String room = new String(xmppChatRoom);
        if (this.rooms.containsKey(xmppChatRoom)) {
            groupChat = this.rooms.get(xmppChatRoom);
        } else {
            this.log().debug((Object)("Adding room: " + xmppChatRoom));
            groupChat = xmpp.createGroupChat(xmppChatRoom);
            this.rooms.put(room, groupChat);
        }
        if (!groupChat.isJoined()) {
            this.log().debug((Object)("Joining room: " + xmppChatRoom));
            try {
                groupChat.join(this.xmppUser);
            }
            catch (XMPPException e) {
                this.log().fatal((Object)"XMPP Exception joining chat room ", (Throwable)e);
                return false;
            }
        }
        try {
            groupChat.sendMessage(xmppMessage);
            this.log().debug((Object)("XMPP Manager sent message to: " + xmppChatRoom));
        }
        catch (XMPPException e) {
            this.log().fatal((Object)"XMPP Exception sending message to Chat room", (Throwable)e);
            return false;
        }
        return true;
    }

    protected Category log() {
        return ThreadCategory.getInstance();
    }
}

