/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import org.opennms.netmgt.capsd.snmp.NamedSnmpVar;
import org.opennms.netmgt.capsd.snmp.SnmpTableEntry;
import org.opennms.netmgt.linkd.snmp.VlanCollectorEntry;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

public final class ThreeComVlanTableEntry
extends SnmpTableEntry
implements VlanCollectorEntry {
    public static final String VLAN_IN = "a3ComVlanindex";
    public static final String VLAN_IFINFO = "a3ComVlanIfInfo";
    private static String VLAN_INDEX_OID = ".1.3.6.1.4.1.43.10.1.14.1.2.1.4";
    private static String VLAN_NAME_OID = ".1.3.6.1.4.1.43.10.1.14.1.2.1.2";
    private boolean hasVlanIndex = false;
    public static NamedSnmpVar[] threeComVlan_elemList = null;
    public static final String TABLE_OID = " 1.3.6.1.4.1.43.10.1.14.1.2.1";

    public ThreeComVlanTableEntry() {
        super(threeComVlan_elemList);
    }

    public void storeResult(SnmpObjId base, SnmpInstId inst, SnmpValue val) {
        if (!this.hasVlanIndex) {
            int vlanid = inst.getLastSubId();
            super.storeResult(SnmpObjId.get((String)VLAN_INDEX_OID), inst, SnmpUtils.getValueFactory().getInt32(vlanid));
            super.storeResult(SnmpObjId.get((String)VLAN_NAME_OID), inst, SnmpUtils.getValueFactory().getOctetString("default".getBytes()));
            this.hasVlanIndex = true;
        }
        super.storeResult(base, inst, val);
    }

    static {
        threeComVlan_elemList = new NamedSnmpVar[6];
        int ndx = 0;
        ThreeComVlanTableEntry.threeComVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", VLAN_IN, ".1.3.6.1.4.1.43.10.1.14.1.2.1.1", 1);
        ThreeComVlanTableEntry.threeComVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "vtpVlanName", ".1.3.6.1.4.1.43.10.1.14.1.2.1.2", 2);
        ThreeComVlanTableEntry.threeComVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "vtpVlanType", ".1.3.6.1.4.1.43.10.1.14.1.2.1.3", 3);
        ThreeComVlanTableEntry.threeComVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "vtpVlanIndex", ".1.3.6.1.4.1.43.10.1.14.1.2.1.4", 4);
        ThreeComVlanTableEntry.threeComVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", VLAN_IFINFO, ".1.3.6.1.4.1.43.10.1.14.1.2.1.5", 5);
        ThreeComVlanTableEntry.threeComVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "vtpVlanStatus", ".1.3.6.1.4.1.43.10.1.14.1.2.1.6", 6);
    }
}

