/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import java.net.InetAddress;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.snmp.NamedSnmpVar;
import org.opennms.netmgt.capsd.snmp.SnmpStore;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;

public final class Dot1dBaseGroup
extends AggregateTracker {
    public static final String BASE_BRIDGE_ADDRESS = "dot1dBaseBridgeAddress";
    public static final String BASE_NUM_PORTS = "dot1dBaseNumPorts";
    public static final String BASE_NUM_TYPE = "dot1dBaseType";
    public static NamedSnmpVar[] ms_elemList = null;
    public static final String SYSTEM_OID = ".1.3.6.1.2.1.17.1";
    private SnmpStore m_store;
    private InetAddress m_address;

    public Dot1dBaseGroup(InetAddress address) {
        super((Collectable[])NamedSnmpVar.getTrackersFor(ms_elemList));
        this.m_address = address;
        this.m_store = new SnmpStore(ms_elemList);
    }

    protected void storeResult(SnmpObjId base, SnmpInstId inst, SnmpValue val) {
        this.m_store.storeResult(base, inst, val);
    }

    protected void reportGenErr(String msg) {
        this.log().warn((Object)("Error retrieving systemGroup from " + this.m_address + ". " + msg));
    }

    protected void reportNoSuchNameErr(String msg) {
        this.log().info((Object)("Error retrieving systemGroup from " + this.m_address + ". " + msg));
    }

    private final Category log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }

    public String getBridgeAddress() {
        return this.m_store.getHexString(BASE_BRIDGE_ADDRESS);
    }

    public int getNumberOfPorts() {
        Integer nop = this.m_store.getInt32(BASE_NUM_PORTS);
        if (nop == null) {
            return -1;
        }
        return nop;
    }

    public int getBridgeType() {
        Integer type = this.m_store.getInt32(BASE_NUM_TYPE);
        if (type == null) {
            return -1;
        }
        return type;
    }

    static {
        ms_elemList = new NamedSnmpVar[3];
        int ndx = 0;
        Dot1dBaseGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", BASE_BRIDGE_ADDRESS, ".1.3.6.1.2.1.17.1.1");
        Dot1dBaseGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", BASE_NUM_PORTS, ".1.3.6.1.2.1.17.1.2");
        Dot1dBaseGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", BASE_NUM_TYPE, ".1.3.6.1.2.1.17.1.3");
    }
}

