/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.snmp.SnmpTable;
import org.opennms.netmgt.capsd.snmp.SnmpTableEntry;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.linkd.SnmpVlanCollection;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.Scheduler;
import org.opennms.netmgt.linkd.snmp.CdpCacheTable;
import org.opennms.netmgt.linkd.snmp.IpNetToMediaTable;
import org.opennms.netmgt.linkd.snmp.IpRouteTable;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SnmpCollection
implements ReadyRunnable {
    private static final String TRUNK_VLAN_NAME = "AllVlans";
    private static final int TRUNK_VLAN_INDEX = 0;
    private static final String DEFAULT_VLAN_NAME = "default";
    private static final int DEFAULT_VLAN_INDEX = 1;
    private SnmpAgentConfig m_agentConfig;
    private final InetAddress m_address;
    private String m_vlanClass = null;
    private boolean m_collectVlanTable = false;
    public IpNetToMediaTable m_ipNetToMedia;
    public IpRouteTable m_ipRoute;
    public CdpCacheTable m_CdpCache;
    public SnmpTable m_vlanTable;
    public Map<Vlan, SnmpVlanCollection> m_snmpVlanCollection = new HashMap<Vlan, SnmpVlanCollection>();
    private Scheduler m_scheduler;
    private long poll_interval = 1800000L;
    private long initial_sleep_time = 600000L;
    private boolean suspendCollection = false;
    private boolean runned = false;

    private SnmpCollection() {
        throw new UnsupportedOperationException("default constructor not supported");
    }

    public SnmpCollection(SnmpAgentConfig config) {
        this.m_agentConfig = config;
        this.m_address = this.m_agentConfig.getAddress();
        this.m_ipNetToMedia = null;
        this.m_ipRoute = null;
        this.m_vlanTable = null;
        this.m_CdpCache = null;
        this.m_snmpVlanCollection.clear();
    }

    boolean failed() {
        return !this.hasIpNetToMediaTable() && !this.hasRouteTable() && !this.hasCdpCacheTable() && !this.hasVlanTable();
    }

    boolean hasIpNetToMediaTable() {
        return this.m_ipNetToMedia != null && !this.m_ipNetToMedia.failed();
    }

    IpNetToMediaTable getIpNetToMediaTable() {
        return this.m_ipNetToMedia;
    }

    boolean hasRouteTable() {
        return this.m_ipRoute != null && !this.m_ipRoute.failed();
    }

    IpRouteTable getIpRouteTable() {
        return this.m_ipRoute;
    }

    boolean hasCdpCacheTable() {
        return this.m_CdpCache != null && !this.m_CdpCache.failed();
    }

    CdpCacheTable getCdpCacheTable() {
        return this.m_CdpCache;
    }

    boolean hasVlanTable() {
        return this.m_vlanTable != null && !this.m_vlanTable.failed();
    }

    SnmpTable getVlanTable() {
        return this.m_vlanTable;
    }

    public String getVlanName(int m_vlan) {
        if (this.hasVlanTable()) {
            for (SnmpTableEntry ent : this.getVlanTable().getEntries()) {
                int vlanIndex = ent.getInt32("vtpVlanIndex");
                if (vlanIndex != m_vlan) continue;
                return ent.getDisplayString("vtpVlanName");
            }
        }
        return null;
    }

    public int getVlanIndex(String m_vlanname) {
        if (this.hasVlanTable()) {
            for (SnmpTableEntry ent : this.getVlanTable().getEntries()) {
                String vlanName = ent.getDisplayString("vtpVlanName");
                if (!vlanName.equals(m_vlanname)) continue;
                return ent.getInt32("vtpVlanIndex");
            }
        }
        return -1;
    }

    Map<Vlan, SnmpVlanCollection> getSnmpVlanCollections() {
        return this.m_snmpVlanCollection;
    }

    @Override
    public void run() {
        Category log = ThreadCategory.getInstance(this.getClass());
        if (this.suspendCollection) {
            log.debug((Object)("SnmpCollection.run: address: " + this.m_address.getHostAddress() + " Suspended!"));
        } else {
            this.m_ipNetToMedia = new IpNetToMediaTable(this.m_address);
            this.m_ipRoute = new IpRouteTable(this.m_address);
            this.m_CdpCache = new CdpCacheTable(this.m_address);
            if (log.isDebugEnabled()) {
                log.debug((Object)("run: collecting : " + this.m_agentConfig));
            }
            SnmpWalker walker = null;
            if (this.m_collectVlanTable) {
                Class<?> vlanGetter = null;
                try {
                    vlanGetter = Class.forName(this.m_vlanClass);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("SnmpCollection.run: " + this.m_vlanClass + " class not found " + e));
                }
                Class[] classes = new Class[]{InetAddress.class};
                Constructor<?> constr = null;
                try {
                    constr = vlanGetter.getConstructor(classes);
                }
                catch (NoSuchMethodException e) {
                    log.error((Object)("SnmpCollection.run: " + this.m_vlanClass + " class has not such method " + e));
                }
                catch (SecurityException s) {
                    log.error((Object)("SnmpCollection.run: " + this.m_vlanClass + " class security violation " + s));
                }
                Object[] argum = new Object[]{this.m_address};
                try {
                    this.m_vlanTable = (SnmpTable)((Object)constr.newInstance(argum));
                }
                catch (InvocationTargetException t) {
                    log.error((Object)("SnmpCollection.run: " + this.m_vlanClass + " class Invocation Exception " + t));
                }
                catch (InstantiationException i) {
                    log.error((Object)("SnmpCollection.run: " + this.m_vlanClass + " class Instantiation Exception " + i));
                }
                catch (IllegalAccessException s) {
                    log.error((Object)("SnmpCollection.run: " + this.m_vlanClass + " class Illegal Access Exception " + s));
                }
                walker = SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"ipNetToMediaTable/ipRouteTable/cdpCacheTable/vlanTable", (CollectionTracker[])new CollectionTracker[]{this.m_ipNetToMedia, this.m_ipRoute, this.m_CdpCache, this.m_vlanTable});
            } else {
                walker = SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"ipNetToMediaTable/ipRouteTable/cdpCacheTable", (CollectionTracker[])new CollectionTracker[]{this.m_ipNetToMedia, this.m_ipRoute, this.m_CdpCache});
            }
            walker.start();
            try {
                walker.waitFor(300000L);
            }
            catch (InterruptedException e) {
                this.m_ipNetToMedia = null;
                this.m_ipRoute = null;
                this.m_CdpCache = null;
                this.m_vlanTable = null;
                log.warn((Object)"SnmpCollection.run: collection interrupted, exiting", (Throwable)e);
                return;
            }
            if (!this.hasIpNetToMediaTable()) {
                log.info((Object)("SnmpCollection.run: failed to collect ipNetToMediaTable for " + this.m_address.getHostAddress()));
            }
            if (!this.hasRouteTable()) {
                log.info((Object)("SnmpCollection.run: failed to collect ipRouteTable for " + this.m_address.getHostAddress()));
            }
            if (!this.hasCdpCacheTable()) {
                log.info((Object)("SnmpCollection.run: failed to collect dpCacheTable for " + this.m_address.getHostAddress()));
            }
            if (this.m_collectVlanTable && !this.hasVlanTable()) {
                log.info((Object)("SnmpCollection.run: failed to collect Vlan for " + this.m_address.getHostAddress()));
            }
            SnmpVlanCollection snmpvlancollection = null;
            Vlan vlan = null;
            if (this.hasVlanTable()) {
                if (!this.m_vlanClass.equals("org.opennms.netmgt.linkd.snmp.CiscoVlanTable") && !this.m_vlanClass.equals("org.opennms.netmgt.linkd.snmp.IntelVlanTable")) {
                    vlan = new Vlan(0, TRUNK_VLAN_NAME);
                    snmpvlancollection = new SnmpVlanCollection(this.m_agentConfig);
                    snmpvlancollection.run();
                    if (snmpvlancollection.failed()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"SnmpCollection.run: no bridge info found");
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"SnmpCollection.run: adding bridge info to snmpcollection");
                        }
                        this.m_snmpVlanCollection.put(vlan, snmpvlancollection);
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("SnmpCollection.run: start collection for " + this.getVlanTable().getEntries().size() + " VLAN entries "));
                    }
                    for (SnmpTableEntry ent : this.m_vlanTable.getEntries()) {
                        Integer status;
                        int vlanindex = ent.getInt32("vtpVlanIndex");
                        if (vlanindex == -1) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"SnmpCollection.run: found null value for vlan.");
                            continue;
                        }
                        String vlanname = ent.getDisplayString("vtpVlanName");
                        if (vlanname == null) {
                            vlanname = DEFAULT_VLAN_NAME;
                        }
                        vlan = new Vlan(vlanindex, vlanname);
                        String community = this.m_agentConfig.getReadCommunity();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("SnmpCollection.run: peer community: " + community + " with VLAN " + vlan));
                        }
                        if ((status = ent.getInt32("vtpVlanStatus")) == null || status != 1) {
                            if (!log.isInfoEnabled()) continue;
                            log.info((Object)("SnmpCollection.run: skipping VLAN " + vlan + " NOT ACTIVE or null "));
                            continue;
                        }
                        Integer type = ent.getInt32("vtpVlanType");
                        if (type == null || type != 1) {
                            if (!log.isInfoEnabled()) continue;
                            log.info((Object)("SnmpCollection.run: skipping VLAN " + vlan + " NOT ETHERNET TYPE"));
                            continue;
                        }
                        this.m_agentConfig.setReadCommunity(community + "@" + vlanindex);
                        snmpvlancollection = new SnmpVlanCollection(this.m_agentConfig);
                        snmpvlancollection.run();
                        if (snmpvlancollection.failed()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("SnmpCollection.run: no bridge info found for VLAN " + vlan));
                            }
                        } else {
                            this.m_snmpVlanCollection.put(vlan, snmpvlancollection);
                        }
                        this.m_agentConfig.setReadCommunity(community);
                    }
                }
            } else {
                vlan = new Vlan(1, DEFAULT_VLAN_NAME);
                snmpvlancollection = new SnmpVlanCollection(this.m_agentConfig);
                snmpvlancollection.run();
                if (snmpvlancollection.failed()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"SnmpCollection.run: no bridge info found");
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"SnmpCollection.run: adding bridge info to snmpcollection");
                    }
                    this.m_snmpVlanCollection.put(vlan, snmpvlancollection);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"SnmpCollection.run: saving collection into database ");
            }
            Linkd.getInstance().updateNodeSnmpCollection(this);
            this.m_ipNetToMedia = null;
            this.m_ipRoute = null;
            this.m_CdpCache = null;
            this.m_vlanTable = null;
            this.m_snmpVlanCollection.clear();
        }
        this.reschedule();
        this.runned = true;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public long getInitialSleepTime() {
        return this.initial_sleep_time;
    }

    public void setInitialSleepTime(long initial_sleep_time) {
        this.initial_sleep_time = initial_sleep_time;
    }

    public long getPollInterval() {
        return this.poll_interval;
    }

    public void setPollInterval(long interval) {
        this.poll_interval = interval;
    }

    @Override
    public void schedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.poll_interval + this.initial_sleep_time, this);
    }

    private void reschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.poll_interval, this);
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public boolean isSuspended() {
        return this.suspendCollection;
    }

    @Override
    public void suspend() {
        this.suspendCollection = true;
    }

    @Override
    public void wakeUp() {
        this.suspendCollection = false;
    }

    @Override
    public void unschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("rescedule: Cannot schedule a service whose scheduler is set to null");
        }
        if (this.runned) {
            this.m_scheduler.unschedule(this, this.poll_interval);
        } else {
            this.m_scheduler.unschedule(this, this.poll_interval + this.initial_sleep_time);
        }
    }

    public String getVlanClass() {
        return this.m_vlanClass;
    }

    public void setVlanClass(String className) {
        if (className == null || className.equals("")) {
            return;
        }
        this.m_vlanClass = className;
        this.m_collectVlanTable = true;
    }

    public InetAddress getTarget() {
        return this.m_address;
    }

    public boolean isSnmpCollection() {
        return true;
    }

    public boolean isDiscoveryLink() {
        return false;
    }

    public boolean collectVlanTable() {
        return this.m_collectVlanTable;
    }

    public String getReadCommunity() {
        return this.m_agentConfig.getReadCommunity();
    }

    public SnmpAgentConfig getPeer() {
        return this.m_agentConfig;
    }

    public int getPort() {
        return this.m_agentConfig.getPort();
    }

    @Override
    public boolean equals(ReadyRunnable run) {
        SnmpCollection c;
        return run instanceof SnmpCollection && (c = (SnmpCollection)run).getTarget().equals(this.m_address) && c.getPort() == this.getPort() && c.getReadCommunity().equals(this.getReadCommunity());
    }

    @Override
    public String getInfo() {
        return "Ready Runnable(s) SnmpCollection with ip/port/community " + this.getTarget() + "/" + this.getPort() + "/" + this.getReadCommunity();
    }

    class Vlan {
        int vlanindex;
        String vlanname;

        Vlan(int index, String name) {
            this.vlanindex = index;
            this.vlanname = name;
        }

        int getVlanindex() {
            return this.vlanindex;
        }

        String getVlanname() {
            return this.vlanname;
        }
    }
}

