/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.LinkdConfigFactory;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.linkd.DbEventWriter;
import org.opennms.netmgt.linkd.DiscoveryLink;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.LinkdEventProcessor;
import org.opennms.netmgt.linkd.SnmpCollection;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.Scheduler;
import org.opennms.netmgt.xml.event.Event;

public class Linkd
implements PausableFiber {
    private static final String LOG4J_CATEGORY = "OpenNMS.Linkd";
    private static final Linkd m_singleton = new Linkd();
    private int m_status = 0;
    private Scheduler m_scheduler = null;
    private LinkdEventProcessor m_receiver;
    private HashMap<String, LinkableNode> snmpprimaryip2nodes;
    private HashMap<Integer, SnmpCollection> nodeid2snmpcollection;
    private EventIpcManager m_eventMgr;
    private boolean scheduledDiscoveryLink = false;
    private static long m_snmp_poll_interval = 1800000L;
    private static long m_initial_sleep_time = 300000L;
    private static long m_discovery_link_interval = 600000L;
    private static boolean m_auto_discovery = false;
    private List<String> newSuspenctEventsIpAddr = null;

    private Linkd() {
    }

    public static Linkd getInstance() {
        return m_singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        Category log = ThreadCategory.getInstance();
        if (log.isInfoEnabled()) {
            log.info((Object)("init: Category Level Set to " + log.getLevel().toString()));
        }
        try {
            CapsdConfigFactory.init();
        }
        catch (MarshalException ex) {
            log.error((Object)"Failed to load Capsd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            log.error((Object)"Failed to load Capsd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            log.error((Object)"Failed to load Capsd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        try {
            LinkdConfigFactory.init();
        }
        catch (ClassNotFoundException ex) {
            log.error((Object)"init: Failed to load linkd configuration file ", (Throwable)ex);
            return;
        }
        catch (MarshalException ex) {
            log.error((Object)"init: Failed to load linkd configuration file ", (Throwable)ex);
            return;
        }
        catch (ValidationException ex) {
            log.error((Object)"init: Failed to load linkd configuration file ", (Throwable)ex);
            return;
        }
        catch (IOException ex) {
            log.error((Object)"init: Failed to load linkd configuration file ", (Throwable)ex);
            return;
        }
        this.snmpprimaryip2nodes = new HashMap();
        this.nodeid2snmpcollection = new HashMap();
        try {
            SnmpPeerFactory.reload();
        }
        catch (MarshalException ex) {
            log.error((Object)"Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            log.error((Object)"Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            log.error((Object)"Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        try {
            DataSourceFactory.init();
        }
        catch (IOException ie) {
            log.fatal((Object)"IOException loading database config", (Throwable)ie);
            throw new UndeclaredThrowableException(ie);
        }
        catch (MarshalException me) {
            log.fatal((Object)"Marshall Exception loading database config", (Throwable)me);
            throw new UndeclaredThrowableException(me);
        }
        catch (ValidationException ve) {
            log.fatal((Object)"Validation Exception loading database config", (Throwable)ve);
            throw new UndeclaredThrowableException(ve);
        }
        catch (ClassNotFoundException ce) {
            log.fatal((Object)"Class lookup failure loading database config", (Throwable)ce);
            throw new UndeclaredThrowableException(ce);
        }
        catch (PropertyVetoException pve) {
            log.fatal((Object)"Property veto failure loading database config", (Throwable)pve);
            throw new UndeclaredThrowableException(pve);
        }
        catch (SQLException sqle) {
            log.fatal((Object)"SQL exception loading database config", (Throwable)sqle);
            throw new UndeclaredThrowableException(sqle);
        }
        try {
            m_initial_sleep_time = LinkdConfigFactory.getInstance().getInitialSleepTime();
        }
        catch (Throwable t) {
            log.error((Object)("init: Failed to load Initial Sleep Time from linkd configuration file " + t));
        }
        try {
            m_snmp_poll_interval = LinkdConfigFactory.getInstance().getSnmpPollInterval();
        }
        catch (Throwable t) {
            log.error((Object)("init: Failed to load Snmp Poll Interval from linkd configuration file " + t));
        }
        try {
            m_discovery_link_interval = LinkdConfigFactory.getInstance().getDiscoveryLinkInterval();
        }
        catch (Throwable t) {
            log.error((Object)("init: Failed to load Discovery Link Interval from linkd configuration file " + t));
        }
        try {
            m_auto_discovery = LinkdConfigFactory.getInstance().autoDiscovery();
        }
        catch (Throwable t) {
            log.error((Object)("init: Failed to load Auto Discovery from linkd configuration file " + t));
        }
        Connection dbConn = null;
        try {
            dbConn = DataSourceFactory.getInstance().getConnection();
            if (log.isDebugEnabled()) {
                log.debug((Object)"init: Loading Snmp nodes");
            }
            this.snmpprimaryip2nodes = LinkdConfigFactory.getInstance().getLinkableNodes(dbConn);
            this.nodeid2snmpcollection = LinkdConfigFactory.getInstance().getSnmpColls(dbConn);
            LinkdConfigFactory.getInstance().updateDeletedNodes(dbConn);
        }
        catch (SQLException sqlE) {
            log.fatal((Object)"SQL Exception while syncing node object with database information.", (Throwable)sqlE);
            throw new UndeclaredThrowableException(sqlE);
        }
        catch (Throwable t) {
            log.fatal((Object)"Unknown error while syncing node object with database information.", t);
            throw new UndeclaredThrowableException(t);
        }
        finally {
            try {
                if (dbConn != null) {
                    dbConn.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"init: Creating link scheduler");
            }
            this.m_scheduler = new Scheduler("Linkd", LinkdConfigFactory.getInstance().getThreads());
        }
        catch (RuntimeException e) {
            log.fatal((Object)"init: Failed to create linkd scheduler", (Throwable)e);
            throw e;
        }
        catch (Throwable t) {
            log.error((Object)("init: Failed to load threads from linkd configuration file " + t));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init: scheduling " + this.snmpprimaryip2nodes.size() + " Snmp Collections "));
        }
        SnmpCollection snmpCollector2 = null;
        for (SnmpCollection snmpCollector2 : this.nodeid2snmpcollection.values()) {
            log.debug((Object)("init: scheduling Snmp Collection for ip " + snmpCollector2.getTarget().getHostAddress()));
            SnmpCollection e = snmpCollector2;
            synchronized (e) {
                if (snmpCollector2.getScheduler() == null) {
                    snmpCollector2.setScheduler(this.m_scheduler);
                }
                snmpCollector2.setPollInterval(m_snmp_poll_interval);
                snmpCollector2.setInitialSleepTime(m_initial_sleep_time);
                m_initial_sleep_time += 30000L;
            }
            snmpCollector2.schedule();
        }
        if (!this.nodeid2snmpcollection.isEmpty()) {
            DiscoveryLink discoveryLink = new DiscoveryLink();
            if (log.isDebugEnabled()) {
                log.debug((Object)"init: scheduling Discovery Link");
            }
            DiscoveryLink discoveryLink2 = discoveryLink;
            synchronized (discoveryLink2) {
                if (discoveryLink.getScheduler() == null) {
                    discoveryLink.setScheduler(this.m_scheduler);
                }
                discoveryLink.setSnmpPollInterval(m_snmp_poll_interval);
                discoveryLink.setDiscoveryInterval(m_discovery_link_interval);
                discoveryLink.setInitialSleepTime(m_initial_sleep_time);
            }
            discoveryLink.schedule();
            this.scheduledDiscoveryLink = true;
        }
        EventIpcManagerFactory.init();
        this.m_eventMgr = EventIpcManagerFactory.getIpcManager();
        if (log.isDebugEnabled()) {
            log.debug((Object)"init: Creating event Manager");
        }
        this.newSuspenctEventsIpAddr = new ArrayList<String>();
        this.newSuspenctEventsIpAddr.add("127.0.0.1");
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"init: Creating event broadcast event receiver");
            }
            this.m_receiver = new LinkdEventProcessor(this);
        }
        catch (Throwable t) {
            log.error((Object)"init: Failed to initialized the broadcast event receiver", t);
            throw new UndeclaredThrowableException(t);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"init: LINKD CONFIGURATION INITIALIZED");
        }
    }

    public synchronized void start() {
        this.m_status = 1;
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        Category log = ThreadCategory.getInstance();
        if (log.isDebugEnabled()) {
            log.debug((Object)"start: Starting Linkd");
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"start: Starting linkd scheduler");
            }
            this.m_scheduler.start();
        }
        catch (RuntimeException e) {
            log.fatal((Object)"start: Failed to start scheduler", (Throwable)e);
            throw e;
        }
        this.m_status = 2;
        if (log.isInfoEnabled()) {
            log.info((Object)"start: Linkd running");
        }
    }

    public synchronized void stop() {
        this.m_status = 3;
        this.m_scheduler.stop();
        this.m_receiver.close();
        this.m_scheduler = null;
        this.m_status = 4;
        Category log = ThreadCategory.getInstance();
        if (log.isInfoEnabled()) {
            log.info((Object)"stop: Linkd stopped");
        }
    }

    public synchronized void reload() throws IOException {
    }

    public synchronized void pause() {
        if (this.m_status != 2) {
            return;
        }
        this.m_status = 5;
        this.m_scheduler.pause();
        this.m_status = 6;
        Category log = ThreadCategory.getInstance();
        if (log.isInfoEnabled()) {
            log.info((Object)"pause: Linkd paused");
        }
    }

    public synchronized void resume() {
        if (this.m_status != 6) {
            return;
        }
        this.m_status = 7;
        this.m_scheduler.resume();
        this.m_status = 2;
        Category log = ThreadCategory.getInstance();
        if (log.isInfoEnabled()) {
            log.info((Object)"resume: Linkd resumed");
        }
    }

    public String getName() {
        return LOG4J_CATEGORY;
    }

    public int getStatus() {
        return this.m_status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkableNode[] getSnmpLinkableNodes() {
        HashMap<String, LinkableNode> hashMap = this.snmpprimaryip2nodes;
        synchronized (hashMap) {
            return this.snmpprimaryip2nodes.values().toArray(new LinkableNode[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleNodeCollection(int nid) {
        Object dbwriter;
        Category log = ThreadCategory.getInstance();
        Connection dbConn = null;
        SnmpCollection coll = null;
        boolean scheduleSnmpCollection = true;
        try {
            dbConn = DataSourceFactory.getInstance().getConnection();
            if (log.isDebugEnabled()) {
                log.debug((Object)("scheduleNodeCollection: Loading node " + nid + " from database"));
            }
            try {
                coll = LinkdConfigFactory.getInstance().getSnmpCollection(dbConn, nid);
                if (coll == null) {
                    log.warn((Object)"scheduleNodeCollection: Failed to get Linkable node from LinkdConfigFactory. Exiting");
                    return;
                }
            }
            catch (UnknownHostException h) {
                log.warn((Object)("scheduleNodeCollection: Failed to get Linkable node from LinkdConfigFactory" + h));
            }
        }
        catch (SQLException sqlE) {
            log.fatal((Object)"scheduleNodeCollection: SQL Exception while syncing node object with database information.", (Throwable)sqlE);
            throw new UndeclaredThrowableException(sqlE);
        }
        catch (Throwable t) {
            log.fatal((Object)"scheduleNodeCollection: Unknown error while syncing node object with database information.", t);
            throw new UndeclaredThrowableException(t);
        }
        finally {
            try {
                if (dbConn != null) {
                    dbConn.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"scheduleNodeCollection: SQL Exception while syncing node object with database information.", (Throwable)e);
            }
        }
        if (this.nodeid2snmpcollection.containsKey(new Integer(nid))) {
            SnmpCollection oldColl = this.nodeid2snmpcollection.get(new Integer(nid));
            if (oldColl.equals(coll)) {
                scheduleSnmpCollection = false;
                coll = oldColl;
            } else {
                oldColl.unschedule();
                HashMap<String, LinkableNode> hashMap = this.snmpprimaryip2nodes;
                synchronized (hashMap) {
                    this.snmpprimaryip2nodes.remove(this.getLinkableNodeKey(nid));
                }
            }
        }
        if (scheduleSnmpCollection && this.snmpprimaryip2nodes.containsKey(coll.getTarget().getHostAddress())) {
            scheduleSnmpCollection = false;
            LinkableNode oldNode = this.snmpprimaryip2nodes.get(coll.getTarget().getHostAddress());
            if (nid != oldNode.getNodeId()) {
                dbwriter = new DbEventWriter(oldNode.getNodeId(), 'D');
                ((DbEventWriter)dbwriter).run();
                this.nodeid2snmpcollection.remove(new Integer(oldNode.getNodeId()));
            } else {
                coll = this.nodeid2snmpcollection.get(new Integer(nid));
            }
        }
        LinkableNode node = new LinkableNode(nid, coll.getTarget().getHostAddress());
        dbwriter = this.nodeid2snmpcollection;
        synchronized (dbwriter) {
            this.snmpprimaryip2nodes.put(coll.getTarget().getHostAddress(), node);
        }
        dbwriter = this.snmpprimaryip2nodes;
        synchronized (dbwriter) {
            this.nodeid2snmpcollection.put(new Integer(nid), coll);
        }
        if (scheduleSnmpCollection) {
            dbwriter = coll;
            synchronized (dbwriter) {
                if (coll.getScheduler() == null) {
                    coll.setScheduler(this.m_scheduler);
                }
                coll.setPollInterval(m_snmp_poll_interval);
                coll.setInitialSleepTime(0L);
                coll.schedule();
            }
            if (!this.scheduledDiscoveryLink) {
                DiscoveryLink discoveryLink = new DiscoveryLink();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"scheduleNodeCollection: scheduling Discovery Link");
                }
                DiscoveryLink discoveryLink2 = discoveryLink;
                synchronized (discoveryLink2) {
                    if (discoveryLink.getScheduler() == null) {
                        discoveryLink.setScheduler(this.m_scheduler);
                    }
                    discoveryLink.setSnmpPollInterval(m_snmp_poll_interval);
                    discoveryLink.setDiscoveryInterval(m_discovery_link_interval);
                    discoveryLink.setInitialSleepTime(0L);
                }
                discoveryLink.schedule();
                this.scheduledDiscoveryLink = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeUpNodeCollection(int nid) {
        SnmpCollection snmpcoll = null;
        HashMap<Integer, SnmpCollection> hashMap = this.nodeid2snmpcollection;
        synchronized (hashMap) {
            if (this.nodeid2snmpcollection.containsKey(new Integer(nid))) {
                snmpcoll = this.nodeid2snmpcollection.get(new Integer(nid));
            }
        }
        ReadyRunnable rr = this.m_scheduler.getReadyRunnable(snmpcoll);
        if (rr == null) {
            this.scheduleNodeCollection(nid);
        } else {
            rr.wakeUp();
            this.nodeid2snmpcollection.put(new Integer(nid), (SnmpCollection)rr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteNode(int nid) {
        Category log = ThreadCategory.getInstance();
        SnmpCollection collection = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteNode: deleting LinkableNode for node " + nid));
        }
        if (this.nodeid2snmpcollection.containsKey(new Integer(nid))) {
            collection = this.nodeid2snmpcollection.get(new Integer(nid));
        } else {
            log.warn((Object)("deleteNode: no snmp collection found for node " + nid));
        }
        String nodekey = this.getLinkableNodeKey(nid);
        if (nodekey != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("deleteNode: removing linkable node for nodeid " + nid + " key " + nodekey));
            }
            HashMap<String, LinkableNode> hashMap = this.snmpprimaryip2nodes;
            synchronized (hashMap) {
                this.snmpprimaryip2nodes.remove(nodekey);
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("deleteNode: no linkable node found for nodeid " + nid));
        }
        if (collection != null) {
            ReadyRunnable rr = this.m_scheduler.getReadyRunnable(collection);
            if (rr == null) {
                log.warn((Object)("deleteNode: Failed to get " + collection.getInfo() + " with nodeid " + nid));
            } else {
                rr.unschedule();
            }
        }
        DbEventWriter dbwriter = new DbEventWriter(nid, 'D');
        dbwriter.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void suspendNodeCollection(int nid) {
        SnmpCollection snmpcoll = null;
        HashMap<Integer, SnmpCollection> hashMap = this.nodeid2snmpcollection;
        synchronized (hashMap) {
            if (this.nodeid2snmpcollection.containsKey(new Integer(nid))) {
                snmpcoll = this.nodeid2snmpcollection.get(new Integer(nid));
            }
        }
        ReadyRunnable rr = this.m_scheduler.getReadyRunnable(snmpcoll);
        if (rr == null) {
            this.scheduleNodeCollection(nid);
            HashMap<Integer, SnmpCollection> hashMap2 = this.nodeid2snmpcollection;
            synchronized (hashMap2) {
                if (this.nodeid2snmpcollection.containsKey(new Integer(nid))) {
                    snmpcoll = this.nodeid2snmpcollection.get(new Integer(nid));
                }
            }
            rr = this.m_scheduler.getReadyRunnable(snmpcoll);
        }
        if (rr != null) {
            rr.suspend();
        }
        this.nodeid2snmpcollection.put(new Integer(nid), (SnmpCollection)rr);
        DbEventWriter dbwriter = new DbEventWriter(nid, 'N');
        dbwriter.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateNodeSnmpCollection(SnmpCollection snmpcoll) {
        Category log = ThreadCategory.getInstance();
        HashMap<String, LinkableNode> hashMap = this.snmpprimaryip2nodes;
        synchronized (hashMap) {
            if (this.snmpprimaryip2nodes.containsKey(snmpcoll.getTarget().getHostAddress())) {
                LinkableNode node = this.snmpprimaryip2nodes.get(snmpcoll.getTarget().getHostAddress());
                DbEventWriter dbwriter = new DbEventWriter(node.getNodeId(), snmpcoll);
                dbwriter.setAutoDiscovery(m_auto_discovery);
                dbwriter.run();
                node = dbwriter.getLinkableNode();
                this.snmpprimaryip2nodes.put(snmpcoll.getTarget().getHostAddress(), node);
            } else {
                log.warn((Object)"updateNodeSnmpCollection: cannot find Linkable SNMP Node element in hash snmpprimaryip2nodes");
            }
        }
    }

    void updateDiscoveryLinkCollection(DiscoveryLink discover) {
        DbEventWriter dbwriter = new DbEventWriter(discover);
        dbwriter.run();
    }

    void sendNewSuspectEvent(String ipInterface, String ipowner) {
        if (!this.newSuspenctEventsIpAddr.contains(ipInterface)) {
            Event event = new Event();
            event.setSource("linkd");
            event.setUei("uei.opennms.org/internal/discovery/newSuspect");
            event.setHost(ipowner);
            event.setInterface(ipInterface);
            event.setTime(EventConstants.formatToString(new Date()));
            this.m_eventMgr.sendNow(event);
            this.newSuspenctEventsIpAddr.add(ipInterface);
        }
    }

    EventIpcManager getIpcManager() {
        return this.m_eventMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLinkableNodeKey(int nid) {
        HashMap<String, LinkableNode> hashMap = this.snmpprimaryip2nodes;
        synchronized (hashMap) {
            for (Map.Entry<String, LinkableNode> entry : this.snmpprimaryip2nodes.entrySet()) {
                if (entry.getValue().getNodeId() != nid) continue;
                return entry.getKey();
            }
        }
        return null;
    }
}

