/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.datablock;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.eventd.datablock.EventMaskValueList;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Mask;
import org.opennms.netmgt.xml.eventconf.Maskelement;
import org.opennms.netmgt.xml.eventconf.Varbind;

public class EventKey
extends LinkedHashMap
implements Serializable,
Comparable {
    private static final long serialVersionUID = 3498941419429346315L;
    public static final String TAG_UEI = "uei";
    public static final String TAG_SOURCE = "source";
    public static final String TAG_NODEID = "nodeid";
    public static final String TAG_HOST = "host";
    public static final String TAG_INTERFACE = "interface";
    public static final String TAG_SNMPHOST = "snmphost";
    public static final String TAG_SERVICE = "service";
    public static final String TAG_SNMP_EID = "id";
    public static final String TAG_SNMP_SPECIFIC = "specific";
    public static final String TAG_SNMP_GENERIC = "generic";
    public static final String TAG_SNMP_COMMUNITY = "community";
    private int m_hashCode;

    public EventKey() {
        this.m_hashCode = -1111;
    }

    public EventKey(int initCapacity) {
        super(initCapacity);
        this.m_hashCode = -1111;
    }

    public EventKey(int initCapacity, float loadFactor) {
        super(initCapacity, loadFactor);
        this.m_hashCode = -1111;
    }

    public EventKey(Map maskelements) {
        super(maskelements);
        this.m_hashCode = 1;
        this.evaluateHashCode();
    }

    public EventKey(Event event) {
        this.m_hashCode = 1;
        Mask mask = event.getMask();
        if (mask == null || mask != null && mask.getMaskelementCount() == 0) {
            String uei = event.getUei();
            if (uei != null) {
                this.put(TAG_UEI, new EventMaskValueList(uei));
            }
        } else {
            Enumeration en = mask.enumerateMaskelement();
            while (en.hasMoreElements()) {
                Maskelement maskelement = (Maskelement)en.nextElement();
                String name = maskelement.getMename();
                EventMaskValueList value = new EventMaskValueList();
                String[] mevalues = maskelement.getMevalue();
                for (int index = 0; index < mevalues.length; ++index) {
                    value.add(mevalues[index]);
                }
                this.put(name, value);
            }
            if (mask != null && mask.getVarbindCount() != 0) {
                Enumeration varenum = mask.enumerateVarbind();
                while (varenum.hasMoreElements()) {
                    Varbind varbind = (Varbind)varenum.nextElement();
                    EventMaskValueList vbvalues = new EventMaskValueList();
                    int vbint = varbind.getVbnumber();
                    String vbnumber = Integer.toString(vbint);
                    String[] vbvaluelist = varbind.getVbvalue();
                    for (int index = 0; index < vbvaluelist.length; ++index) {
                        vbvalues.add(vbvaluelist[index]);
                    }
                    this.put(vbnumber, vbvalues);
                }
            }
        }
    }

    public EventKey(org.opennms.netmgt.xml.event.Event event) {
        this.m_hashCode = 1;
        org.opennms.netmgt.xml.event.Mask mask = event.getMask();
        if (mask == null || mask != null && mask.getMaskelementCount() == 0) {
            String uei = event.getUei();
            if (uei != null) {
                this.put(TAG_UEI, uei);
            }
        } else {
            Enumeration en = mask.enumerateMaskelement();
            while (en.hasMoreElements()) {
                org.opennms.netmgt.xml.event.Maskelement maskelement = (org.opennms.netmgt.xml.event.Maskelement)en.nextElement();
                String name = maskelement.getMename();
                String value = EventKey.getMaskElementValue(event, name);
                this.put(name, value);
            }
        }
    }

    public void clear() {
        super.clear();
        this.evaluateHashCode();
    }

    public Object put(Object key, Object value) {
        Object ret = super.put(key, value);
        this.evaluateHashCode();
        return ret;
    }

    public void putAll(Map m) {
        super.putAll(m);
        this.evaluateHashCode();
    }

    public Object remove(Object key) {
        Object ret = super.remove(key);
        this.evaluateHashCode();
        return ret;
    }

    public void evaluateHashCode() {
        this.m_hashCode = 0;
        if (this.isEmpty()) {
            return;
        }
        for (String key : this.keySet()) {
            Object value = this.get(key);
            this.m_hashCode += key == null ? 0 : key.hashCode();
            this.m_hashCode += value == null ? 0 : value.hashCode();
        }
    }

    public int compareTo(Object o) {
        if (!(o instanceof EventKey)) {
            return -1;
        }
        EventKey obj = (EventKey)o;
        return this.hashCode() - obj.hashCode();
    }

    public int hashCode() {
        if (this.m_hashCode != -1111) {
            return this.m_hashCode;
        }
        return super.hashCode();
    }

    public String toString() {
        StringBuffer s = new StringBuffer("EventKey\n[\n\t");
        for (Map.Entry e : this.entrySet()) {
            String key = (String)e.getKey();
            Object value = e.getValue();
            s.append(key + "    = " + value.toString() + "\n\t");
        }
        s.append("\n]\n");
        return s.toString();
    }

    public static String getMaskElementValue(org.opennms.netmgt.xml.event.Event event, String mename) {
        String retParmVal = null;
        if (mename.equals(TAG_UEI)) {
            retParmVal = event.getUei();
        } else if (mename.equals(TAG_SOURCE)) {
            retParmVal = event.getSource();
        } else if (mename.equals(TAG_NODEID)) {
            retParmVal = Long.toString(event.getNodeid());
        } else if (mename.equals(TAG_HOST)) {
            retParmVal = event.getHost();
        } else if (mename.equals(TAG_INTERFACE)) {
            retParmVal = event.getInterface();
        } else if (mename.equals(TAG_SNMPHOST)) {
            retParmVal = event.getSnmphost();
        } else if (mename.equals(TAG_SERVICE)) {
            retParmVal = event.getService();
        } else if (mename.equals(TAG_SNMP_EID)) {
            if (event.getSnmp() != null) {
                retParmVal = event.getSnmp().getId();
            }
        } else if (mename.equals(TAG_SNMP_SPECIFIC)) {
            Snmp eventSnmpInfo = event.getSnmp();
            if (eventSnmpInfo != null && eventSnmpInfo.hasSpecific()) {
                retParmVal = Integer.toString(eventSnmpInfo.getSpecific());
            }
        } else if (mename.equals(TAG_SNMP_GENERIC)) {
            Snmp eventSnmpInfo = event.getSnmp();
            if (eventSnmpInfo != null && eventSnmpInfo.hasGeneric()) {
                retParmVal = Integer.toString(eventSnmpInfo.getGeneric());
            }
        } else if (mename.equals(TAG_SNMP_COMMUNITY)) {
            Snmp eventSnmpInfo = event.getSnmp();
            if (eventSnmpInfo != null) {
                retParmVal = eventSnmpInfo.getCommunity();
            }
        } else if (event.getParms() != null && event.getParms().getParmCount() > 0) {
            ArrayList<String> eventparms = new ArrayList<String>();
            Parms parms = event.getParms();
            Enumeration parmenum = parms.enumerateParm();
            while (parmenum.hasMoreElements()) {
                Parm evParm = (Parm)parmenum.nextElement();
                eventparms.add(EventUtil.getValueAsString(evParm.getValue()));
            }
            int vbnumber = Integer.parseInt(mename);
            if (vbnumber > 0 && vbnumber <= eventparms.size()) {
                retParmVal = (String)eventparms.get(vbnumber - 1);
            }
        }
        return retParmVal;
    }
}

