/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.datablock;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.datablock.EventKey;
import org.opennms.netmgt.eventd.datablock.EventMaskValueList;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Snmp;

public class EventConfData {
    private LinkedHashMap m_eventMap = new LinkedHashMap();
    private LinkedHashMap m_ueiToKeyListMap = new LinkedHashMap();

    private boolean eventMatchesKey(EventKey eventKey, org.opennms.netmgt.xml.event.Event event) {
        boolean maskMatch = true;
        Iterator keysetIter = eventKey.keySet().iterator();
        while (keysetIter.hasNext() && maskMatch) {
            String key = (String)keysetIter.next();
            List maskValues = (List)eventKey.get(key);
            String eventvalue = EventKey.getMaskElementValue(event, key);
            maskMatch = this.eventValuePassesMaskValue(eventvalue, maskValues);
            if (maskMatch) continue;
            return maskMatch;
        }
        return maskMatch;
    }

    protected boolean eventValuePassesMaskValue(String eventvalue, List maskValues) {
        boolean maskMatch = false;
        Iterator valiter = maskValues.iterator();
        while (valiter.hasNext() && !maskMatch) {
            String keyvalue = (String)valiter.next();
            if (keyvalue == null || eventvalue == null) continue;
            int len = keyvalue.length();
            if (keyvalue.equals(eventvalue)) {
                maskMatch = true;
                continue;
            }
            if (keyvalue.charAt(0) == '~') {
                if (!eventvalue.matches(keyvalue.substring(1))) continue;
                maskMatch = true;
                continue;
            }
            if (keyvalue.charAt(len - 1) != '%' || !eventvalue.startsWith(keyvalue.substring(0, len - 1))) continue;
            maskMatch = true;
        }
        return maskMatch;
    }

    private void updateUeiToKeyListMap(EventKey eventKey, Event event) {
        String eventUei = event.getUei();
        ArrayList<EventKey> keylist = (ArrayList<EventKey>)this.m_ueiToKeyListMap.get(eventUei);
        if (keylist == null) {
            keylist = new ArrayList<EventKey>();
            keylist.add(eventKey);
            this.m_ueiToKeyListMap.put(eventUei, keylist);
        } else if (!keylist.contains(eventKey)) {
            keylist.add(eventKey);
        }
    }

    public synchronized void put(Event event) {
        String eventEID;
        EventKey eventKey = new EventKey(event);
        this.m_eventMap.put(eventKey, event);
        this.updateUeiToKeyListMap(eventKey, event);
        Snmp eventSnmp = event.getSnmp();
        if (eventSnmp != null && (eventEID = eventSnmp.getId()) != null) {
            EventKey snmpKey = new EventKey();
            snmpKey.put("id", new EventMaskValueList(eventEID));
            this.m_eventMap.put(snmpKey, event);
            this.updateUeiToKeyListMap(snmpKey, event);
        }
    }

    public synchronized void put(EventKey key, Event event) {
        this.m_eventMap.put(key, event);
        this.updateUeiToKeyListMap(key, event);
    }

    public synchronized Event getEvent(org.opennms.netmgt.xml.event.Event event) {
        Event matchedEvent = null;
        if (matchedEvent == null) {
            Iterator entryIterator = this.m_eventMap.entrySet().iterator();
            while (entryIterator.hasNext() && matchedEvent == null) {
                Map.Entry entry = entryIterator.next();
                EventKey iterKey = (EventKey)entry.getKey();
                boolean keyMatchFound = this.eventMatchesKey(iterKey, event);
                if (!keyMatchFound) continue;
                Category log = ThreadCategory.getInstance(EventConfData.class);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Match found using key: " + iterKey.toString()));
                }
                matchedEvent = (Event)entry.getValue();
            }
        }
        return matchedEvent;
    }

    public synchronized Event getEventByUEI(String uei) {
        EventKey key = new EventKey();
        key.put("uei", new EventMaskValueList(uei));
        return (Event)this.m_eventMap.get(key);
    }

    public synchronized void clear() {
        this.m_eventMap.clear();
        this.m_ueiToKeyListMap.clear();
    }
}

