/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.udp;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.DatagramSocket;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.adaptors.EventHandler;
import org.opennms.netmgt.eventd.adaptors.EventHandlerMBeanProxy;
import org.opennms.netmgt.eventd.adaptors.EventReceiver;
import org.opennms.netmgt.eventd.adaptors.udp.UdpEventReceiverMBean;
import org.opennms.netmgt.eventd.adaptors.udp.UdpProcessor;
import org.opennms.netmgt.eventd.adaptors.udp.UdpReceiver;
import org.opennms.netmgt.eventd.adaptors.udp.UdpUuidSender;

public final class UdpEventReceiver
implements EventReceiver,
UdpEventReceiverMBean {
    private static final int UDP_PORT = 5817;
    private UdpReceiver m_receiver;
    private UdpProcessor m_processor;
    private UdpUuidSender m_output;
    private List m_eventsIn;
    private List m_eventUuidsOut;
    private List m_handlers;
    private volatile int m_status;
    private DatagramSocket m_dgSock = null;
    private int m_dgPort;
    private String m_logPrefix;

    public UdpEventReceiver() {
        this.m_dgPort = 5817;
        this.m_eventsIn = new LinkedList();
        this.m_eventUuidsOut = new LinkedList();
        this.m_handlers = new ArrayList(3);
        this.m_status = 0;
        this.m_dgSock = null;
        this.m_receiver = null;
        this.m_processor = null;
        this.m_output = null;
        this.m_logPrefix = null;
    }

    public UdpEventReceiver(int port) {
        this.m_dgPort = port;
        this.m_eventsIn = new LinkedList();
        this.m_eventUuidsOut = new LinkedList();
        this.m_handlers = new ArrayList(3);
        this.m_status = 0;
        this.m_dgSock = null;
        this.m_receiver = null;
        this.m_processor = null;
        this.m_output = null;
        this.m_logPrefix = null;
    }

    public synchronized void start() {
        if (this.m_status != 0) {
            throw new RuntimeException("The Fiber is in an incorrect state");
        }
        this.m_status = 1;
        try {
            this.m_dgSock = new DatagramSocket(this.m_dgPort);
            this.m_receiver = new UdpReceiver(this.m_dgSock, this.m_eventsIn);
            this.m_processor = new UdpProcessor(this.m_handlers, this.m_eventsIn, this.m_eventUuidsOut);
            this.m_output = new UdpUuidSender(this.m_dgSock, this.m_eventUuidsOut, this.m_handlers);
            if (this.m_logPrefix != null) {
                this.m_receiver.setLogPrefix(this.m_logPrefix);
                this.m_processor.setLogPrefix(this.m_logPrefix);
                this.m_output.setLogPrefix(this.m_logPrefix);
            }
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
        Thread rThread = new Thread((Runnable)this.m_receiver, "UDP Event Receiver[" + this.m_dgPort + "]");
        Thread pThread = new Thread((Runnable)this.m_processor, "UDP Event Processor[" + this.m_dgPort + "]");
        Thread oThread = new Thread((Runnable)this.m_output, "UDP UUID Sender[" + this.m_dgPort + "]");
        try {
            rThread.start();
            pThread.start();
            oThread.start();
        }
        catch (RuntimeException e) {
            rThread.interrupt();
            pThread.interrupt();
            oThread.interrupt();
            this.m_status = 4;
            throw e;
        }
        this.m_status = 2;
    }

    public synchronized void stop() {
        if (this.m_status == 4) {
            return;
        }
        if (this.m_status == 0) {
            this.m_status = 4;
            return;
        }
        this.m_status = 3;
        try {
            this.m_receiver.stop();
            this.m_processor.stop();
            this.m_output.stop();
        }
        catch (InterruptedException e) {
            Category log = ThreadCategory.getInstance(this.getClass());
            log.warn((Object)"The thread was interrupted while attempting to join sub-threads", (Throwable)e);
        }
        this.m_dgSock.close();
        this.m_status = 4;
    }

    public String getName() {
        return "Event UDP Receiver[" + this.m_dgPort + "]";
    }

    public int getStatus() {
        return this.m_status;
    }

    public void init() {
    }

    public void destroy() {
    }

    public void setPort(Integer port) {
        if (this.m_status == 1 || this.m_status == 2 || this.m_status == 3) {
            throw new IllegalStateException("The process is already running");
        }
        this.m_dgPort = port;
    }

    public Integer getPort() {
        return new Integer(this.m_dgPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventHandler(EventHandler handler) {
        List list = this.m_handlers;
        synchronized (list) {
            if (!this.m_handlers.contains(handler)) {
                this.m_handlers.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventHandler(EventHandler handler) {
        List list = this.m_handlers;
        synchronized (list) {
            this.m_handlers.remove(handler);
        }
    }

    public void addEventHandler(String name) throws MalformedObjectNameException, InstanceNotFoundException {
        this.addEventHandler(new EventHandlerMBeanProxy(new ObjectName(name)));
    }

    public void removeEventHandler(String name) throws MalformedObjectNameException, InstanceNotFoundException {
        this.removeEventHandler(new EventHandlerMBeanProxy(new ObjectName(name)));
    }

    public void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }
}

