/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.tcp;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;

final class TcpRecordHandler
implements Runnable {
    private volatile boolean m_stop = false;
    private Thread m_context = null;
    private List m_xchange;
    private Socket m_connection;
    private OutputStream m_out;
    private StateManager[] m_tokenizer;

    private void closeStream() throws IOException {
        if (this.m_out != null) {
            this.m_out.close();
        }
        this.m_out = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newStream() throws IOException {
        Category log = ThreadCategory.getInstance(this.getClass());
        boolean isTracing = log.isDebugEnabled();
        if (isTracing) {
            log.debug((Object)"Opening new PipedOutputStream and adding it to the queue");
        }
        PipedOutputStream pipeOut = new PipedOutputStream();
        try {
            PipedOutputStream pipedOutputStream = pipeOut;
            synchronized (pipedOutputStream) {
                List list = this.m_xchange;
                synchronized (list) {
                    this.m_xchange.add(pipeOut);
                    this.m_xchange.notify();
                }
                if (isTracing) {
                    log.debug((Object)"Added pipe to the xchange list");
                }
                pipeOut.wait();
                if (isTracing) {
                    log.debug((Object)"Pipe Signaled");
                }
            }
        }
        catch (InterruptedException e) {
            if (isTracing) {
                log.debug((Object)"An I/O error occured", (Throwable)e);
            }
            throw new IOException("The thread was interrupted");
        }
        if (isTracing) {
            log.debug((Object)"PipedOutputStream connected");
        }
        this.m_out = pipeOut;
    }

    private void forward(char ch) throws IOException {
        try {
            if (this.m_out != null) {
                this.m_out.write(ch);
            }
        }
        catch (IOException e) {
            Category log = ThreadCategory.getInstance(this.getClass());
            if (log.isDebugEnabled()) {
                log.debug((Object)"An I/O error occured", (Throwable)e);
            }
            throw e;
        }
    }

    TcpRecordHandler(Socket s, List xchange) {
        this.m_xchange = xchange;
        this.m_connection = s;
        this.m_tokenizer = new StateManager[]{new StateManager(0, this){

            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == '<') {
                    return 1;
                }
                return this.m_level;
            }
        }, new StateManager(1, this){

            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == '/') {
                    return 2;
                }
                return 0;
            }
        }, new StateManager(2, this){

            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == 'l') {
                    return 5;
                }
                if (Character.isLetterOrDigit(ch)) {
                    return 3;
                }
                return 0;
            }
        }, new StateManager(3, this){

            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == ':') {
                    return 4;
                }
                if (Character.isLetterOrDigit(ch)) {
                    return this.m_level;
                }
                return 0;
            }
        }, new StateManager(4, this){

            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == 'l') {
                    return 5;
                }
                return 0;
            }
        }, new StateManager(5, this){

            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == 'o') {
                    return 6;
                }
                return 0;
            }
        }, new StateManager(6, this){

            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == 'g') {
                    return 7;
                }
                return 0;
            }
        }, new StateManager(7, this){

            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == '>') {
                    this.m_handler.closeStream();
                    return 8;
                }
                return 0;
            }
        }, new StateManager(8, this){

            int next(char ch) throws IOException {
                if (ch == '<') {
                    this.onTransition(ch);
                    return 1;
                }
                return this.m_level;
            }

            void onTransition(char ch) throws IOException {
                this.m_handler.newStream();
                super.onTransition(ch);
            }
        }};
    }

    boolean isAlive() {
        boolean rc = false;
        if (this.m_context != null) {
            rc = this.m_context.isAlive();
        }
        return rc;
    }

    void stop() throws InterruptedException {
        this.m_stop = true;
        if (this.m_context != null) {
            Category log = ThreadCategory.getInstance(this.getClass());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Interrupting thread " + this.m_context.getName()));
            }
            this.m_context.interrupt();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Joining Thread " + this.m_context.getName()));
            }
            this.m_context.join();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Thread " + this.m_context.getName() + " Joined"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Category log;
        block28: {
            Thread thread = this.m_context = Thread.currentThread();
            synchronized (thread) {
                this.m_context.notifyAll();
            }
            log = ThreadCategory.getInstance(this.getClass());
            if (this.m_stop) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Stop flag set before thread startup, thread exiting");
                }
                return;
            }
            if (log.isDebugEnabled()) {
                InetAddress sender = this.m_connection.getInetAddress();
                log.debug((Object)("Thread started, remote is " + sender.getHostAddress()));
            }
            BufferedInputStream socketIn = null;
            try {
                this.m_connection.setSoTimeout(500);
                socketIn = new BufferedInputStream(this.m_connection.getInputStream());
            }
            catch (IOException e) {
                if (!this.m_stop) {
                    log.warn((Object)"An I/O Exception occured", (Throwable)e);
                }
                this.m_xchange.add(e);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Thread exiting due to socket exception, stop flag = " + this.m_stop));
                }
                return;
            }
            int level = 8;
            int ch = 0;
            boolean moreInput = true;
            while (moreInput) {
                block27: {
                    if (Thread.interrupted()) {
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)"Thread Interrupted");
                        break;
                    }
                    try {
                        ch = ((InputStream)socketIn).read();
                        if (ch == -1) {
                            moreInput = false;
                        }
                        break block27;
                    }
                    catch (InterruptedIOException e) {
                    }
                    catch (EOFException e) {
                        this.m_xchange.add(e);
                        moreInput = false;
                    }
                    catch (IOException e) {
                        this.m_xchange.add(e);
                        if (!this.m_stop) {
                            log.warn((Object)"An I/O error occured reading from the remote host", (Throwable)e);
                        }
                        moreInput = false;
                    }
                    continue;
                }
                try {
                    level = this.m_tokenizer[level].next((char)ch);
                }
                catch (IOException e) {
                    if (!this.m_stop) {
                        log.warn((Object)"An I/O error occured writing to the processor stream", (Throwable)e);
                        log.warn((Object)"Discarding the remainder of the event contents");
                        try {
                            this.closeStream();
                        }
                        catch (IOException e2) {}
                        continue;
                    }
                    this.m_xchange.add(e);
                    moreInput = false;
                }
            }
            try {
                if (this.m_out != null) {
                    this.m_out.close();
                }
            }
            catch (IOException e) {
                if (this.m_stop) break block28;
                log.warn((Object)"An I/O Error occured closing the processor stream", (Throwable)e);
            }
        }
        this.m_xchange.add(new EOFException("No More Input"));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Thread Terminated");
        }
    }

    private static class StateManager {
        protected int m_level;
        protected TcpRecordHandler m_handler;

        StateManager(int level, TcpRecordHandler handler) {
            this.m_level = level;
            this.m_handler = handler;
        }

        int getLevel() {
            return this.m_level;
        }

        int next(char ch) throws IOException {
            this.onTransition(ch);
            return this.m_level;
        }

        void onTransition(char ch) throws IOException {
            this.m_handler.forward(ch);
        }
    }
}

