/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.sql.SQLException;
import java.util.Enumeration;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.AlarmWriter;
import org.opennms.netmgt.eventd.EventExpander;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.eventd.EventWriter;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.event.Parm;

final class EventHandler
implements Runnable {
    private Log m_eventLog;
    private String m_getNextEventIdStr;
    private String m_getNextAlarmIdStr;

    public EventHandler(Log eventLog, String getNextEventId, String getNextAlarmIdStr) {
        this.m_eventLog = eventLog;
        this.m_getNextEventIdStr = getNextEventId;
        this.m_getNextAlarmIdStr = getNextAlarmIdStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.m_eventLog == null) {
            return;
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        Events events = this.m_eventLog.getEvents();
        if (events == null || events.getEventCount() <= 0) {
            return;
        }
        EventWriter eventWriter = null;
        AlarmWriter alarmWriter = null;
        try {
            try {
                eventWriter = new EventWriter(this.m_getNextEventIdStr);
                alarmWriter = new AlarmWriter(this.m_getNextAlarmIdStr);
            }
            catch (Throwable t) {
                log.warn((Object)"Exception creating EventWriter", t);
                log.warn((Object)"Event(s) CANNOT be inserted into the database");
                if (eventWriter != null) {
                    eventWriter.close();
                }
                if (alarmWriter != null) {
                    alarmWriter.close();
                }
                return;
            }
            Enumeration en = events.enumerateEvent();
            while (en.hasMoreElements()) {
                Event event = (Event)en.nextElement();
                if (log.isDebugEnabled()) {
                    Parm[] parms;
                    String uuid = event.getUuid();
                    log.debug((Object)"Event {");
                    log.debug((Object)("  uuid  = " + (uuid != null && uuid.length() > 0 ? uuid : "<not-set>")));
                    log.debug((Object)("  uei   = " + event.getUei()));
                    log.debug((Object)("  src   = " + event.getSource()));
                    log.debug((Object)("  iface = " + event.getInterface()));
                    log.debug((Object)("  time  = " + event.getTime()));
                    Parm[] parmArray = parms = event.getParms() == null ? null : event.getParms().getParm();
                    if (parms != null) {
                        log.debug((Object)"  parms {");
                        for (int x = 0; x < parms.length; ++x) {
                            if (parms[x].getParmName() == null || parms[x].getValue().getContent() == null) continue;
                            log.debug((Object)("    (" + parms[x].getParmName().trim() + ", " + parms[x].getValue().getContent().trim() + ")"));
                        }
                        log.debug((Object)"  }");
                    }
                    log.debug((Object)"}");
                }
                EventExpander.expandEvent(event);
                try {
                    eventWriter.persistEvent(this.m_eventLog.getHeader(), event);
                    EventIpcManagerFactory.getIpcManager().broadcastNow(event);
                    alarmWriter.persistAlarm(this.m_eventLog.getHeader(), event);
                }
                catch (SQLException sqle) {
                    log.warn((Object)"Unable to add event to database", (Throwable)sqle);
                }
                catch (Throwable t) {
                    log.warn((Object)"Unknown exception processing event", t);
                }
            }
        }
        finally {
            if (eventWriter != null) {
                eventWriter.close();
            }
            if (alarmWriter != null) {
                alarmWriter.close();
            }
        }
    }
}

