/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.util.Enumeration;
import org.opennms.netmgt.eventd.EventConfigurationManager;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.xml.event.AlarmData;
import org.opennms.netmgt.xml.event.Autoacknowledge;
import org.opennms.netmgt.xml.event.Correlation;
import org.opennms.netmgt.xml.event.Forward;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.eventconf.Autoaction;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Logmsg;
import org.opennms.netmgt.xml.eventconf.Mask;
import org.opennms.netmgt.xml.eventconf.Maskelement;
import org.opennms.netmgt.xml.eventconf.Operaction;
import org.opennms.netmgt.xml.eventconf.Script;
import org.opennms.netmgt.xml.eventconf.Tticket;

public final class EventExpander {
    private static final String DEFAULT_EVENT_UEI = "uei.opennms.org/default/event";

    private EventExpander() {
    }

    private static org.opennms.netmgt.xml.event.Mask transform(Mask src) {
        org.opennms.netmgt.xml.event.Mask dest = new org.opennms.netmgt.xml.event.Mask();
        Enumeration en = src.enumerateMaskelement();
        while (en.hasMoreElements()) {
            Maskelement confme = (Maskelement)en.nextElement();
            org.opennms.netmgt.xml.event.Maskelement me = new org.opennms.netmgt.xml.event.Maskelement();
            me.setMename(confme.getMename());
            String[] confmevalues = confme.getMevalue();
            for (int index = 0; index < confmevalues.length; ++index) {
                me.addMevalue(confmevalues[index]);
            }
            dest.addMaskelement(me);
        }
        return dest;
    }

    private static Snmp transform(org.opennms.netmgt.xml.eventconf.Snmp src) {
        Snmp dest = new Snmp();
        dest.setId(src.getId());
        dest.setIdtext(src.getIdtext());
        dest.setVersion(src.getVersion());
        dest.setCommunity(src.getCommunity());
        if (src.hasGeneric()) {
            dest.setGeneric(src.getGeneric());
        }
        if (src.hasSpecific()) {
            dest.setSpecific(src.getSpecific());
        }
        return dest;
    }

    private static org.opennms.netmgt.xml.event.Logmsg transform(Logmsg src) {
        org.opennms.netmgt.xml.event.Logmsg dest = new org.opennms.netmgt.xml.event.Logmsg();
        dest.setContent(src.getContent());
        dest.setDest(src.getDest());
        return dest;
    }

    private static Correlation transform(org.opennms.netmgt.xml.eventconf.Correlation src) {
        Correlation dest = new Correlation();
        dest.setCuei(src.getCuei());
        dest.setCmin(src.getCmin());
        dest.setCmax(src.getCmax());
        dest.setCtime(src.getCtime());
        dest.setState(src.getState());
        dest.setPath(src.getPath());
        return dest;
    }

    private static org.opennms.netmgt.xml.event.Autoaction transform(Autoaction src) {
        org.opennms.netmgt.xml.event.Autoaction dest = new org.opennms.netmgt.xml.event.Autoaction();
        dest.setContent(src.getContent());
        dest.setState(src.getState());
        return dest;
    }

    private static org.opennms.netmgt.xml.event.Operaction transform(Operaction src) {
        org.opennms.netmgt.xml.event.Operaction dest = new org.opennms.netmgt.xml.event.Operaction();
        dest.setContent(src.getContent());
        dest.setState(src.getState());
        dest.setMenutext(src.getMenutext());
        return dest;
    }

    private static Autoacknowledge transform(org.opennms.netmgt.xml.eventconf.Autoacknowledge src) {
        Autoacknowledge dest = new Autoacknowledge();
        dest.setContent(src.getContent());
        dest.setState(src.getState());
        return dest;
    }

    private static org.opennms.netmgt.xml.event.Tticket transform(Tticket src) {
        org.opennms.netmgt.xml.event.Tticket dest = new org.opennms.netmgt.xml.event.Tticket();
        dest.setContent(src.getContent());
        dest.setState(src.getState());
        return dest;
    }

    private static Forward transform(org.opennms.netmgt.xml.eventconf.Forward src) {
        Forward dest = new Forward();
        dest.setContent(src.getContent());
        dest.setState(src.getState());
        dest.setMechanism(src.getMechanism());
        return dest;
    }

    private static org.opennms.netmgt.xml.event.Script transform(Script src) {
        org.opennms.netmgt.xml.event.Script dest = new org.opennms.netmgt.xml.event.Script();
        dest.setContent(src.getContent());
        dest.setLanguage(src.getLanguage());
        return dest;
    }

    private static Event lookup(org.opennms.netmgt.xml.event.Event event) {
        if (event == null) {
            throw new NullPointerException("Invalid argument, the event parameter must not be null");
        }
        Event eConf = null;
        eConf = EventConfigurationManager.get(event);
        if (eConf == null) {
            eConf = EventConfigurationManager.getByUei(DEFAULT_EVENT_UEI);
        }
        return eConf;
    }

    private static void expandParms(org.opennms.netmgt.xml.event.Logmsg logmsg, org.opennms.netmgt.xml.event.Event event) {
        String strRet = EventUtil.expandParms(logmsg.getContent(), event);
        if (strRet != null) {
            logmsg.setContent(strRet);
        }
    }

    private static void expandParms(org.opennms.netmgt.xml.event.Autoaction[] autoactions, org.opennms.netmgt.xml.event.Event event) {
        boolean expanded = false;
        for (int index = 0; index < autoactions.length; ++index) {
            org.opennms.netmgt.xml.event.Autoaction action = autoactions[index];
            String strRet = EventUtil.expandParms(action.getContent(), event);
            if (strRet == null) continue;
            action.setContent(strRet);
            expanded = true;
        }
        if (expanded) {
            event.setAutoaction(autoactions);
        }
    }

    private static void expandParms(org.opennms.netmgt.xml.event.Operaction[] operactions, org.opennms.netmgt.xml.event.Event event) {
        boolean expanded = false;
        for (int index = 0; index < operactions.length; ++index) {
            org.opennms.netmgt.xml.event.Operaction action = operactions[index];
            String strRet = EventUtil.expandParms(action.getContent(), event);
            if (strRet == null) continue;
            action.setContent(strRet);
            expanded = true;
        }
        if (expanded) {
            event.setOperaction(operactions);
        }
    }

    private static void expandParms(org.opennms.netmgt.xml.event.Tticket tticket, org.opennms.netmgt.xml.event.Event event) {
        String strRet = EventUtil.expandParms(tticket.getContent(), event);
        if (strRet != null) {
            tticket.setContent(strRet);
        }
    }

    private static void expandParms(org.opennms.netmgt.xml.event.Event event) {
        String strRet = null;
        if (event.getDescr() != null && (strRet = EventUtil.expandParms(event.getDescr(), event)) != null) {
            event.setDescr(strRet);
            strRet = null;
        }
        if (event.getLogmsg() != null) {
            EventExpander.expandParms(event.getLogmsg(), event);
        }
        if (event.getOperinstruct() != null && (strRet = EventUtil.expandParms(event.getOperinstruct(), event)) != null) {
            event.setOperinstruct(strRet);
            strRet = null;
        }
        if (event.getAutoaction() != null) {
            EventExpander.expandParms(event.getAutoaction(), event);
        }
        if (event.getOperaction() != null) {
            EventExpander.expandParms(event.getOperaction(), event);
        }
        if (event.getTticket() != null) {
            EventExpander.expandParms(event.getTticket(), event);
        }
        if (event.getAlarmData() != null) {
            strRet = EventUtil.expandParms(event.getAlarmData().getReductionKey(), event);
            if (strRet != null) {
                event.getAlarmData().setReductionKey(strRet);
            }
            strRet = null;
            strRet = EventUtil.expandParms(event.getAlarmData().getClearKey(), event);
            if (strRet != null) {
                event.getAlarmData().setClearKey(strRet);
            }
        }
    }

    public static synchronized void expandEvent(org.opennms.netmgt.xml.event.Event e) {
        Event econf = EventExpander.lookup(e);
        if (econf != null) {
            Autoaction src;
            Enumeration eter;
            if (EventConfigurationManager.isSecureTag("mask")) {
                e.setMask(null);
            }
            if (e.getMask() == null && econf.getMask() != null) {
                e.setMask(EventExpander.transform(econf.getMask()));
            }
            if (e.getUei() == null) {
                e.setUei(econf.getUei());
            }
            if (e.getSnmp() == null && econf.getSnmp() != null) {
                e.setSnmp(EventExpander.transform(econf.getSnmp()));
            }
            if (EventConfigurationManager.isSecureTag("descr")) {
                e.setDescr(null);
            }
            if (e.getDescr() == null && econf.getDescr() != null) {
                e.setDescr(econf.getDescr());
            }
            if (EventConfigurationManager.isSecureTag("logmsg")) {
                e.setLogmsg(null);
            }
            if (e.getLogmsg() == null && econf.getLogmsg() != null) {
                e.setLogmsg(EventExpander.transform(econf.getLogmsg()));
            }
            if (EventConfigurationManager.isSecureTag("severity")) {
                e.setSeverity(null);
            }
            if (e.getSeverity() == null && econf.getSeverity() != null) {
                e.setSeverity(econf.getSeverity());
            }
            if (EventConfigurationManager.isSecureTag("correlation")) {
                e.setCorrelation(null);
            }
            if (e.getCorrelation() == null && econf.getCorrelation() != null) {
                e.setCorrelation(EventExpander.transform(econf.getCorrelation()));
            }
            if (EventConfigurationManager.isSecureTag("operinstruct")) {
                e.setOperinstruct(null);
            }
            if (e.getOperinstruct() == null && econf.getOperinstruct() != null) {
                e.setOperinstruct(econf.getOperinstruct());
            }
            if (EventConfigurationManager.isSecureTag("autoaction")) {
                e.clearAutoaction();
            }
            if (e.getAutoactionCount() == 0 && econf.getAutoactionCount() > 0) {
                eter = econf.enumerateAutoaction();
                while (eter.hasMoreElements()) {
                    src = (Autoaction)eter.nextElement();
                    e.addAutoaction(EventExpander.transform(src));
                }
            }
            if (EventConfigurationManager.isSecureTag("operaction")) {
                e.clearOperaction();
            }
            if (e.getOperactionCount() == 0 && econf.getOperactionCount() > 0) {
                eter = econf.enumerateOperaction();
                while (eter.hasMoreElements()) {
                    src = (Operaction)eter.nextElement();
                    e.addOperaction(EventExpander.transform((Operaction)src));
                }
            }
            if (EventConfigurationManager.isSecureTag("autoacknowledge")) {
                e.setAutoacknowledge(null);
            }
            if (e.getAutoacknowledge() == null && econf.getAutoacknowledge() != null) {
                e.setAutoacknowledge(EventExpander.transform(econf.getAutoacknowledge()));
            }
            if (EventConfigurationManager.isSecureTag("loggroup")) {
                e.clearLoggroup();
            }
            if (e.getLoggroupCount() == 0 && econf.getLoggroupCount() > 0) {
                e.setLoggroup(econf.getLoggroup());
            }
            if (EventConfigurationManager.isSecureTag("tticket")) {
                e.setTticket(null);
            }
            if (e.getTticket() == null && econf.getTticket() != null) {
                e.setTticket(EventExpander.transform(econf.getTticket()));
            }
            if (EventConfigurationManager.isSecureTag("forward")) {
                e.clearForward();
            }
            if (e.getForwardCount() == 0 && econf.getForwardCount() > 0) {
                eter = econf.enumerateForward();
                while (eter.hasMoreElements()) {
                    src = (org.opennms.netmgt.xml.eventconf.Forward)eter.nextElement();
                    e.addForward(EventExpander.transform((org.opennms.netmgt.xml.eventconf.Forward)src));
                }
            }
            if (EventConfigurationManager.isSecureTag("script")) {
                e.clearScript();
            }
            if (e.getScriptCount() == 0 && econf.getScriptCount() > 0) {
                eter = econf.enumerateScript();
                while (eter.hasMoreElements()) {
                    src = (Script)eter.nextElement();
                    e.addScript(EventExpander.transform((Script)src));
                }
            }
            if (EventConfigurationManager.isSecureTag("mouseovertext")) {
                e.setMouseovertext(null);
            }
            if (e.getMouseovertext() == null && econf.getMouseovertext() != null) {
                e.setMouseovertext(econf.getMouseovertext());
            }
            if (EventConfigurationManager.isSecureTag("reduction-key") && EventConfigurationManager.isSecureTag("alarm-type") && EventConfigurationManager.isSecureTag("clear-uei")) {
                e.setAlarmData(null);
            }
            if (e.getAlarmData() == null && econf.getAlarmData() != null) {
                AlarmData alarmData = new AlarmData();
                alarmData.setAlarmType(econf.getAlarmData().getAlarmType());
                alarmData.setReductionKey(econf.getAlarmData().getReductionKey());
                alarmData.setClearUei(econf.getAlarmData().getClearUei());
                alarmData.setAutoClean(econf.getAlarmData().getAutoClean());
                alarmData.setX733AlarmType(econf.getAlarmData().getX733AlarmType());
                alarmData.setX733ProbableCause(econf.getAlarmData().getX733ProbableCause());
                alarmData.setClearKey(econf.getAlarmData().getClearKey());
                e.setAlarmData(alarmData);
            }
        }
        EventExpander.expandParms(e);
    }
}

