/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import org.apache.log4j.Category;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.ping.Reply;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

final class SuspectEventGenerator
implements Runnable,
Fiber {
    static final String EVENT_SOURCE_VALUE = "OpenNMS.Discovery";
    private FifoQueue m_replies;
    private long m_ttl;
    private int m_status;
    private String m_name = "Discovery:SuspectEventGenerator";
    private Thread m_worker;

    SuspectEventGenerator(FifoQueue replyQ, long ttl) {
        this.m_replies = replyQ;
        this.m_ttl = ttl;
        this.m_status = 0;
        this.m_worker = null;
    }

    public synchronized void start() {
        if (this.m_worker != null) {
            throw new IllegalStateException("The fiber has already been start or has already run");
        }
        this.m_status = 1;
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.start();
    }

    public synchronized void stop() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        if (this.m_status != 4) {
            this.m_status = 3;
            this.m_worker.interrupt();
        }
    }

    public synchronized int getStatus() {
        if (this.m_worker != null && !this.m_worker.isAlive()) {
            this.m_status = 4;
        }
        return this.m_status;
    }

    public String getName() {
        return this.m_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Category log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)"run: Thread Started");
        }
        SuspectEventGenerator suspectEventGenerator = this;
        synchronized (suspectEventGenerator) {
            this.m_status = 2;
        }
        while (true) {
            Reply r;
            block21: {
                suspectEventGenerator = this;
                synchronized (suspectEventGenerator) {
                    if (this.m_status != 2) {
                        break;
                    }
                }
                r = null;
                try {
                    r = (Reply)this.m_replies.remove();
                    if (!log.isDebugEnabled()) break block21;
                    log.debug((Object)("run: received next reply, " + this.m_replies.size() + " left in queue"));
                }
                catch (InterruptedException ex) {
                    log.debug((Object)"run: thread interrupted", (Throwable)ex);
                    break;
                }
                catch (FifoQueueException ex) {
                    log.info((Object)"run: queue exception", (Throwable)ex);
                    break;
                }
                catch (ClassCastException ex) {
                    log.warn((Object)"run: Invalid class type found in queue", (Throwable)ex);
                    continue;
                }
            }
            if (r == null) continue;
            Event event = new Event();
            event.setSource(EVENT_SOURCE_VALUE);
            event.setUei("uei.opennms.org/internal/discovery/newSuspect");
            event.setInterface(r.getAddress().getHostAddress());
            try {
                event.setHost(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException uhE) {
                event.setHost("unresolved.host");
                log.warn((Object)"Failed to resolve local hostname", (Throwable)uhE);
            }
            event.setTime(EventConstants.formatToString(new Date()));
            Parms parms = new Parms();
            Parm rttParm = new Parm();
            rttParm.setParmName("RTT");
            Value v = new Value();
            v.setType("int");
            v.setContent(Long.toString(r.getPacket().getReceivedTime() - r.getPacket().getSentTime()));
            rttParm.setValue(v);
            parms.addParm(rttParm);
            event.setParms(parms);
            try {
                EventIpcManagerFactory.getIpcManager().sendNow(event);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Sent event: uei.opennms.org/internal/discovery/newSuspect");
            }
            catch (Throwable t) {
                log.warn((Object)"run: unexpected throwable exception caught during send to middleware", t);
            }
        }
        suspectEventGenerator = this;
        synchronized (suspectEventGenerator) {
            this.m_status = 4;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"run: Thread exiting");
        }
    }
}

