/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import org.apache.log4j.Category;
import org.opennms.core.concurrent.QuantumSemaphore;
import org.opennms.core.fiber.ExtendedStatusFiber;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueImpl;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.discovery.DiscoveredIPMgr;
import org.opennms.netmgt.discovery.IPPollAddress;
import org.opennms.netmgt.ping.Packet;
import org.opennms.netmgt.ping.Reply;
import org.opennms.netmgt.ping.ReplyReceiver;
import org.opennms.protocols.icmp.IcmpSocket;

final class PingManager
implements Runnable,
PausableFiber {
    private static final long TID_CONST_KEY = 76806031479341056L;
    private Pinger[] m_pingers;
    private QuantumSemaphore m_semaphore;
    private IcmpSocket m_socket;
    private FifoQueue m_replyQ;
    private FifoQueue m_discoveredQ;
    private ReplyReceiver m_icmpReceiver;
    private int m_status;
    private short m_filterId;
    private Thread m_worker;

    protected PingManager(FifoQueue addressQ, FifoQueue discoveredQ, short filterId, int threads, int pktsPerSecond) throws IOException {
        Category log = ThreadCategory.getInstance(this.getClass());
        if (threads < 1) {
            log.error((Object)"The number of PingManager threads must be greater than zero");
            throw new IllegalArgumentException("The number of threads must be greater than zero");
        }
        if (pktsPerSecond < 1) {
            log.error((Object)"The number of PingManager packets per second must be greater than zero");
            throw new IllegalArgumentException("The number of packets per second must be greater than zero");
        }
        this.m_filterId = filterId;
        try {
            this.m_socket = new IcmpSocket();
        }
        catch (NoClassDefFoundError e) {
            log.error((Object)"NoClassDefFoundError while creating an IcmpSocket.  Most likely failed to load libjicmp.so.", (Throwable)e);
            throw e;
        }
        catch (Throwable t) {
            log.error((Object)"Throwable received while creating an IcmpSocket", t);
            throw new UndeclaredThrowableException(t, t.getMessage());
        }
        this.m_semaphore = new QuantumSemaphore((long)pktsPerSecond, 1000L);
        this.m_replyQ = new FifoQueueImpl();
        this.m_discoveredQ = discoveredQ;
        this.m_pingers = new Pinger[threads];
        for (int x = 0; x < this.m_pingers.length; ++x) {
            this.m_pingers[x] = new Pinger(this.m_socket, this.m_semaphore, addressQ, filterId, 0x110DEADBEEF0000L | (long)x);
        }
        this.m_icmpReceiver = new ReplyReceiver(this.m_socket, this.m_replyQ, filterId);
    }

    public synchronized void start() {
        if (this.m_worker != null) {
            throw new IllegalStateException("The fiber is already running or has already run");
        }
        this.m_status = 1;
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.setDaemon(true);
        this.m_worker.start();
        this.m_icmpReceiver.start();
        for (int x = 0; x < this.m_pingers.length; ++x) {
            this.m_pingers[x].start();
        }
    }

    public synchronized void stop() {
        for (int x = 0; x < this.m_pingers.length; ++x) {
            try {
                this.m_pingers[x].stop();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.m_icmpReceiver.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber was never started");
        }
        if (this.m_worker.isAlive()) {
            if (this.m_status != 4) {
                this.m_status = 3;
            }
            this.m_worker.interrupt();
        } else if (this.m_status != 4) {
            this.m_status = 4;
        }
        this.m_socket.close();
    }

    public synchronized void pause() {
        if (this.m_worker == null || !this.m_worker.isAlive()) {
            throw new IllegalStateException("The fiber is not running");
        }
        if (this.m_status == 2) {
            for (int x = 0; x < this.m_pingers.length; ++x) {
                this.m_pingers[x].pause();
            }
            this.m_icmpReceiver.pause();
            this.m_status = 6;
        }
    }

    public synchronized void resume() {
        if (this.m_worker == null || !this.m_worker.isAlive()) {
            throw new IllegalStateException("The fiber is not running");
        }
        if (this.m_status == 6) {
            this.m_icmpReceiver.resume();
            for (int x = 0; x < this.m_pingers.length; ++x) {
                this.m_pingers[x].resume();
            }
            this.m_status = 2;
        }
        this.notifyAll();
    }

    public synchronized int getStatus() {
        if (this.m_worker != null && !this.m_worker.isAlive()) {
            this.m_status = 4;
        }
        return this.m_status;
    }

    public String getName() {
        return "PingManager-" + this.m_filterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block31: {
            Category log = ThreadCategory.getInstance(this.getClass());
            log.info((Object)"Starting the PingManager");
            PingManager pingManager = this;
            synchronized (pingManager) {
                this.m_status = 2;
            }
            try {
                while (true) {
                    try {
                        while (true) {
                            pingManager = this;
                            synchronized (pingManager) {
                                if (this.m_status == 6) {
                                    this.wait();
                                    continue;
                                }
                                if (this.m_status == 3) {
                                    break block31;
                                }
                            }
                            Reply r = (Reply)this.m_replyQ.remove();
                            if (r == null || !r.isEchoReply() || r.getIdentity() != this.m_filterId || (r.getPacket().getTID() & 0x110DEADBEEF0000L) != 76806031479341056L) continue;
                            boolean doAdd = false;
                            int ndx = (int)(r.getPacket().getTID() & 0xFEEF21524110FFFFL);
                            if (0 <= ndx && ndx < this.m_pingers.length) {
                                Pinger pinger = this.m_pingers[ndx];
                                synchronized (pinger) {
                                    if (this.m_pingers[ndx].isPinging(r.getAddress())) {
                                        this.m_pingers[ndx].signal();
                                        doAdd = true;
                                    }
                                }
                            }
                            if (!doAdd) continue;
                            this.m_discoveredQ.add((Object)r);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Unexpected Exception occurred in the PingManager.", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)"Unexpected Exception occurred in the PingManager.", (Throwable)e);
            }
            finally {
                PingManager pingManager2 = this;
                synchronized (pingManager2) {
                    this.m_status = 4;
                }
            }
        }
    }

    static final class Pinger
    implements Runnable,
    PausableFiber,
    ExtendedStatusFiber {
        private final QuantumSemaphore m_semaphore;
        private final IcmpSocket m_socket;
        private final FifoQueue m_addressQ;
        private final short m_icmpId;
        private final long m_fiberId;
        private int m_status;
        private int m_xstatus;
        private InetAddress m_target;
        private boolean m_signaled;
        private Thread m_worker;
        static final int IDLE = 0;
        static final int POLLING = 1;

        private boolean poll(IPPollAddress addr) throws IOException, InterruptedException {
            Category log = ThreadCategory.getInstance(this.getClass());
            for (int tries = 0; !this.m_signaled && tries <= addr.getRetries(); ++tries) {
                long wtime;
                Packet pingPkt = new Packet(this.m_fiberId);
                pingPkt.setIdentity(this.m_icmpId);
                pingPkt.computeChecksum();
                byte[] buf = pingPkt.toBytes();
                DatagramPacket sendPkt = new DatagramPacket(buf, buf.length, addr.getAddress(), 0);
                buf = null;
                pingPkt = null;
                boolean x = this.m_semaphore.acquire();
                long expire = System.currentTimeMillis() + addr.getTimeout();
                while (this.m_status != 3 && !this.m_signaled && (wtime = expire - System.currentTimeMillis()) > 0L) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("poll: try#: " + tries + " - sending ping to address " + addr.getAddress().getHostAddress()));
                    }
                    this.m_socket.send(sendPkt);
                    this.wait(wtime);
                }
            }
            return this.m_signaled;
        }

        Pinger(IcmpSocket socket, QuantumSemaphore semaphore, FifoQueue addrQ, short filterId, long tid) {
            this.m_socket = socket;
            this.m_semaphore = semaphore;
            this.m_addressQ = addrQ;
            this.m_icmpId = filterId;
            this.m_fiberId = tid;
            this.m_status = 0;
            this.m_xstatus = 0;
            this.m_signaled = false;
            this.m_target = null;
            this.m_worker = null;
        }

        public synchronized void start() {
            if (this.m_worker != null) {
                throw new IllegalStateException("The fiber is running or has already run");
            }
            this.m_worker = new Thread((Runnable)this, this.getName());
            this.m_worker.start();
            this.m_status = 1;
        }

        public synchronized void stop() {
            if (this.m_worker == null) {
                throw new IllegalStateException("The fiber has never run");
            }
            this.m_status = 3;
            this.m_worker.interrupt();
            this.notifyAll();
        }

        public synchronized void pause() {
            if (this.m_worker == null || !this.m_worker.isAlive()) {
                throw new IllegalStateException("The fiber is not running");
            }
            this.m_status = 6;
            this.notifyAll();
        }

        public synchronized void resume() {
            if (this.m_worker == null || !this.m_worker.isAlive()) {
                throw new IllegalStateException("The fiber is not running");
            }
            this.m_status = 2;
            this.notifyAll();
        }

        public String getName() {
            return "PingManager.Pinger-" + (this.m_fiberId ^ 0x110DEADBEEF0000L);
        }

        public synchronized int getStatus() {
            if (this.m_worker != null && !this.m_worker.isAlive()) {
                this.m_status = 4;
            }
            return this.m_status;
        }

        public synchronized int getExtendedStatus() {
            return this.m_xstatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block26: {
                Category log = ThreadCategory.getInstance(this.getClass());
                Pinger pinger = this;
                synchronized (pinger) {
                    this.m_status = 2;
                    this.m_xstatus = 0;
                }
                while (true) {
                    try {
                        boolean isKnown;
                        IPPollAddress addr;
                        do {
                            pinger = this;
                            synchronized (pinger) {
                                while (this.m_status == 6) {
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)"run: fiber paused, waiting");
                                    }
                                    this.wait();
                                    if (!log.isDebugEnabled()) continue;
                                    log.debug((Object)"run: fiber wait is over");
                                }
                                if (this.m_status != 2) {
                                    break block26;
                                }
                            }
                            addr = (IPPollAddress)this.m_addressQ.remove();
                            isKnown = false;
                            if (addr == null) continue;
                            isKnown = DiscoveredIPMgr.isDiscoveredOrExcluded(addr.getAddress());
                        } while (addr == null || isKnown);
                        Pinger pinger2 = this;
                        synchronized (pinger2) {
                            block27: {
                                this.m_xstatus = 1;
                                this.m_target = addr.getAddress();
                                this.m_signaled = false;
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"run: starting poll");
                                }
                                try {
                                    this.poll(addr);
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)"run: poll completed");
                                    }
                                }
                                catch (NoRouteToHostException ex) {
                                    log.warn((Object)("Check discovery configuration, cannot poll broadcast addresses (addr = " + this.m_target + ")"));
                                    if (!log.isDebugEnabled()) break block27;
                                    log.debug((Object)("run: poll cancelled, invalid address " + this.m_target), (Throwable)ex);
                                }
                            }
                            this.m_target = null;
                            this.m_signaled = false;
                            this.m_xstatus = 0;
                        }
                    }
                    catch (Throwable t) {
                        if (this.m_status != 3) {
                            log.fatal((Object)"run: Error in ping thread, exiting", t);
                        } else {
                            log.info((Object)"run: pinging thread exiting", t);
                        }
                        return;
                    }
                }
                finally {
                    this.m_status = 4;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"run: status set to stopped");
                    }
                }
            }
        }

        public synchronized boolean isPinging(InetAddress addr) {
            if (addr == null) {
                return false;
            }
            return addr.equals(this.m_target);
        }

        public synchronized void signal() {
            this.m_signaled = true;
            this.notifyAll();
        }

        public long getId() {
            return this.m_fiberId;
        }
    }
}

