/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueImpl;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.DiscoveryConfigFactory;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.opennms.netmgt.config.discovery.IncludeRange;
import org.opennms.netmgt.config.discovery.IncludeUrl;
import org.opennms.netmgt.config.discovery.Specific;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.discovery.BroadcastEventProcessor;
import org.opennms.netmgt.discovery.DiscoveredIPMgr;
import org.opennms.netmgt.discovery.IPGenerator;
import org.opennms.netmgt.discovery.IPPollAddress;
import org.opennms.netmgt.discovery.IPPollRange;
import org.opennms.netmgt.discovery.PingManager;
import org.opennms.netmgt.discovery.SuspectEventGenerator;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;

public final class Discovery
extends AbstractServiceDaemon {
    private static final String COMMENT_STR = " #";
    private static final char COMMENT_CHAR = '#';
    private static final Discovery m_singleton = new Discovery();
    private IPGenerator m_generator = null;
    private SuspectEventGenerator m_eventWriter = null;
    private BroadcastEventProcessor m_eventReader = null;
    private PingManager m_manager = null;

    private Discovery() {
        super("OpenNMS.Discovery");
    }

    private boolean addToSpecificsFromURL(List specifics, String url, long timeout, int retries) {
        boolean bRet;
        block10: {
            Category log = ThreadCategory.getInstance();
            bRet = true;
            try {
                URL fileURL = new URL(url);
                InputStream is = fileURL.openStream();
                if (is != null) {
                    BufferedReader buffer = new BufferedReader(new InputStreamReader(is));
                    String ipLine = null;
                    String specIP = null;
                    while ((ipLine = buffer.readLine()) != null) {
                        if ((ipLine = ipLine.trim()).length() == 0 || ipLine.charAt(0) == '#') continue;
                        int comIndex = ipLine.indexOf(COMMENT_STR);
                        if (comIndex == -1) {
                            specIP = ipLine;
                        } else {
                            specIP = ipLine.substring(0, comIndex);
                            ipLine = ipLine.trim();
                        }
                        try {
                            specifics.add(new IPPollAddress(specIP, timeout, retries));
                        }
                        catch (UnknownHostException e) {
                            log.warn((Object)("Unknown host '" + specIP + "' read from URL '" + url.toString() + "': address ignored"));
                        }
                        specIP = null;
                    }
                    buffer.close();
                    break block10;
                }
                log.warn((Object)("URL does not exist: " + url.toString()));
                bRet = true;
            }
            catch (MalformedURLException e) {
                log.error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
                bRet = false;
            }
            catch (FileNotFoundException e) {
                log.error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
                bRet = false;
            }
            catch (IOException e) {
                log.error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
                bRet = false;
            }
        }
        return bRet;
    }

    protected void onInit() {
        int retries;
        long timeout;
        if (this.m_manager != null) {
            this.log().error((Object)"The discovery service is already running and init() was called");
            throw new IllegalStateException("The discovery service is already running");
        }
        Connection ctest = null;
        try {
            DataSourceFactory.init();
            ctest = DataSourceFactory.getInstance().getConnection();
        }
        catch (IOException ie) {
            this.log().fatal((Object)"IOException getting database connection", (Throwable)ie);
            throw new UndeclaredThrowableException(ie);
        }
        catch (MarshalException me) {
            this.log().fatal((Object)"Marshall Exception getting database connection", (Throwable)me);
            throw new UndeclaredThrowableException(me);
        }
        catch (ValidationException ve) {
            this.log().fatal((Object)"Validation Exception getting database connection", (Throwable)ve);
            throw new UndeclaredThrowableException(ve);
        }
        catch (SQLException sqlE) {
            this.log().fatal((Object)"SQL Exception getting database connection", (Throwable)sqlE);
            throw new UndeclaredThrowableException(sqlE);
        }
        catch (ClassNotFoundException cnfE) {
            this.log().fatal((Object)"Class Not Found Exception getting database connection", (Throwable)cnfE);
            throw new UndeclaredThrowableException(cnfE);
        }
        catch (PropertyVetoException e) {
            this.log().fatal((Object)"initialize: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        finally {
            try {
                if (ctest != null) {
                    ctest.close();
                }
            }
            catch (Exception e) {}
        }
        DiscoveryConfigFactory dFactory = null;
        try {
            DiscoveryConfigFactory.reload();
            dFactory = DiscoveryConfigFactory.getInstance();
        }
        catch (MarshalException ex) {
            this.log().error((Object)"Failed to load discovery configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().error((Object)"Failed to load discovery configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().error((Object)"Failed to load discovery configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        DiscoveryConfiguration cfg = dFactory.getConfiguration();
        LinkedList<IPPollAddress> specifics = new LinkedList<IPPollAddress>();
        LinkedList<IPPollRange> includes = new LinkedList<IPPollRange>();
        Enumeration e = cfg.enumerateSpecific();
        while (e.hasMoreElements()) {
            Specific s = (Specific)e.nextElement();
            timeout = 800L;
            if (s.hasTimeout()) {
                timeout = s.getTimeout();
            } else if (cfg.hasTimeout()) {
                timeout = cfg.getTimeout();
            }
            retries = 3;
            if (s.hasRetries()) {
                retries = s.getRetries();
            } else if (cfg.hasRetries()) {
                retries = cfg.getRetries();
            }
            try {
                specifics.add(new IPPollAddress(s.getContent(), timeout, retries));
            }
            catch (UnknownHostException uhE) {
                this.log().warn((Object)("Failed to convert address " + s.getContent()), (Throwable)uhE);
            }
        }
        e = cfg.enumerateIncludeRange();
        while (e.hasMoreElements()) {
            IncludeRange ir = (IncludeRange)e.nextElement();
            timeout = 800L;
            if (ir.hasTimeout()) {
                timeout = ir.getTimeout();
            } else if (cfg.hasTimeout()) {
                timeout = cfg.getTimeout();
            }
            retries = 3;
            if (ir.hasRetries()) {
                retries = ir.getRetries();
            } else if (cfg.hasRetries()) {
                retries = cfg.getRetries();
            }
            try {
                includes.add(new IPPollRange(ir.getBegin(), ir.getEnd(), timeout, retries));
            }
            catch (UnknownHostException uhE) {
                this.log().warn((Object)("Failed to convert address range (" + ir.getBegin() + ", " + ir.getEnd() + ")"), (Throwable)uhE);
            }
        }
        e = cfg.enumerateIncludeUrl();
        while (e.hasMoreElements()) {
            IncludeUrl url = (IncludeUrl)e.nextElement();
            timeout = 800L;
            if (url.hasTimeout()) {
                timeout = url.getTimeout();
            } else if (cfg.hasTimeout()) {
                timeout = cfg.getTimeout();
            }
            retries = 3;
            if (url.hasRetries()) {
                retries = url.getRetries();
            } else if (cfg.hasRetries()) {
                retries = cfg.getRetries();
            }
            this.addToSpecificsFromURL(specifics, url.getContent(), timeout, retries);
        }
        DiscoveredIPMgr.setExclusionList(cfg.getExcludeRange());
        DiscoveredIPMgr.setSpecificsList(specifics);
        this.m_generator = new IPGenerator(specifics, includes, cfg.getInitialSleepTime(), cfg.getRestartSleepTime());
        EventIpcManagerFactory.init();
        FifoQueueImpl responsive = new FifoQueueImpl();
        try {
            this.m_eventWriter = new SuspectEventGenerator((FifoQueue)responsive, cfg.getRestartSleepTime());
        }
        catch (Exception ex) {
            this.log().error((Object)"Failed to create event writer", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        try {
            this.m_eventReader = new BroadcastEventProcessor();
        }
        catch (Exception ex) {
            try {
                this.m_eventWriter.stop();
            }
            catch (Exception exx) {
                // empty catch block
            }
            this.log().error((Object)"Failed to create event reader", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        try {
            this.m_manager = new PingManager(this.m_generator, (FifoQueue)responsive, -16657, cfg.getThreads(), cfg.getPacketsPerSecond());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this.log().error((Object)"Failed to create ping manager in init()", ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    protected void onStart() {
        if (this.m_manager == null) {
            this.log().error((Object)"The discovery service has not been initialized and start() was called");
            throw new IllegalStateException("The discovery service has not been successfully initialized");
        }
        try {
            this.m_eventWriter.start();
        }
        catch (Exception ex) {
            this.log().error((Object)"Failed to start event writer", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        try {
            this.m_manager.start();
        }
        catch (Exception ex) {
            try {
                this.m_eventWriter.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log().error((Object)"Failed to start ping manager", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    protected void onStop() {
        try {
            if (this.m_eventReader != null) {
                this.m_eventReader.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.m_eventWriter != null) {
                this.m_eventWriter.stop();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.m_eventWriter = null;
        this.m_eventReader = null;
        this.m_generator = null;
        try {
            if (this.m_manager != null) {
                this.m_manager.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_manager = null;
    }

    protected void onPause() {
        if (this.m_manager == null) {
            this.log().error((Object)"The discovery service has not been initialized and pause() was called");
            throw new IllegalStateException("The discovery service has not been successfully initialized");
        }
        this.m_manager.pause();
    }

    protected void onResume() {
        if (this.m_manager == null) {
            this.log().error((Object)"The discovery service has not been initialized and resume() was called");
            throw new IllegalStateException("The discovery service has not been successfully initialized");
        }
        this.m_manager.resume();
    }

    public static Discovery getInstance() {
        return m_singleton;
    }
}

