/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.discovery.DiscoveredIPMgr;
import org.opennms.netmgt.discovery.Discovery;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.eventd.EventListener;
import org.opennms.netmgt.xml.event.Event;

final class BroadcastEventProcessor
implements EventListener {
    BroadcastEventProcessor() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/nodeGainedInterface");
        ueiList.add("uei.opennms.org/internal/capsd/discPause");
        ueiList.add("uei.opennms.org/internal/capsd/discResume");
        ueiList.add("uei.opennms.org/nodes/interfaceDeleted");
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener((EventListener)this, ueiList);
    }

    public void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener(this);
    }

    public void onEvent(Event event) {
        Category log = ThreadCategory.getInstance(this.getClass());
        String eventUei = event.getUei();
        if (eventUei == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received event: " + eventUei));
        }
        if (eventUei.equals("uei.opennms.org/nodes/nodeGainedInterface")) {
            try {
                DiscoveredIPMgr.addDiscovered(event.getInterface());
            }
            catch (UnknownHostException uhE) {
                ThreadCategory.getInstance(this.getClass()).warn((Object)("Failed to add interface " + event.getInterface() + " to discovered address set"), (Throwable)uhE);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added " + event.getInterface() + " as discovered"));
            }
        } else if (eventUei.equals("uei.opennms.org/internal/capsd/discPause")) {
            try {
                Discovery.getInstance().pause();
            }
            catch (IllegalStateException ex) {}
        } else if (eventUei.equals("uei.opennms.org/internal/capsd/discResume")) {
            try {
                Discovery.getInstance().resume();
            }
            catch (IllegalStateException ex) {}
        } else if (eventUei.equals("uei.opennms.org/nodes/interfaceDeleted")) {
            try {
                DiscoveredIPMgr.removeDiscovered(event.getInterface());
            }
            catch (UnknownHostException uhE) {
                ThreadCategory.getInstance(this.getClass()).warn((Object)("Failed to remove interface " + event.getInterface() + " from discovered address set"), (Throwable)uhE);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed " + event.getInterface() + " from known node list"));
            }
        }
    }

    public String getName() {
        return "Discovery:BroadcastEventProcessor";
    }
}

