/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.xmlrpcd.SubscribedEvent;
import org.opennms.netmgt.config.xmlrpcd.XmlrpcServer;
import org.opennms.netmgt.config.xmlrpcd.XmlrpcdConfiguration;

public final class XmlrpcdConfigFactory {
    private static XmlrpcdConfigFactory m_singleton = null;
    private static boolean m_loaded = false;
    private XmlrpcdConfiguration m_config;

    private XmlrpcdConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileInputStream cfgIn = new FileInputStream(configFile);
        this.m_config = (XmlrpcdConfiguration)Unmarshaller.unmarshal(XmlrpcdConfiguration.class, (Reader)new InputStreamReader(cfgIn));
        ((InputStream)cfgIn).close();
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.XMLRPCD_CONFIG_FILE_NAME);
        ThreadCategory.getInstance(XmlrpcdConfigFactory.class).debug((Object)("init: config file path: " + cfgFile.getPath()));
        m_singleton = new XmlrpcdConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        XmlrpcdConfigFactory.init();
    }

    public static synchronized XmlrpcdConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public synchronized XmlrpcdConfiguration getConfiguration() {
        return this.m_config;
    }

    public synchronized boolean eventSubscribed(String uei) {
        Category log = ThreadCategory.getInstance(this.getClass());
        Enumeration eventEnum = this.m_config.getSubscription().enumerateSubscribedEvent();
        boolean isSubscribed = false;
        while (eventEnum.hasMoreElements()) {
            SubscribedEvent sEvent = (SubscribedEvent)eventEnum.nextElement();
            if (!sEvent.getUei().equals(uei)) continue;
            isSubscribed = true;
            if (!log.isDebugEnabled()) break;
            log.debug((Object)("eventSubscribed: Event " + uei + " is subscribed."));
            break;
        }
        return isSubscribed;
    }

    public synchronized Enumeration getEventEnumeration() {
        return this.m_config.getSubscription().enumerateSubscribedEvent();
    }

    public synchronized Enumeration getXmlrpcServerEnumeration() {
        return this.m_config.getExternalServers().enumerateXmlrpcServer();
    }

    public synchronized XmlrpcServer[] getXmlrpcServer() {
        return this.m_config.getExternalServers().getXmlrpcServer();
    }

    public synchronized int getRetries() {
        return this.m_config.getExternalServers().getRetries();
    }

    public synchronized int getElapseTime() {
        return this.m_config.getExternalServers().getElapseTime();
    }

    public synchronized int getMaxQueueSize() {
        return this.m_config.getMaxEventQueueSize();
    }
}

