/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.service.Service;
import org.opennms.netmgt.config.service.ServiceConfiguration;

public final class ServiceConfigFactory {
    private static ServiceConfigFactory m_singleton = null;
    private static boolean m_loaded = false;
    private ServiceConfiguration m_config;

    private ServiceConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileReader cfgIn = new FileReader(configFile);
        this.parseXml(cfgIn);
        cfgIn.close();
    }

    public ServiceConfigFactory(Reader rdr) throws MarshalException, ValidationException {
        this.parseXml(rdr);
    }

    private void parseXml(Reader cfgIn) throws MarshalException, ValidationException {
        this.m_config = (ServiceConfiguration)Unmarshaller.unmarshal(ServiceConfiguration.class, (Reader)cfgIn);
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SERVICE_CONF_FILE_NAME);
        Category log = ThreadCategory.getInstance(ServiceConfigFactory.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("ServiceConfigFactory.init: config file path " + cfgFile.getPath()));
        }
        m_singleton = new ServiceConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        ServiceConfigFactory.init();
    }

    public static synchronized ServiceConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("Factory not initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(ServiceConfigFactory instance) {
        m_loaded = true;
        m_singleton = instance;
    }

    public Service[] getServices() {
        int count = this.m_config.getServiceCount();
        Service[] slist = new Service[count];
        count = 0;
        Enumeration esvc = this.m_config.enumerateService();
        while (esvc.hasMoreElements()) {
            slist[count++] = (Service)esvc.nextElement();
        }
        return slist;
    }
}

