/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.BasicScheduleUtils;
import org.opennms.netmgt.config.PollOutagesConfig;
import org.opennms.netmgt.config.common.BasicSchedule;
import org.opennms.netmgt.config.common.Time;
import org.opennms.netmgt.config.poller.Interface;
import org.opennms.netmgt.config.poller.Node;
import org.opennms.netmgt.config.poller.Outage;
import org.opennms.netmgt.config.poller.Outages;

public abstract class PollOutagesConfigManager
implements PollOutagesConfig {
    private Outages m_config;

    protected void setConfig(Outages config) {
        this.m_config = config;
    }

    protected Outages getConfig() {
        return this.m_config;
    }

    public synchronized Outage[] getOutages() {
        return this.getConfig().getOutage();
    }

    public synchronized Outage getOutage(String name) {
        Enumeration e = this.getConfig().enumerateOutage();
        while (e.hasMoreElements()) {
            Outage out = (Outage)e.nextElement();
            if (!out.getName().equals(name)) continue;
            return out;
        }
        return null;
    }

    public synchronized String getOutageType(String name) {
        Outage out = this.getOutage(name);
        if (out == null) {
            return null;
        }
        return out.getType();
    }

    public synchronized Time[] getOutageTimes(String name) {
        Outage out = this.getOutage(name);
        if (out == null) {
            return null;
        }
        return out.getTime();
    }

    public synchronized Interface[] getInterfaces(String name) {
        Outage out = this.getOutage(name);
        if (out == null) {
            return null;
        }
        return out.getInterface();
    }

    public synchronized boolean isInterfaceInOutage(String linterface, String outName) {
        Outage out = this.getOutage(outName);
        if (out == null) {
            return false;
        }
        return this.isInterfaceInOutage(linterface, out);
    }

    public synchronized boolean isInterfaceInOutage(String linterface, Outage out) {
        if (out == null) {
            return false;
        }
        Enumeration e = out.enumerateInterface();
        while (e.hasMoreElements()) {
            Interface ointerface = (Interface)e.nextElement();
            if (!ointerface.getAddress().equals(linterface)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isTimeInOutage(Calendar cal, String outName) {
        Outage out = this.getOutage(outName);
        if (out == null) {
            return false;
        }
        return this.isTimeInOutage(cal, out);
    }

    public synchronized boolean isTimeInOutage(long time, String outName) {
        Outage out = this.getOutage(outName);
        if (out == null) {
            return false;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        return this.isTimeInOutage(cal, out);
    }

    public synchronized boolean isTimeInOutage(Calendar cal, Outage outage) {
        return BasicScheduleUtils.isTimeInSchedule(cal, (BasicSchedule)outage);
    }

    public synchronized boolean isCurTimeInOutage(String outName) {
        GregorianCalendar cal = new GregorianCalendar();
        return this.isTimeInOutage((Calendar)cal, outName);
    }

    public synchronized boolean isCurTimeInOutage(Outage out) {
        GregorianCalendar cal = new GregorianCalendar();
        return this.isTimeInOutage((Calendar)cal, out);
    }

    public synchronized void addOutage(Outage newOutage) {
        this.m_config.addOutage(newOutage);
    }

    public synchronized void removeOutage(String outageName) {
        this.m_config.removeOutage(this.getOutage(outageName));
    }

    public synchronized void removeOutage(Outage outageToRemove) {
        this.m_config.removeOutage(outageToRemove);
    }

    public synchronized void replaceOutage(Outage oldOutage, Outage newOutage) {
        int count = this.m_config.getOutageCount();
        for (int i = 0; i < count; ++i) {
            if (!this.m_config.getOutage(i).equals(oldOutage)) continue;
            this.m_config.setOutage(i, newOutage);
            return;
        }
    }

    public synchronized Node[] getNodeIds(String name) {
        Outage out = this.getOutage(name);
        if (out == null) {
            return null;
        }
        return out.getNode();
    }

    public synchronized boolean isNodeIdInOutage(long lnodeid, String outName) {
        Outage out = this.getOutage(outName);
        if (out == null) {
            return false;
        }
        return this.isNodeIdInOutage(lnodeid, out);
    }

    public synchronized Calendar getEndOfOutage(String outName) {
        Outage out = this.getOutage(outName);
        if (out == null) {
            return null;
        }
        return PollOutagesConfigManager.getEndOfOutage(out);
    }

    public static synchronized Calendar getEndOfOutage(Outage out) {
        return BasicScheduleUtils.getEndOfSchedule((BasicSchedule)out);
    }

    public synchronized boolean isNodeIdInOutage(long lnodeid, Outage out) {
        if (out == null) {
            return false;
        }
        Enumeration en = out.enumerateNode();
        while (en.hasMoreElements()) {
            Node onode = (Node)en.nextElement();
            if ((long)onode.getId() != lnodeid) continue;
            return true;
        }
        return false;
    }

    public synchronized void saveCurrent() throws MarshalException, IOException, ValidationException {
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)this.m_config, (Writer)stringWriter);
        String xmlString = stringWriter.toString();
        if (xmlString != null) {
            this.saveXML(xmlString);
        }
        this.update();
    }

    protected abstract void saveXML(String var1) throws IOException, MarshalException, ValidationException;

    public abstract void update() throws IOException, MarshalException, ValidationException;
}

