/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.PollOutagesConfigManager;
import org.opennms.netmgt.config.poller.Outages;

public final class PollOutagesConfigFactory
extends PollOutagesConfigManager {
    private static PollOutagesConfigFactory m_singleton = null;
    private static boolean m_loaded = false;

    PollOutagesConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileInputStream cfgIn = new FileInputStream(configFile);
        this.setConfig((Outages)Unmarshaller.unmarshal(Outages.class, (Reader)new InputStreamReader(cfgIn)));
        ((InputStream)cfgIn).close();
    }

    public PollOutagesConfigFactory(Reader rdr) throws MarshalException, ValidationException {
        this.setConfig((Outages)Unmarshaller.unmarshal(Outages.class, (Reader)rdr));
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.POLL_OUTAGES_CONFIG_FILE_NAME);
        m_singleton = new PollOutagesConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        PollOutagesConfigFactory.init();
        PollOutagesConfigFactory.getInstance().update();
    }

    public static synchronized PollOutagesConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(PollOutagesConfigFactory instance) {
        m_loaded = true;
        m_singleton = instance;
    }

    protected void saveXML(String xmlString) throws IOException, MarshalException, ValidationException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.POLL_OUTAGES_CONFIG_FILE_NAME);
        FileWriter fileWriter = new FileWriter(cfgFile);
        fileWriter.write(xmlString);
        fileWriter.flush();
        fileWriter.close();
    }

    public void update() throws IOException, MarshalException, ValidationException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.POLL_OUTAGES_CONFIG_FILE_NAME);
        FileReader r = new FileReader(cfgFile);
        this.setConfig((Outages)Unmarshaller.unmarshal(Outages.class, (Reader)r));
        ((Reader)r).close();
    }
}

