/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.BasicScheduleUtils;
import org.opennms.netmgt.config.OwnedInterval;
import org.opennms.netmgt.config.OwnedIntervalSequence;
import org.opennms.netmgt.config.Owner;
import org.opennms.netmgt.config.common.BasicSchedule;
import org.opennms.netmgt.config.common.Header;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.config.groups.Groupinfo;
import org.opennms.netmgt.config.groups.Groups;
import org.opennms.netmgt.config.groups.Role;
import org.opennms.netmgt.config.groups.Roles;
import org.opennms.netmgt.config.groups.Schedule;
import org.opennms.netmgt.config.users.DutySchedule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroupManager {
    protected static HashMap<String, List<DutySchedule>> m_dutySchedules;
    private Map<String, Group> m_groups;
    private Map<String, Role> m_roles;
    private Header m_oldHeader;

    protected synchronized void parseXml(Reader reader) throws MarshalException, ValidationException {
        Groupinfo groupinfo = (Groupinfo)Unmarshaller.unmarshal(Groupinfo.class, (Reader)reader);
        Groups groups = groupinfo.getGroups();
        this.m_groups = new LinkedHashMap<String, Group>();
        ArrayList groupList = groups.getGroupCollection();
        this.m_oldHeader = groupinfo.getHeader();
        for (Group curGroup : groupList) {
            this.m_groups.put(curGroup.getName(), curGroup);
        }
        GroupManager.buildDutySchedules(this.m_groups);
        Roles roles = groupinfo.getRoles();
        this.m_roles = new LinkedHashMap<String, Role>();
        if (roles != null) {
            for (Role role : roles.getRoleCollection()) {
                this.m_roles.put(role.getName(), role);
            }
        }
    }

    public void setGroups(Map<String, Group> grp) {
        this.m_groups = grp;
    }

    public Map<String, Group> getGroups() throws IOException, MarshalException, ValidationException {
        this.update();
        return new LinkedHashMap<String, Group>(this.m_groups);
    }

    protected abstract void update() throws IOException, MarshalException, ValidationException;

    public boolean hasGroup(String groupName) throws IOException, MarshalException, ValidationException {
        this.update();
        return this.m_groups.containsKey(groupName);
    }

    public List<String> getGroupNames() throws IOException, MarshalException, ValidationException {
        this.update();
        return new ArrayList<String>(this.m_groups.keySet());
    }

    public Group getGroup(String name) throws IOException, MarshalException, ValidationException {
        this.update();
        return this.m_groups.get(name);
    }

    public synchronized void saveGroups() throws Exception {
        Header header = this.m_oldHeader;
        header.setCreated(EventConstants.formatToString(new Date()));
        Groups groups = new Groups();
        Collection<Group> collgroups = this.m_groups.values();
        Iterator<Group> iter = collgroups.iterator();
        while (iter != null && iter.hasNext()) {
            Group grp = iter.next();
            groups.addGroup(grp);
        }
        Roles roles = new Roles();
        for (Role role : this.m_roles.values()) {
            roles.addRole(role);
        }
        Groupinfo groupinfo = new Groupinfo();
        groupinfo.setGroups(groups);
        if (roles.getRoleCount() > 0) {
            groupinfo.setRoles(roles);
        }
        groupinfo.setHeader(header);
        this.m_oldHeader = header;
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)groupinfo, (Writer)stringWriter);
        String data = stringWriter.toString();
        this.saveXml(data);
    }

    private static void buildDutySchedules(Map groups) {
        m_dutySchedules = new HashMap();
        for (String key : groups.keySet()) {
            Group curGroup = (Group)groups.get(key);
            if (curGroup.getDutyScheduleCount() <= 0) continue;
            ArrayList<DutySchedule> dutyList = new ArrayList<DutySchedule>();
            Enumeration duties = curGroup.enumerateDutySchedule();
            while (duties.hasMoreElements()) {
                dutyList.add(new DutySchedule((String)duties.nextElement()));
            }
            m_dutySchedules.put(key, dutyList);
        }
    }

    public boolean isGroupOnDuty(String group, Calendar time) throws IOException, MarshalException, ValidationException {
        DutySchedule curSchedule;
        this.update();
        if (!m_dutySchedules.containsKey(group)) {
            return true;
        }
        boolean result = false;
        List<DutySchedule> dutySchedules = m_dutySchedules.get(group);
        for (int i = 0; i < dutySchedules.size() && !(result = (curSchedule = dutySchedules.get(i)).isInSchedule(time)); ++i) {
        }
        return result;
    }

    public long groupNextOnDuty(String group, Calendar time) throws IOException, MarshalException, ValidationException {
        Category log = ThreadCategory.getInstance(this.getClass());
        long next = -1L;
        this.update();
        if (!m_dutySchedules.containsKey(group)) {
            return 0L;
        }
        List<DutySchedule> dutySchedules = m_dutySchedules.get(group);
        for (int i = 0; i < dutySchedules.size(); ++i) {
            DutySchedule curSchedule = dutySchedules.get(i);
            long tempnext = curSchedule.nextInSchedule(time);
            if (tempnext >= next && next != -1L) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("isGroupOnDuty: On duty in " + tempnext + " millisec from schedule " + i));
            }
            next = tempnext;
        }
        return next;
    }

    protected abstract void saveXml(String var1) throws IOException;

    public synchronized void saveGroup(String name, Group details) throws Exception {
        if (name == null || details == null) {
            throw new Exception("GroupFactory:saveGroup  null");
        }
        this.m_groups.put(name, details);
        this.saveGroups();
    }

    public void saveRole(Role role) throws Exception {
        this.m_roles.put(role.getName(), role);
        this.saveGroups();
    }

    public synchronized void deleteUser(String name) throws Exception {
        if (name != null || !name.equals("")) {
            Set<String> grps = this.m_groups.keySet();
            Iterator<String> iterator = grps.iterator();
            while (iterator.hasNext()) {
                Group group = this.m_groups.get(iterator.next());
                group.removeUser(name);
            }
            for (Role role : this.m_roles.values()) {
                Iterator j = role.getScheduleCollection().iterator();
                while (j.hasNext()) {
                    Schedule sched = (Schedule)j.next();
                    if (!name.equals(sched.getName())) continue;
                    j.remove();
                }
            }
        } else {
            throw new Exception("GroupFactory:delete Invalid user name:" + name);
        }
        this.saveGroups();
    }

    public synchronized void deleteGroup(String name) throws Exception {
        if (name != null || !name.equals("")) {
            if (!this.m_groups.containsKey(name)) {
                throw new Exception("GroupFactory:delete Group doesnt exist:" + name);
            }
        } else {
            throw new Exception("GroupFactory:delete Invalid user group:" + name);
        }
        this.m_groups.remove(name);
        this.saveGroups();
    }

    public void deleteRole(String name) throws Exception {
        if (name != null && !name.equals("")) {
            if (!this.m_roles.containsKey(name)) {
                throw new Exception("GroupFacotry:deleteRole Role doesn't exist: " + name);
            }
        } else {
            throw new Exception("GroupFactory:deleteRole Invalid role name: " + name);
        }
        this.m_roles.remove(name);
        this.saveGroups();
    }

    public synchronized void renameGroup(String oldName, String newName) throws Exception {
    }

    public synchronized void renameUser(String oldName, String newName) throws Exception {
        if (oldName == null || newName == null || oldName == "" || newName == "") {
            throw new Exception("Group Factory: Rename user.. no value ");
        }
        Collection<Group> coll = this.m_groups.values();
        Iterator<Group> iter = coll.iterator();
        LinkedHashMap<String, Group> map = new LinkedHashMap<String, Group>();
        while (iter.hasNext()) {
            Group group = iter.next();
            Enumeration en = group.enumerateUser();
            String name = "";
            while (en.hasMoreElements()) {
                name = (String)en.nextElement();
                if (!name.equals(oldName)) continue;
                group.removeUser(oldName);
                group.addUser(newName);
            }
            map.put(group.getName(), group);
        }
        this.m_groups.clear();
        this.m_groups = map;
        for (Role role : this.m_roles.values()) {
            for (Schedule sched : role.getScheduleCollection()) {
                if (!oldName.equals(sched.getName())) continue;
                sched.setName(newName);
            }
        }
        this.saveGroups();
    }

    public String[] getRoleNames() {
        return this.m_roles.keySet().toArray(new String[this.m_roles.keySet().size()]);
    }

    public Collection getRoles() {
        return this.m_roles.values();
    }

    public Role getRole(String roleName) {
        return this.m_roles.get(roleName);
    }

    public boolean userHasRole(String userId, String roleid) throws MarshalException, ValidationException, IOException {
        this.update();
        Role role = this.getRole(roleid);
        for (Schedule sched : role.getScheduleCollection()) {
            if (!userId.equals(sched.getName())) continue;
            return true;
        }
        return false;
    }

    public List<Schedule> getSchedulesForRoleAt(String roleId, Date time) throws MarshalException, ValidationException, IOException {
        this.update();
        Role role = this.getRole(roleId);
        ArrayList<Schedule> schedules = new ArrayList<Schedule>();
        for (Schedule sched : role.getScheduleCollection()) {
            if (!BasicScheduleUtils.isTimeInSchedule(time, (BasicSchedule)sched)) continue;
            schedules.add(sched);
        }
        return schedules;
    }

    public List getUserSchedulesForRole(String userId, String roleid) throws MarshalException, ValidationException, IOException {
        this.update();
        ArrayList<Schedule> scheds = new ArrayList<Schedule>();
        Role role = this.getRole(roleid);
        for (Schedule sched : role.getScheduleCollection()) {
            if (!userId.equals(sched.getName())) continue;
            scheds.add(sched);
        }
        return scheds;
    }

    public boolean isUserScheduledForRole(String userId, String roleid, Date time) throws MarshalException, ValidationException, IOException {
        this.update();
        List scheds = this.getUserSchedulesForRole(userId, roleid);
        for (Schedule sched : scheds) {
            if (!BasicScheduleUtils.isTimeInSchedule(time, (BasicSchedule)sched)) continue;
            return true;
        }
        Role role = this.getRole(roleid);
        if (userId.equals(role.getSupervisor())) {
            for (Schedule sched : role.getScheduleCollection()) {
                if (!BasicScheduleUtils.isTimeInSchedule(time, (BasicSchedule)sched)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public OwnedIntervalSequence getRoleScheduleEntries(String roleid, Date start, Date end) throws MarshalException, ValidationException, IOException {
        this.update();
        OwnedIntervalSequence schedEntries = new OwnedIntervalSequence();
        Role role = this.getRole(roleid);
        for (int i = 0; i < role.getScheduleCount(); ++i) {
            Schedule sched = role.getSchedule(i);
            Owner owner = new Owner(roleid, sched.getName(), i);
            schedEntries.addAll(BasicScheduleUtils.getIntervalsCovering(start, end, (BasicSchedule)sched, owner));
        }
        OwnedIntervalSequence defaultEntries = new OwnedIntervalSequence(new OwnedInterval(start, end));
        defaultEntries.removeAll(schedEntries);
        Owner supervisor = new Owner(roleid, role.getSupervisor());
        Iterator it = defaultEntries.iterator();
        while (it.hasNext()) {
            OwnedInterval interval = (OwnedInterval)it.next();
            interval.addOwner(supervisor);
        }
        schedEntries.addAll(defaultEntries);
        return schedEntries;
    }

    public List<Group> findGroupsForUser(String user) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Group group : this.m_groups.values()) {
            if (!group.getUserCollection().contains(user)) continue;
            groups.add(group);
        }
        return groups;
    }
}

