/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.GroupManager;

public class GroupFactory
extends GroupManager {
    private static GroupManager s_instance;
    private static boolean s_initialized;
    private File m_groupsConfFile;
    private long m_lastModified;

    public GroupFactory() throws MarshalException, ValidationException, FileNotFoundException, IOException {
        this.reload();
    }

    public static synchronized void init() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (s_instance == null || !s_initialized) {
            s_instance = new GroupFactory();
            s_initialized = true;
        }
    }

    public static synchronized GroupManager getInstance() {
        return s_instance;
    }

    public static synchronized void setInstance(GroupManager mgr) {
        s_initialized = true;
        s_instance = mgr;
    }

    public synchronized void reload() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        File confFile = ConfigFileConstants.getFile((int)ConfigFileConstants.GROUPS_CONF_FILE_NAME);
        this.reloadFromFile(confFile);
    }

    private void reloadFromFile(File confFile) throws FileNotFoundException, MarshalException, ValidationException {
        this.m_groupsConfFile = confFile;
        FileInputStream configIn = new FileInputStream(this.m_groupsConfFile);
        this.m_lastModified = this.m_groupsConfFile.lastModified();
        InputStreamReader reader = new InputStreamReader(configIn);
        this.parseXml(reader);
    }

    protected void saveXml(String data) throws IOException {
        if (data != null) {
            FileWriter fileWriter = new FileWriter(this.m_groupsConfFile);
            fileWriter.write(data);
            fileWriter.flush();
            fileWriter.close();
        }
    }

    protected void update() throws IOException, MarshalException, ValidationException {
        if (this.m_lastModified != this.m_groupsConfFile.lastModified()) {
            this.reload();
        }
    }

    static {
        s_initialized = false;
    }
}

