/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opennms.netmgt.collectd.AttributeType;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.DbResourceType;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.snmp.SnmpInstId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfResourceType
extends DbResourceType {
    private TreeMap<Integer, IfInfo> m_ifMap = new TreeMap();

    public IfResourceType(CollectionAgent agent, OnmsSnmpCollection snmpCollection) {
        super(agent, snmpCollection);
        this.addKnownIfResources();
    }

    private Map<Integer, IfInfo> getIfMap() {
        return this.m_ifMap;
    }

    void addIfInfo(IfInfo ifInfo) {
        this.getIfMap().put(new Integer(ifInfo.getIndex()), ifInfo);
    }

    void logInitializeSnmpIface(OnmsSnmpInterface snmpIface) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: snmpifindex = " + snmpIface.getIfIndex() + ", snmpifname = " + snmpIface.getIfName() + ", snmpifdescr = " + snmpIface.getIfDescr() + ", snmpphysaddr = -" + snmpIface.getPhysAddr() + "-"));
            this.log().debug((Object)("initialize: ifLabel = '" + snmpIface.computeLabelForRRD() + "'"));
        }
    }

    void addSnmpInterface(OnmsSnmpInterface snmpIface) {
        this.addIfInfo(new IfInfo(this, this.getAgent(), snmpIface));
    }

    void addKnownIfResources() {
        CollectionAgent agent = this.getAgent();
        OnmsNode node = agent.getNode();
        Set snmpIfs = node.getSnmpInterfaces();
        if (snmpIfs.size() == 0) {
            this.log().debug((Object)("no known SNMP interfaces for node " + node));
        }
        for (OnmsSnmpInterface snmpIface : snmpIfs) {
            this.logInitializeSnmpIface(snmpIface);
            this.addSnmpInterface(snmpIface);
        }
    }

    IfInfo getIfInfo(int ifIndex) {
        return this.getIfMap().get(new Integer(ifIndex));
    }

    public Collection<IfInfo> getIfInfos() {
        return this.getIfMap().values();
    }

    List<AttributeType> getCombinedInterfaceAttributes() {
        LinkedHashSet<AttributeType> attributes = new LinkedHashSet<AttributeType>();
        for (IfInfo ifInfo : this.getIfInfos()) {
            attributes.addAll(((CollectionResource)ifInfo).getAttributeTypes());
        }
        return new ArrayList<AttributeType>(attributes);
    }

    @Override
    public int getType() {
        return -2;
    }

    @Override
    public CollectionResource findResource(SnmpInstId inst) {
        return this.getIfInfo(inst.toInt());
    }

    @Override
    public CollectionResource findAliasedResource(SnmpInstId inst, String ifAlias) {
        this.log().debug((Object)"findAliasedResource: Should not get called from IfResourceType");
        return null;
    }

    public Collection<IfInfo> getResources() {
        return this.m_ifMap.values();
    }
}

