/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import org.apache.log4j.Category;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.DbCollectionResource;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SNMPCollectorEntry;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.RrdRepository;

final class IfInfo
extends DbCollectionResource {
    private OnmsSnmpInterface m_snmpIface;
    private SNMPCollectorEntry m_entry;

    public IfInfo(ResourceType def, CollectionAgent agent, OnmsSnmpInterface snmpIface) {
        super(def, agent);
        this.m_snmpIface = snmpIface;
    }

    public int getIndex() {
        return this.m_snmpIface.getIfIndex();
    }

    public int getType() {
        return this.m_snmpIface.getIfType();
    }

    public String getLabel() {
        return this.m_snmpIface.computeLabelForRRD();
    }

    public OnmsIpInterface.CollectionType getCollType() {
        return this.m_snmpIface.getCollectionType();
    }

    public void setEntry(SNMPCollectorEntry ifEntry) {
        this.m_entry = ifEntry;
    }

    protected SNMPCollectorEntry getEntry() {
        return this.m_entry;
    }

    public void setIfAlias(String ifAlias) {
        this.m_snmpIface.setIfAlias(ifAlias);
    }

    String getNewIfAlias() {
        if (this.getEntry() == null) {
            return this.getCurrentIfAlias();
        }
        return this.getEntry().getValueForBase(".1.3.6.1.2.1.31.1.1.1.18");
    }

    String getCurrentIfAlias() {
        return this.m_snmpIface.getIfAlias();
    }

    boolean currentAliasIsOutOfDate(String ifAlias) {
        this.log().debug((Object)("currentAliasIsOutOfDate: ifAlias from collection = " + ifAlias + ", current ifAlias = " + this.getCurrentIfAlias()));
        return ifAlias != null && !ifAlias.equals(this.getCurrentIfAlias());
    }

    void logAlias(String ifAlias) {
        Category log = this.log();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Alias for RRD directory name = " + ifAlias));
        }
    }

    String getAliasDir(String ifAlias, String ifAliasComment) {
        if (ifAlias != null) {
            int si;
            if (ifAliasComment != null && (si = ifAlias.indexOf(ifAliasComment)) > -1) {
                ifAlias = ifAlias.substring(0, si).trim();
            }
            if (ifAlias != null) {
                ifAlias = AlphaNumeric.parseAndReplaceExcept((String)ifAlias, (char)'_', (String)"-._");
            }
        }
        this.logAlias(ifAlias);
        return ifAlias;
    }

    void logForceRescan(String ifAlias) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Forcing rescan.  IfAlias " + ifAlias + " for index " + this.getIndex() + " does not match DB value: " + this.getCurrentIfAlias()));
        }
    }

    boolean isScheduledForCollection() {
        this.log().debug((Object)(this + ".isSnmpPrimary = " + this.getCollType()));
        this.log().debug((Object)("minCollType = " + this.getCollection().getMinimumCollectionType()));
        boolean isScheduled = !this.getCollType().isLessThan(this.getCollection().getMinimumCollectionType());
        this.log().debug((Object)(this.getCollType() + " >= " + this.getCollection().getMinimumCollectionType() + " = " + isScheduled));
        return isScheduled;
    }

    private OnmsSnmpCollection getCollection() {
        return this.getResourceType().getCollection();
    }

    public File getResourceDir(RrdRepository repository) {
        File rrdBaseDir = repository.getRrdBaseDir();
        File nodeDir = new File(rrdBaseDir, String.valueOf(this.getCollectionAgent().getNodeId()));
        File ifDir = new File(nodeDir, this.getLabel());
        return ifDir;
    }

    public String toString() {
        return "Node[" + this.getCollectionAgent().getNodeId() + "]/ifIndex[" + this.getIndex() + ']';
    }

    boolean shouldStore(ServiceParameters serviceParameters) {
        if (serviceParameters.getStoreByNodeID().equals("normal")) {
            return this.isScheduledForCollection();
        }
        return serviceParameters.getStoreByNodeID().equals("true");
    }

    public boolean shouldPersist(ServiceParameters serviceParameters) {
        boolean shdprsist = this.shouldStore(serviceParameters) && (this.isScheduledForCollection() || serviceParameters.forceStoreByAlias(this.getCurrentIfAlias()));
        this.log().debug((Object)("shouldPersist = " + shdprsist));
        return shdprsist;
    }
}

