/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.collectd.AliasedResource;
import org.opennms.netmgt.collectd.AttributeGroupType;
import org.opennms.netmgt.collectd.AttributeType;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.collectd.IfResourceType;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.config.MibObject;
import org.opennms.netmgt.snmp.SnmpInstId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfAliasResourceType
extends ResourceType {
    private IfResourceType m_ifResourceType;
    private Map m_aliasedIfs = new HashMap();
    private ServiceParameters m_params;

    public IfAliasResourceType(CollectionAgent agent, OnmsSnmpCollection snmpCollection, ServiceParameters params, IfResourceType ifResourceType) {
        super(agent, snmpCollection);
        this.m_ifResourceType = ifResourceType;
        this.m_params = params;
    }

    @Override
    public CollectionResource findResource(SnmpInstId inst) {
        this.log().debug((Object)"findResource: Should not get called from IfAliasResourceType");
        return null;
    }

    @Override
    public CollectionResource findAliasedResource(SnmpInstId inst, String ifAlias) {
        Integer key = new Integer(inst.toInt());
        AliasedResource resource = (AliasedResource)this.m_aliasedIfs.get(key);
        if (resource == null) {
            IfInfo ifInfo = (IfInfo)this.m_ifResourceType.findResource(inst);
            if (ifInfo == null) {
                this.log().info((Object)"Not creating an aliased resource for ifInfo = null");
            } else {
                this.log().info((Object)("Creating an aliased resource for " + ifInfo));
                resource = new AliasedResource(this, this.m_params.getDomain(), ifInfo, this.m_params.getIfAliasComment(), ifAlias);
                this.m_aliasedIfs.put(key, resource);
            }
        }
        return resource;
    }

    @Override
    public Collection<AttributeType> getAttributeTypes() {
        MibObject ifAliasMibObject = new MibObject();
        ifAliasMibObject.setOid(".1.3.6.1.2.1.31.1.1.1.18");
        ifAliasMibObject.setAlias("ifAlias");
        ifAliasMibObject.setType("string");
        ifAliasMibObject.setInstance("ifIndex");
        ifAliasMibObject.setGroupName("aliasedResource");
        ifAliasMibObject.setGroupIfType("all");
        AttributeGroupType groupType = new AttributeGroupType(ifAliasMibObject.getGroupName(), ifAliasMibObject.getGroupIfType());
        AttributeType type = AttributeType.create(this, this.getCollectionName(), ifAliasMibObject, groupType);
        return Collections.singleton(type);
    }

    public Collection getResources() {
        return this.m_aliasedIfs.values();
    }
}

