/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.util.Properties;
import org.opennms.netmgt.collectd.Attribute;
import org.opennms.netmgt.collectd.AttributeGroup;
import org.opennms.netmgt.collectd.BasePersister;
import org.opennms.netmgt.collectd.NumericAttributeType;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;

public class GroupPersister
extends BasePersister {
    public GroupPersister(ServiceParameters params) {
        super(params);
    }

    public void visitGroup(AttributeGroup group) {
        this.pushShouldPersist(group);
        if (this.shouldPersist()) {
            this.createBuilder(group.getResource(), group.getName(), group.getGroupType().getAttributeTypes());
            File path = new File(group.getResource().getResourceDir(this.getRepository()).getAbsolutePath());
            Properties dsProperties = ResourceTypeUtils.getDsProperties((File)path);
            boolean save = false;
            for (Object o : group.getAttributes()) {
                Attribute a = (Attribute)o;
                if (!NumericAttributeType.supportsType(a.getType()) || dsProperties.containsKey(a.getName())) continue;
                dsProperties.setProperty(a.getName(), group.getName());
                save = true;
            }
            try {
                if (save) {
                    File dsFile = new File(path.getAbsolutePath(), ResourceTypeUtils.DS_PROPERTIES_FILE);
                    this.saveUpdatedProperties(dsFile, dsProperties);
                }
            }
            catch (Exception e) {
                this.log().error((Object)("Unable to save DataSource Properties file" + e), (Throwable)e);
            }
        }
    }

    public void completeGroup(AttributeGroup group) {
        if (this.shouldPersist()) {
            this.commitBuilder();
        }
        this.popShouldPersist();
    }
}

