/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.utils.EventProxy;
import org.opennms.netmgt.utils.EventProxyException;
import org.opennms.netmgt.xml.event.Event;

public class ForceRescanState {
    private CollectionAgent m_agent;
    private EventProxy m_eventProxy;
    private boolean m_forceRescanSent = false;

    public ForceRescanState(CollectionAgent agent, EventProxy eventProxy) {
        this.m_agent = agent;
        this.m_eventProxy = eventProxy;
    }

    public EventProxy getEventProxy() {
        return this.m_eventProxy;
    }

    public Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public Event createForceResanEvent() {
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/forceRescan");
        newEvent.setSource("SNMPServiceMonitor");
        newEvent.setInterface(this.m_agent.getHostAddress());
        newEvent.setService("SNMP");
        newEvent.setHost(this.determineLocalHostName());
        newEvent.setTime(EventConstants.formatToString(new Date()));
        newEvent.setNodeid((long)this.m_agent.getNodeId());
        return newEvent;
    }

    String determineLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.log().warn((Object)"initialize: Unable to resolve local host name.", (Throwable)e);
            return "unresolved.host";
        }
    }

    public CollectionAgent getAgent() {
        return this.m_agent;
    }

    void sendForceRescanEvent() {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("generateForceRescanEvent: interface = " + this.getAgent().getHostAddress()));
        }
        try {
            this.getEventProxy().send(this.createForceResanEvent());
        }
        catch (EventProxyException e) {
            this.log().error((Object)"generateForceRescanEvent: Unable to send forceRescan event.", (Throwable)e);
        }
    }

    void rescanIndicated() {
        if (!this.m_forceRescanSent) {
            this.sendForceRescanEvent();
            this.m_forceRescanSent = true;
        }
    }
}

