/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.ScheduledOutagesDao;
import org.opennms.netmgt.config.CollectdConfig;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.dao.CollectorConfigDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectorConfigDaoImpl
implements CollectorConfigDao {
    private ScheduledOutagesDao m_scheduledOutagesDao;

    public CollectorConfigDaoImpl() {
        this.loadConfigFactory();
    }

    public void setScheduledOutageConfigDao(ScheduledOutagesDao scheduledOutagesDao) {
        this.m_scheduledOutagesDao = scheduledOutagesDao;
    }

    private void loadConfigFactory() {
        try {
            CollectdConfigFactory.init();
        }
        catch (MarshalException ex) {
            this.log().fatal((Object)"loadConfigFactory: Failed to load collectd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().fatal((Object)"loadConfigFactory: Failed to load collectd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().fatal((Object)"loadConfigFactory: Failed to load collectd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    public Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private CollectdConfig getConfig() {
        return CollectdConfigFactory.getInstance().getCollectdConfig();
    }

    public int getSchedulerThreads() {
        return this.getConfig().getThreads();
    }

    public Collection<Collector> getCollectors() {
        return this.getConfig().getConfig().getCollectorCollection();
    }
}

