/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.Attribute;
import org.opennms.netmgt.collectd.AttributeGroup;
import org.opennms.netmgt.collectd.AttributeGroupType;
import org.opennms.netmgt.collectd.AttributeType;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionSetVisitor;
import org.opennms.netmgt.collectd.ResourceIdentifier;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.snmp.SnmpValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionResource
implements ResourceIdentifier {
    private ResourceType m_resourceType;
    private Map<AttributeGroupType, AttributeGroup> m_groups = new HashMap<AttributeGroupType, AttributeGroup>();

    public CollectionResource(ResourceType def) {
        this.m_resourceType = def;
    }

    public ResourceType getResourceType() {
        return this.m_resourceType;
    }

    public abstract CollectionAgent getCollectionAgent();

    public abstract Collection<AttributeType> getAttributeTypes();

    public abstract boolean shouldPersist(ServiceParameters var1);

    @Override
    public String getOwnerName() {
        return this.getCollectionAgent().getHostAddress();
    }

    @Override
    public abstract File getResourceDir(RrdRepository var1);

    protected abstract int getType();

    public Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public boolean rescanNeeded() {
        return false;
    }

    public void setAttributeValue(AttributeType type, SnmpValue val) {
        Attribute attr = new Attribute(this, type, val);
        this.addAttribute(attr);
    }

    private void addAttribute(Attribute attr) {
        AttributeGroup group = this.getGroup(attr.getAttributeType().getGroupType());
        this.log().debug((Object)("Adding attribute " + attr.getClass().getName() + ": " + attr + " to group " + group));
        group.addAttribute(attr);
    }

    private AttributeGroup getGroup(AttributeGroupType groupType) {
        AttributeGroup group = this.m_groups.get(groupType);
        if (group == null) {
            group = new AttributeGroup(this, groupType);
            this.m_groups.put(groupType, group);
        }
        return group;
    }

    public void visit(CollectionSetVisitor visitor) {
        visitor.visitResource(this);
        for (AttributeGroup group : this.getGroups()) {
            group.visit(visitor);
        }
        visitor.completeResource(this);
    }

    protected Collection<AttributeGroup> getGroups() {
        return this.m_groups.values();
    }
}

